/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer.fileservices;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.FileAttributes;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileInputStream;
import com.ibm.as400.access.IFSFileOutputStream;
import com.ibm.as400.access.IFSRandomAccessFile;
import com.ibm.as400.access.IFSTextFileInputStream;
import com.ibm.as400.access.IFSTextFileOutputStream;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.Permission;
import com.installshield.util.LocalizedStringResolver;
import com.zerog.ia.installer.iseries.service.i5OSService;
import com.zerog.ia.installer.iseries.service.i5OSServiceFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Vector;

public class I5FileFolder
extends Flexeraak0 {
    private static final String copyright = "(C) Copyright IBM Corporation 2000.";
    public static final String SEPARATOR = "/";
    private static final char SEPARATOR_CHAR = '/';
    private transient i5OSService i5;
    private IFSFile myDefaultFile;
    private int ccsid;
    private static final boolean NOISY = System.getProperty("debug.I5FileService") != null;

    private i5OSService getI5Service() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (this.i5 == null) {
            this.i5 = i5OSServiceFactory.newInstance();
        }
        return this.i5;
    }

    public I5FileFolder(i5OSService i5OSService2, String string) {
        super(string);
        try {
            this.i5 = i5OSService2;
            this.myDefaultFile = new IFSFile(i5OSService2.geti5(), i5OSService2.createIFSFile(string));
            this.ccsid = i5OSService2.getCCSID(this.myDefaultFile);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public I5FileFolder(i5OSService i5OSService2) {
        super(null);
        this.i5 = i5OSService2;
    }

    public I5FileFolder(String string) {
        super(string);
        try {
            this.myDefaultFile = new IFSFile(this.getI5Service().geti5(), string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int deleteFile(String string) throws IOException {
        block8: {
            if (NOISY) {
                System.out.println("in deleteFile(" + string + ")");
            }
            try {
                if (this.getI5Service().isInstallRemote()) {
                    File file = new File(string);
                    if (!file.exists()) {
                        IFSFile iFSFile = new IFSFile(this.getI5Service().geti5(), this.getI5Service().normalizePathToi5(string));
                        if (iFSFile.delete()) {
                            return 0;
                        }
                        throw new IOException("could not delete file " + this.getI5Service().normalizePathToi5(string));
                    }
                    if (NOISY) {
                        System.out.println("    Deleting file on local machine:");
                        System.out.println("    file = " + string);
                    }
                    break block8;
                }
                this.deleteFile(this.getI5Service().normalizePathToi5(string));
                return 0;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new IOException(exception.getLocalizedMessage());
            }
        }
        return 0;
    }

    public int deleteDirectory(String string) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException, Exception {
        string = this.getI5Service().normalizePathToi5(string);
        if (NOISY) {
            System.out.println("in deleteDirectory(" + string + ")");
        }
        return this.deleteDirectory(string, true, false);
    }

    public int deleteDirectory(String string, boolean bl, boolean bl2) throws Exception {
        try {
            IFSFile iFSFile;
            string = this.getI5Service().normalizePathToi5(string);
            if (NOISY) {
                System.out.println("in deleteDirectory(" + string + ", " + bl + ", " + bl2 + ")");
            }
            if ((iFSFile = new IFSFile(this.getI5Service().geti5(), this.getI5Service().normalizePathToi5(string))).isDirectory() && iFSFile.getParent() == null) {
                throw new IOException("deleteDirectory cannot be used to delete the root directory");
            }
            if (iFSFile.isDirectory()) {
                IFSFile iFSFile2;
                int n;
                String[] stringArray = iFSFile.list();
                if (bl && stringArray.length > 0) {
                    throw new IOException("directory " + string + " is not empty");
                }
                if (!bl2) {
                    for (n = 0; n < stringArray.length; ++n) {
                        iFSFile2 = new IFSFile(this.getI5Service().geti5(), iFSFile, stringArray[n]);
                        if (!iFSFile2.isDirectory()) continue;
                        throw new IOException("directory " + string + " contains subdirectories");
                    }
                }
                for (n = 0; n < stringArray.length; ++n) {
                    iFSFile2 = new IFSFile(this.getI5Service().geti5(), iFSFile, stringArray[n]);
                    if (NOISY) {
                        System.out.println("Looking at " + iFSFile2.getAbsolutePath());
                    }
                    if (iFSFile2.isFile()) {
                        this.deleteFile(iFSFile2.getAbsolutePath());
                        continue;
                    }
                    if (!iFSFile2.isDirectory()) continue;
                    this.deleteDirectory(iFSFile2.getAbsolutePath(), bl, bl2);
                }
                if (!iFSFile.delete()) {
                    throw new IOException("could not delete directory " + string);
                }
            }
            return 0;
        }
        catch (IOException iOException) {
            throw new Exception(iOException);
        }
    }

    public void createDirectory(String string) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException {
        if (NOISY) {
            System.out.println("in createDirectory(" + string + ")");
        }
        string = this.getI5Service().normalizePathToi5(string);
        try {
            if (this.getI5Service().isInstallRemote()) {
                IFSFile iFSFile = new IFSFile(this.getI5Service().geti5(), string);
                this.getI5Service().makeI5Dirs(iFSFile);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createSymbolicLink(String string, String string2, boolean bl) throws IOException {
        if (NOISY) {
            System.out.println("in createSymbolLink(" + string + ", " + string2 + ", " + bl + ")");
        }
        try {
            if (this.getI5Service().isInstallRemote()) {
                string2 = this.getI5Service().normalizePathToi5(string);
                CommandCall commandCall = new CommandCall(this.getI5Service().geti5());
                commandCall.run("QSYS/QSH CMD('ln -s " + string2 + "')");
                System.out.println("in createSymbolLink(" + string + ", " + string2 + ", " + bl + ") remotely");
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getLocalizedMessage());
            throw iOException;
        }
    }

    public void setFileTimes(String string, long l, long l2, long l3) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException {
        string = this.getI5Service().normalizePathToi5(string);
        this.setFileCreated(string, l);
        this.setFileModified(string, l3);
    }

    public void setFileCreated(String string, long l) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException {
        this.setFileModified(this.getI5Service().normalizePathToi5(string), l);
    }

    public void setFileModified(String string, long l) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException {
        string = this.getI5Service().normalizePathToi5(string);
        try {
            IFSFile iFSFile = new IFSFile(this.getI5Service().geti5(), string);
            iFSFile.setLastModified(l);
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getLocalizedMessage());
            throw iOException;
        }
    }

    public boolean fileExists(String string) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException {
        boolean bl = true;
        String string2 = this.getI5Service().normalizePathToi5(string);
        try {
            IFSFile iFSFile = new IFSFile(this.getI5Service().geti5(), string2);
            bl = iFSFile.exists();
            if (NOISY) {
                System.out.println("In //AS400FileServiceImpl.fileExists(" + string2 + ") returning " + bl);
            }
            return bl;
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getLocalizedMessage());
            throw iOException;
        }
    }

    public boolean isDirectory(String string) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException {
        if (NOISY) {
            System.out.println("in isDirectory(" + string + ")");
        }
        string = this.getI5Service().normalizePathToi5(string);
        try {
            IFSFile iFSFile = new IFSFile(this.getI5Service().geti5(), string);
            return iFSFile.isDirectory();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean isDirectoryWritable(String string) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException {
        return this.canRead(this.getI5Service().normalizePathToi5(string));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Flexeraak8 delete() throws Flexeraak7 {
        Flexeraak8 flexeraak8 = new Flexeraak8(null, this.af());
        if (Flexeraak3.an(this.af())) {
            flexeraak8.as(true);
            return flexeraak8;
        }
        try {
            if (!this.ae()) {
                this.myDefaultFile.delete();
                return flexeraak8;
            }
            if (this.myDefaultFile.delete()) return flexeraak8;
        }
        catch (Exception exception) {
            Flexeraavd.aa(exception.toString());
            flexeraak8.am(Flexeraak8.ao);
        }
        return flexeraak8;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canRead(String string) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException {
        if (NOISY) {
            System.out.println("in canRead(" + string + ")");
        }
        string = this.getI5Service().normalizePathToi5(string);
        IFSFile iFSFile = new IFSFile(this.getI5Service().geti5(), string);
        if (!iFSFile.exists()) return false;
        try {
            boolean bl;
            if (string.equals(SEPARATOR)) {
                bl = true;
            } else {
                if (iFSFile.exists() && iFSFile.isDirectory()) {
                    return true;
                }
                bl = iFSFile.canRead();
            }
            if (!NOISY) return bl;
            System.out.println("Exists, and returning " + bl);
            return bl;
        }
        catch (Exception exception) {
            try {
                return false;
            }
            catch (Exception exception2) {
                if (!NOISY) return false;
                System.out.println(exception2.getLocalizedMessage());
                exception2.printStackTrace();
                return false;
            }
        }
    }

    @Override
    public Flexeraak8 putStream(InputStream inputStream, boolean bl) throws Flexeraak7 {
        Flexeraak8 flexeraak8 = new Flexeraak8(null, this.af());
        if (!this.ae()) {
            try {
                IFSFileOutputStream iFSFileOutputStream = new IFSFileOutputStream(this.myDefaultFile);
                byte[] byArray = new byte[1024];
                System.err.println("Remote install - temporary outputfile: " + this.myDefaultFile.getAbsolutePath());
                boolean bl2 = false;
                int n = inputStream.read(byArray);
                while (n > 0) {
                    iFSFileOutputStream.write(byArray, 0, n);
                    n = inputStream.read(byArray);
                }
                inputStream.close();
                iFSFileOutputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new Flexeraak7(exception.getMessage(), "write", exception, this.af());
            }
        }
        OutputStream outputStream = null;
        try {
            outputStream = this.getOutputStream();
            this.ab(inputStream, outputStream, bl);
            flexeraak8 = ((Flexeraale)outputStream).ae();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Flexeraak7(exception.getMessage(), "write", exception, this.af());
        }
        return flexeraak8;
    }

    public String[] getDirectoryList(String string, int n) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException {
        String[] stringArray;
        block11: {
            if (NOISY) {
                System.out.println("in getDirectoryList(" + string + ", " + n + ")");
            }
            stringArray = new String[]{};
            string = this.getI5Service().normalizePathToi5(string);
            try {
                IFSFile iFSFile = new IFSFile(this.getI5Service().geti5(), string);
                Vector<String> vector = new Vector<String>();
                if (iFSFile.exists() && iFSFile.isDirectory()) {
                    int n2;
                    String[] stringArray2 = iFSFile.list();
                    block7: for (n2 = 0; n2 < stringArray2.length; ++n2) {
                        IFSFile iFSFile2 = new IFSFile(this.getI5Service().geti5(), string, stringArray2[n2]);
                        String string2 = iFSFile2.getAbsolutePath();
                        iFSFile2 = new IFSFile(this.getI5Service().geti5(), string2);
                        switch (n) {
                            default: {
                                continue block7;
                            }
                            case 2: {
                                vector.addElement(stringArray2[n2]);
                                continue block7;
                            }
                            case 1: {
                                if (!iFSFile2.isDirectory()) continue block7;
                                vector.addElement(stringArray2[n2]);
                                continue block7;
                            }
                            case 0: {
                                if (!iFSFile2.isFile()) continue block7;
                                vector.addElement(stringArray2[n2]);
                            }
                        }
                    }
                    n2 = vector.size();
                    stringArray = new String[n2];
                    for (int i = 0; i < n2; ++i) {
                        stringArray[i] = (String)vector.elementAt(i);
                        if (!NOISY) continue;
                        System.out.println("Found " + stringArray[i]);
                    }
                }
            }
            catch (Exception exception) {
                if (!NOISY) break block11;
                System.out.println(exception.getLocalizedMessage());
            }
        }
        return stringArray;
    }

    public String getParent(String string) {
        if (NOISY) {
            System.out.println("in getParent(" + string + ")");
        }
        try {
            string = this.getI5Service().normalizePathToi5(string);
            IFSFile iFSFile = new IFSFile(this.getI5Service().geti5(), this.getI5Service().createIFSFile(string));
            return iFSFile.getParent();
        }
        catch (Exception exception) {
            if (NOISY) {
                System.out.println(exception.getLocalizedMessage());
                exception.printStackTrace();
            }
            return null;
        }
    }

    public int moveFile(String string, String string2, boolean bl) throws IOException {
        try {
            if (NOISY) {
                System.out.println("in moveFile(" + string + "," + string2 + "," + bl + ")");
            }
            if (this.getI5Service().isInstallRemote()) {
                File file = new File(string);
                if (!file.exists()) {
                    string = this.getI5Service().normalizePathToi5(string);
                    string2 = this.getI5Service().normalizePathToi5(string2);
                    if (NOISY) {
                        System.out.println("    Moving files on remote machine:");
                        System.out.println("        source = " + string);
                        System.out.println("        destination = " + string2);
                    }
                    IFSFile iFSFile = new IFSFile(this.getI5Service().geti5(), string);
                    IFSFile iFSFile2 = new IFSFile(this.getI5Service().geti5(), string2);
                    if (iFSFile2.exists() && !bl) {
                        throw new IOException(string2);
                    }
                    String string3 = string2.substring(0, string2.lastIndexOf(SEPARATOR));
                    if (!string3.equals("")) {
                        this.createDirectory(string3);
                    }
                    IFSFileInputStream iFSFileInputStream = (IFSFileInputStream)this.getI5Service().retrieveTextInStream(this.getI5Service().geti5(), string2, this.ccsid);
                    IFSFileOutputStream iFSFileOutputStream = this.ccsid != -1 ? new IFSFileOutputStream(this.getI5Service().geti5(), string2, this.ccsid) : new IFSFileOutputStream(this.getI5Service().geti5(), string2);
                    byte[] byArray = new byte[10240];
                    int n = iFSFileInputStream.read(byArray);
                    while (n > 0) {
                        iFSFileOutputStream.write(byArray, 0, n);
                        n = iFSFileInputStream.read(byArray);
                    }
                    iFSFileInputStream.close();
                    iFSFileOutputStream.close();
                    if (!iFSFile.delete() && NOISY) {
                        System.out.println("Couldn't delete " + iFSFile.getAbsolutePath());
                    }
                    return 0;
                }
                if (NOISY) {
                    System.out.println("    Moving files on local machine:");
                    System.out.println("        source = " + string);
                    System.out.println("        destination = " + string2);
                }
                return 0;
            }
            return 0;
        }
        catch (Exception exception) {
            throw new IOException(exception.getLocalizedMessage());
        }
    }

    public String getNamedDirectory(String string) throws IOException {
        if (string.equals("home")) {
            return this.getHomeDirectory();
        }
        if (string.equals("install")) {
            return "";
        }
        if (string.equals("lib")) {
            return this.getLibraryDirectory();
        }
        if (string.equals("log")) {
            return this.getLogFileDirectory();
        }
        if (string.equals("temp")) {
            return this.getTempDirectory();
        }
        if (string.equals("timestamp")) {
            return this.createTimeStamp();
        }
        throw new IOException("The directory name is not supported. ");
    }

    public String[] getPartitionNames() throws IOException {
        if (NOISY) {
            System.out.println("in getPartitionNames:");
        }
        String[] stringArray = new String[1];
        stringArray[0] = "";
        return stringArray;
    }

    public long getPartitionFreeSpace(String string) throws IOException {
        if (NOISY) {
            System.out.println("in getPartitionFreeSpace(" + string + ")");
        }
        try {
            IFSFile iFSFile = new IFSFile(this.getI5Service().geti5(), SEPARATOR);
            return iFSFile.getFreeSpace();
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getLocalizedMessage());
            throw iOException;
        }
    }

    public long getPartitionFreeSpace(String string, long l) throws IOException {
        return this.getPartitionFreeSpace(string);
    }

    public void setFileAttributesCCSID(int n, FileAttributes fileAttributes) throws IOException, AS400SecurityException, InterruptedException, ObjectDoesNotExistException, ErrorCompletingRequestException {
        fileAttributes.setCcsid(n);
    }

    public int getFileAttributesCCSID(FileAttributes fileAttributes) throws IOException, AS400SecurityException, InterruptedException, ObjectDoesNotExistException, ErrorCompletingRequestException {
        return fileAttributes.getCcsid();
    }

    public void setFileExecutable(String string) throws IOException {
        if (NOISY) {
            System.out.println("in setFileExecutable");
        }
    }

    public String getJavaCommand(String string, String[] stringArray, String string2) throws IOException {
        try {
            if (this.getI5Service().isInstallRemote()) {
                throw new IOException("OPERATION_NOT_SUPPORTED");
            }
            return "RUNJVA " + string + "CLASSPATH(" + string2 + ")";
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getLocalizedMessage());
            throw iOException;
        }
    }

    public String getFileOwner(String string) throws IOException {
        try {
            string = this.getI5Service().normalizePathToi5(string);
            Permission permission = new Permission(this.getI5Service().geti5(), string);
            return permission.getOwner();
        }
        catch (Exception exception) {
            if (NOISY) {
                System.out.println(exception.getLocalizedMessage());
            }
            return "";
        }
    }

    public void setFileOwner(String string, String string2) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException, Exception {
        string = this.getI5Service().normalizePathToi5(string);
        if (NOISY) {
            System.out.println("in setFileOwner of " + string + " to " + string2);
        }
        i5OSService i5OSService2 = this.getI5Service();
        i5OSService2.runCLCommand(i5OSService2.geti5(), "CHGOWN OBJ('" + string + "') NEWOWN(" + string2 + ")", null);
    }

    public String getFileOwnerGroup(String string) throws IOException {
        try {
            string = this.getI5Service().normalizePathToi5(string);
            Permission permission = new Permission(this.getI5Service().geti5(), string);
            return permission.getPrimaryGroup();
        }
        catch (Exception exception) {
            if (NOISY) {
                System.out.println(exception.getLocalizedMessage());
            }
            return "";
        }
    }

    public void setFileOwnerGroup(String string, String string2) throws IOException {
    }

    public boolean supportsLongFileNames(String string) throws IOException {
        return true;
    }

    public boolean isPartitionWritable(String string) throws IOException {
        return true;
    }

    public int getFileSize(String string) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException {
        string = this.getI5Service().normalizePathToi5(string);
        if (NOISY) {
            System.out.println("in getFileSize(" + string + ")");
        }
        try {
            if (this.getI5Service().isInstallRemote()) {
                IFSFile iFSFile = new IFSFile(this.getI5Service().geti5(), string);
                return (int)iFSFile.length();
            }
            return 0;
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getLocalizedMessage());
            throw iOException;
        }
    }

    public void updateBinaryFile(String string, byte[] byArray, int n) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException {
        string = this.getI5Service().normalizePathToi5(string);
        if (NOISY) {
            System.out.println("in updateBinaryFile");
        }
        try {
            if (this.getI5Service().isInstallRemote()) {
                IFSRandomAccessFile iFSRandomAccessFile = new IFSRandomAccessFile(this.getI5Service().geti5(), this.getI5Service().normalizePathToi5(string), "rw");
                iFSRandomAccessFile.seek((long)n);
                iFSRandomAccessFile.write(byArray);
                iFSRandomAccessFile.close();
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getLocalizedMessage());
            throw iOException;
        }
    }

    public int readBinaryFile(String string, byte[] byArray, int n, int n2) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException {
        string = this.getI5Service().normalizePathToi5(string);
        if (NOISY) {
            System.out.println("in readBinaryFile");
        }
        try {
            if (this.getI5Service().isInstallRemote()) {
                int n3 = 0;
                if (byArray == null) {
                    throw new IOException("Buffer cannot be null");
                }
                if (byArray.length < n2) {
                    throw new IOException("Buffer is smaller than size indicated.");
                }
                IFSRandomAccessFile iFSRandomAccessFile = new IFSRandomAccessFile(this.getI5Service().geti5(), this.getI5Service().normalizePathToi5(string), "r");
                int n4 = iFSRandomAccessFile.skipBytes(n);
                if (n4 >= n) {
                    byte[] byArray2 = new byte[n2];
                    n3 = iFSRandomAccessFile.read(byArray2);
                    for (int i = 0; i < n3; ++i) {
                        byArray[i] = byArray2[i];
                    }
                }
                iFSRandomAccessFile.close();
                return n3;
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getLocalizedMessage());
            throw iOException;
        }
        return 0;
    }

    public void updateAsciiFile(String string, String[] stringArray, int n) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException {
        string = this.getI5Service().normalizePathToi5(string);
        if (NOISY) {
            System.out.println("in updateAsciiFile");
        }
        try {
            if (this.getI5Service().isInstallRemote()) {
                string = this.getI5Service().normalizePathToi5(string);
                Vector vector = this.readAsciiLines(string);
                int n2 = n;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (n2 < vector.size()) {
                        vector.setElementAt(stringArray[i], n2);
                    } else {
                        vector.addElement(stringArray[i]);
                    }
                    ++n2;
                }
                Object[] objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
                this.createAsciiFile(string, (String[])objectArray);
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getLocalizedMessage());
            throw iOException;
        }
    }

    public void createAsciiFile(String string, String[] stringArray) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException {
        string = this.getI5Service().normalizePathToi5(string);
        if (NOISY) {
            System.out.println("in createAsciiFile");
        }
        try {
            if (this.getI5Service().isInstallRemote()) {
                this.writeAsciiFile(string, stringArray, false);
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getLocalizedMessage());
            throw iOException;
        }
    }

    public void createBinaryFile(String string, byte[] byArray) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException {
        string = this.getI5Service().normalizePathToi5(string);
        if (NOISY) {
            System.out.println("in createBinaryFile");
        }
        try {
            if (this.getI5Service().isInstallRemote()) {
                this.writeBinaryFile(string, byArray, false);
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getLocalizedMessage());
            throw iOException;
        }
    }

    @Override
    public Flexeraak8 renameTo(String string) throws Flexeraak7, FileNotFoundException {
        Flexeraak8 flexeraak8 = new Flexeraak8(null, string);
        try {
            Flexeraak3 flexeraak3 = new Flexeraak3(string);
            IFSFile iFSFile = new IFSFile(this.getI5Service().geti5(), string);
            if (this.getI5Service().testIFSPathExists(iFSFile.getAbsolutePath())) {
                System.err.println("rename:destination file existed.");
            }
            if (!this.getI5Service().deleteIFS(iFSFile)) {
                InputStream inputStream = null;
                try {
                    inputStream = this.getStream();
                }
                catch (Flexeraak7 flexeraak7) {
                    flexeraak8.aq(this.af());
                    flexeraak8.am(Flexeraak8.an);
                    return flexeraak8;
                }
            }
            return flexeraak8;
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getLocalizedMessage());
            Flexeraavd.aa(iOException.toString());
            flexeraak8.am(Flexeraak8.ao);
            return flexeraak8;
        }
    }

    public void appendToAsciiFile(String string, String[] stringArray) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException {
        string = this.getI5Service().normalizePathToi5(string);
        if (NOISY) {
            System.out.println("in appendToAsciiFile");
        }
        try {
            if (this.getI5Service().isInstallRemote()) {
                this.writeAsciiFile(string, stringArray, true);
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getLocalizedMessage());
            throw iOException;
        }
    }

    public void appendBinaryFile(String string, byte[] byArray) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException {
        string = this.getI5Service().normalizePathToi5(string);
        if (NOISY) {
            System.out.println("in appendBinaryFile");
        }
        try {
            if (this.getI5Service().isInstallRemote()) {
                this.writeBinaryFile(string, byArray, true);
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getLocalizedMessage());
            throw iOException;
        }
    }

    @Override
    public InputStream getStream() throws Flexeraak7, FileNotFoundException {
        try {
            FileInputStream fileInputStream = (FileInputStream)this.getI5Service().retrieveTextInStream(this.getI5Service().geti5(), this.myDefaultFile.getAbsolutePath(), this.ccsid);
            return fileInputStream;
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getLocalizedMessage());
            return null;
        }
    }

    public String[] readAsciiFile(String string) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException {
        string = this.getI5Service().normalizePathToi5(string);
        if (NOISY) {
            System.out.println("in readAsciiFile (one parm)");
        }
        try {
            if (!this.getI5Service().isInstallRemote()) {
                String[] stringArray = new String[1];
                stringArray[0] = "";
                return stringArray;
            }
            Vector vector = this.readAsciiLines(string);
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            if (NOISY) {
                for (int i = 0; i < objectArray.length; ++i) {
                    System.out.println("Line " + i + "=" + (String)objectArray[i]);
                }
            }
            return objectArray;
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getLocalizedMessage());
            throw iOException;
        }
    }

    public int readAsciiFile(String string, String[] stringArray, int n, int n2) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException {
        string = this.getI5Service().normalizePathToi5(string);
        if (NOISY) {
            System.out.println("in readAsciiFile (lotsa parms)");
        }
        try {
            if (!this.getI5Service().isInstallRemote()) {
                return 0;
            }
            if (stringArray == null) {
                throw new IOException("Buffer cannot be null");
            }
            if (stringArray.length < n2) {
                throw new IOException("Buffer is smaller than size indicated.");
            }
            Vector vector = this.readAsciiLines(this.getI5Service().normalizePathToi5(string));
            Vector vector2 = new Vector();
            int n3 = 0;
            for (int i = n; i < n + n2; ++i) {
                if (i > vector.size()) continue;
                vector2.addElement(vector.elementAt(i));
                ++n3;
            }
            vector2.copyInto(stringArray);
            return n3;
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getLocalizedMessage());
            throw iOException;
        }
    }

    public int getAsciiFileLineCount(String string) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException {
        string = this.getI5Service().normalizePathToi5(string);
        if (NOISY) {
            System.out.println("in getAsciiLineCount");
        }
        try {
            if (!this.getI5Service().isInstallRemote()) {
                return 0;
            }
            Vector vector = this.readAsciiLines(this.getI5Service().normalizePathToi5(string));
            return vector.size();
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getLocalizedMessage());
            throw iOException;
        }
    }

    private void writeAsciiFile(String string, String[] stringArray, boolean bl) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException {
        string = this.getI5Service().normalizePathToi5(string);
        if (NOISY) {
            System.out.println("in writeAsciiFile (private)");
        }
        try {
            IFSFile iFSFile = new IFSFile(this.getI5Service().geti5(), this.getI5Service().normalizePathToi5(string));
            this.createDirectory(iFSFile.getParent());
            IFSTextFileOutputStream iFSTextFileOutputStream = new IFSTextFileOutputStream(this.getI5Service().geti5(), this.getI5Service().normalizePathToi5(string), -4, bl);
            for (int i = 0; i < stringArray.length; ++i) {
                Object object;
                block8: {
                    block7: {
                        object = stringArray[i];
                        System.out.println("content[i]" + stringArray[i]);
                        if (!((String)object).endsWith("\r\n")) break block7;
                        if (((String)object).endsWith("\r")) break block8;
                    }
                    object = !((String)object).endsWith("\r") ? (String)object + "\r" : (String)object + "\r\n";
                }
                iFSTextFileOutputStream.write((String)object);
            }
            iFSTextFileOutputStream.flush();
            iFSTextFileOutputStream.close();
        }
        catch (Exception exception) {
            throw new IOException(exception.getLocalizedMessage());
        }
    }

    private void writeBinaryFile(String string, byte[] byArray, boolean bl) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException {
        string = this.getI5Service().normalizePathToi5(string);
        if (NOISY) {
            System.out.println("in writeBinaryFile (private)");
        }
        try {
            IFSFile iFSFile = new IFSFile(this.getI5Service().geti5(), this.getI5Service().normalizePathToi5(string));
            this.createDirectory(iFSFile.getParent());
            IFSFileOutputStream iFSFileOutputStream = new IFSFileOutputStream(this.getI5Service().geti5(), this.getI5Service().normalizePathToi5(string), -4, bl);
            iFSFileOutputStream.write(byArray);
            iFSFileOutputStream.close();
        }
        catch (Exception exception) {
            throw new IOException(exception.getLocalizedMessage());
        }
    }

    private Vector readAsciiLines(String string) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException {
        string = this.getI5Service().normalizePathToi5(string);
        if (NOISY) {
            System.out.println("in readAsciiLines (private) with " + string);
        }
        try {
            string = this.getI5Service().normalizePathToi5(string);
            Vector<Object> vector = new Vector<Object>();
            IFSTextFileInputStream iFSTextFileInputStream = new IFSTextFileInputStream(this.getI5Service().geti5(), string);
            String string2 = iFSTextFileInputStream.read(1);
            Object object = "";
            while (!string2.equals("")) {
                object = (String)object + string2;
                if (string2.equals("\n")) {
                    vector.addElement(object);
                    object = "";
                }
                string2 = iFSTextFileInputStream.read(1);
            }
            if (object != "") {
                vector.addElement(object);
            }
            iFSTextFileInputStream.close();
            vector.trimToSize();
            if (NOISY) {
                System.out.println("Leaving readAsciiLines");
            }
            return vector;
        }
        catch (Exception exception) {
            throw new IOException(exception.getLocalizedMessage());
        }
    }

    public String createTimeStamp() {
        return "" + new Date().getTime();
    }

    public String getLibraryDirectory() throws IOException {
        return SEPARATOR;
    }

    @Override
    public OutputStream getOutputStream() throws FileNotFoundException, IOException {
        try {
            return new IFSFileOutputStream(this.getI5Service().geti5(), this.af());
        }
        catch (Exception exception) {
            throw new IOException(exception.getLocalizedMessage());
        }
    }

    public String getLogFileDirectory() {
        return "/InstallLogs";
    }

    public String getStandardInstallDirectory() throws IOException, Exception {
        if (NOISY) {
            System.out.println("in getStandardInstallDirectory");
        }
        if (this.getI5Service().isInstallRemote()) {
            IFSFile iFSFile = new IFSFile(this.getI5Service().geti5(), SEPARATOR);
        }
        return SEPARATOR;
    }

    public String getTempDirectory() throws IOException {
        return "/tmp/InstallShield";
    }

    public String getHomeDirectory() {
        if (NOISY) {
            System.out.println("in getHomeDirectory");
        }
        return SEPARATOR;
    }

    public void validateFileName(String string) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException {
        block5: {
            block4: {
                if (NOISY) {
                    System.out.println("Validating file name: " + string);
                }
                String string2 = this.getI5Service().normalizePathToi5(string);
                if (string2.indexOf(":") != -1) break block4;
                if (string2.indexOf("*") != -1) break block4;
                if (string2.indexOf("?") != -1) break block4;
                if (string2.indexOf("'") != -1) break block4;
                if (string2.indexOf("~") != -1) break block4;
                if (string2.indexOf(">") != -1) break block4;
                if (string2.indexOf("<") != -1) break block4;
                if (string2.indexOf("\"") == -1) break block5;
            }
            throw new IOException(LocalizedStringResolver.resolve((String)"com.installshield.wizard.i18n.WizardResources", (String)"FileServiceImpl.invalidFileOrDirectory", (String[])new String[]{string}));
        }
    }

    public String[] createDirectoryReturnNew(String string) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException, Exception {
        Object[] objectArray;
        Object[] objectArray2 = this.getI5Service().normalizePathToi5(string);
        Vector<Object[]> vector = new Vector<Object[]>();
        try {
            objectArray = objectArray2;
            IFSFile iFSFile = new IFSFile(this.getI5Service().geti5(), this.getI5Service().createIFSFile((String)objectArray));
            while (objectArray != null && !this.getI5Service().testIFSWithTempPathExists(iFSFile.getAbsolutePath())) {
                vector.addElement(objectArray);
                objectArray = this.getParent((String)objectArray);
                iFSFile = new IFSFile(this.getI5Service().geti5(), (String)objectArray);
            }
            IFSFile iFSFile2 = new IFSFile(this.getI5Service().geti5(), (String)objectArray2);
            this.getI5Service().makeI5Dirs(iFSFile2);
        }
        catch (Exception exception) {
            throw new IOException(LocalizedStringResolver.resolve((String)"error", (String)"Files.couldNotCreateDir", (String[])new String[]{objectArray2}));
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String getSeparator() throws IOException {
        return SEPARATOR;
    }

    public char getSeparatorChar() throws IOException {
        return '/';
    }

    public String getPathSeparator() throws IOException {
        return SEPARATOR;
    }

    public char getPathSeparatorChar() throws IOException {
        return '/';
    }

    public boolean isAbsolute(String string) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException {
        string = this.normalizeFileName(string);
        return string.startsWith(this.getSeparator());
    }

    public boolean isFile(String string) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException, Exception {
        String string2 = this.getI5Service().normalizePathToi5(string);
        try {
            IFSFile iFSFile = new IFSFile(this.getI5Service().geti5(), string2);
            return iFSFile.isFile();
        }
        catch (Exception exception) {
            throw new IOException(LocalizedStringResolver.resolve((String)"error", (String)"Files.fileNotExist", (String[])new String[]{string}));
        }
    }

    public String normalizeFileName(String string, char c) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException {
        if (string == null) {
            throw new NullPointerException("fileName");
        }
        String string2 = this.getI5Service().normalizePathToi5(string);
        return string2.replace('/', c);
    }

    public String normalizeFileName(String string) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException {
        if (string == null) {
            throw new NullPointerException("fileName");
        }
        return this.getI5Service().normalizePathToi5(string);
    }
}

