/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer;

import com.zerog.ia.installer.AbortUpgradeConsole;
import com.zerog.ia.installer.AbortUpgradeGUI;
import com.zerog.ia.installer.Installer;
import com.zerog.ia.installer.InstanceDetector;
import com.zerog.ia.installer.UpgradableProduct;
import com.zerog.ia.installer.UpgradeConfiguration;
import com.zerog.ia.installer.UpgradeCustomizerConsole;
import com.zerog.ia.installer.UpgradeCustomizerGUI;
import com.zerog.ia.installer.actions.AbortInstallAction;
import com.zerog.ia.installer.rules.CompareVariable;
import com.zerog.ia.installer.util.VariableFacade;
import com.zerog.ia.installer.util.VariableManager;
import com.zerog.ia.installer.util.Version;
import com.zerog.registry.UUID;
import com.zerog.util.ZGUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Vector;

public class RunTimeUpgradeManager {
    public static final String UNINSTALL_PART_OF_UPGRADE = "uninstall.part.of.upgrade";
    public static final String UPGRADE_PROCESS_EXIT_CODE_VARIABLE = "$IA_INTERNAL_UPGRADE_UNINSTALL_EXITCODE$";
    private List<UpgradeConfiguration> projectSpecifiedUpgradeConfigurations = new Vector<UpgradeConfiguration>();
    private List<String> pathsOfInstancesSatisfyingUpgradeConfiguration = new Vector<String>();
    private List<UpgradableProduct> productsEligibleForUpgrade = new Vector<UpgradableProduct>();
    private Map<String, String> mapsOfUpgradedProductsPathWithMaintenanceMode = new HashMap<String, String>();
    private Installer installer = null;
    private List<Flexeraapu> availableProductsOnTheSystemBasedonProductId = new ArrayList<Flexeraapu>();
    private List<Flexeraapu> availableProductsOnTheSystemBasedonUpgradeId = new ArrayList<Flexeraapu>();
    private List<UpgradableProduct> userSelectedProducts = new ArrayList<UpgradableProduct>();
    private List<UpgradableProduct> productsWhoseUninstallationFailed = new Vector<UpgradableProduct>();
    private ArrayList<String> higherVersionInstalledProductsPath = new ArrayList();
    public ArrayList<String> upgradedProductsPathWithMaintenanceMode = new ArrayList();
    private ArrayList<String> higherVersionInstalledProductsPathWithUninstaller = new ArrayList();
    private static RunTimeUpgradeManager runTimeUpgradeManager = null;
    public UpgradeCustomizerGUI upgradeCustomizerGUI;
    public UpgradeCustomizerConsole upgradeCustomizerConsole;
    public boolean isHigherVersionAvailable = false;
    private AbortUpgradeGUI abortUpgradeGUI;
    private AbortUpgradeConsole abortUpgradeConsole;
    public Version maxConfigVersion;
    public Version minConfigVersion;
    public Version currentProdVersion;
    private static final String INSTALL_SCRIPT_NAME = "InstallScript.iap_xml";
    private int dialogOption = -1;
    private boolean returnValue;
    private boolean runningInUpgradeMode = false;
    private boolean isUpgradeMode = false;
    private boolean isUpgradeinMaintMode = false;
    private String maintModeLocation;
    private String displaySeperator = " || ";
    private String valueSeperator = "<>";

    private RunTimeUpgradeManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RunTimeUpgradeManager getInstance() {
        if (runTimeUpgradeManager != null) return runTimeUpgradeManager;
        Class<RunTimeUpgradeManager> clazz = RunTimeUpgradeManager.class;
        synchronized (RunTimeUpgradeManager.class) {
            if (runTimeUpgradeManager != null) return runTimeUpgradeManager;
            runTimeUpgradeManager = new RunTimeUpgradeManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return runTimeUpgradeManager;
        }
    }

    public synchronized void initializeUpgradeRun(Installer installer) {
        this.installer = installer;
        if (installer.getIsMergeModule()) {
            return;
        }
        List<UpgradeConfiguration> list = installer.getUpgradeSettings().getUpgradeConfigurationsList();
        for (UpgradeConfiguration upgradeConfiguration : list) {
            if (upgradeConfiguration.getDetectionBasedOn().equals("PRODUCT_CODE")) {
                this.availableProductsOnTheSystemBasedonProductId.addAll(this.detectAvailableInstancesOnThisMachineBasedonProductId(upgradeConfiguration));
                continue;
            }
            this.availableProductsOnTheSystemBasedonUpgradeId.addAll(this.detectAvailableInstancesOnThisMachineBasedonUpgradeId(installer));
        }
        if (!this.availableProductsOnTheSystemBasedonProductId.isEmpty()) {
            this.sortList(this.availableProductsOnTheSystemBasedonProductId);
        }
        if (!this.availableProductsOnTheSystemBasedonUpgradeId.isEmpty()) {
            this.sortList(this.availableProductsOnTheSystemBasedonUpgradeId);
        }
        this.isHigherVersionAvailable = this.checkIfHigherVersionOfInstancesAvailable(this.availableProductsOnTheSystemBasedonProductId);
        if (!this.isHigherVersionAvailable) {
            this.isHigherVersionAvailable = this.checkIfHigherVersionOfInstancesAvailable(this.availableProductsOnTheSystemBasedonUpgradeId);
        }
        this.findUpgradedInstancesWithMaintenanceModeEnabled();
        if (this.isHigherVersionAvailable && this.upgradedProductsPathWithMaintenanceMode.isEmpty()) {
            if (Flexeraaq7.ao() == 1 || Flexeraaq7.ao() == 2) {
                this.abortUpgradeGUI = new AbortUpgradeGUI();
                this.abortUpgradeGUI.createHigherVersionDialog();
            } else if (Flexeraaq7.ao() == 3) {
                this.abortUpgradeConsole = new AbortUpgradeConsole();
                this.abortUpgradeConsole.createHigherVersionDialog();
            } else if (Flexeraaq7.ao() == 4) {
                System.exit(8000);
            }
        } else if (this.isHigherVersionAvailable && !this.upgradedProductsPathWithMaintenanceMode.isEmpty()) {
            if (Flexeraaq7.ao() == 1 || Flexeraaq7.ao() == 2 || Flexeraaq7.ao() == 3) {
                this.displayUpgradeConfirmationDialog();
            }
        } else {
            this.findInstancesSatisfyingUpgradeCondition();
            this.isUpgradeMode = true;
            this.sortList(this.productsEligibleForUpgrade);
            this.addToPathsOfInstancesSatisfyingUpgradeConfiguration(this.productsEligibleForUpgrade);
            if (!installer.getUpgradeSettings().getAutomaticallyRemoveAllExistingInstallations()) {
                if (Flexeraaq7.ao() == 1 || Flexeraaq7.ao() == 2 || Flexeraaq7.ao() == 3) {
                    this.displayUpgradeConfirmationDialog();
                } else if (!this.productsEligibleForUpgrade.isEmpty()) {
                    this.userSelectedProducts.add(this.productsEligibleForUpgrade.get(0));
                    UpgradableProduct upgradableProduct = this.userSelectedProducts.get(0);
                    this.setUpgradeRelatedVariables(upgradableProduct);
                    this.triggerUpgradeInitialization();
                }
            } else {
                if (!this.productsEligibleForUpgrade.isEmpty()) {
                    this.setUpgradeRelatedVariables(this.productsEligibleForUpgrade.get(0));
                    this.setRunningInUpgradeMode(true);
                }
                this.uninstallAllUpgradableInstances();
            }
        }
    }

    private void setUpgradeRelatedVariables(UpgradableProduct upgradableProduct) {
        String string = upgradableProduct.getProductDescriptor().getInstallationPath();
        this.customizeUpgradeBaseLocationVariable(string);
        this.customizeUpgradeBaseVersionVariable(upgradableProduct.getVersion());
        this.initVarSerializedFromInstaller(upgradableProduct.getUninstallerLocationFromUninstallComponent());
        this.setInstallDirVariable(string);
    }

    private void setInstallDirVariable(String string) {
        if (!this.installer.getUpgradeSettings().getAllowCustomizationOfUserInstallDirectory()) {
            VariableManager.getInstance().setVariable("USER_INSTALL_DIR", string);
        }
    }

    private <T> void sortList(List<T> list) {
        Version version = null;
        Version version2 = null;
        for (int i = 0; i < list.size(); ++i) {
            for (int j = 0; j < list.size() - i - 1; ++j) {
                if (list.get(j) instanceof UpgradableProduct) {
                    version = new Version(((UpgradableProduct)list.get(j)).getVersion());
                    version2 = new Version(((UpgradableProduct)list.get(j + 1)).getVersion());
                } else if (list.get(j) instanceof Flexeraapu) {
                    version = new Version(((Flexeraapu)list.get(j)).getVersion());
                    version2 = new Version(((Flexeraapu)list.get(j + 1)).getVersion());
                }
                if (!version.lessThanOrEqualTo(version2)) continue;
                T t = list.get(j);
                list.set(j, list.get(j + 1));
                list.set(j + 1, t);
            }
        }
    }

    private void addToPathsOfInstancesSatisfyingUpgradeConfiguration(List<UpgradableProduct> list) {
        for (UpgradableProduct upgradableProduct : list) {
            this.pathsOfInstancesSatisfyingUpgradeConfiguration.add(upgradableProduct.getProductDescriptor().getVersion() + this.displaySeperator + upgradableProduct.getProductDescriptor().getInstallationPath());
        }
    }

    private void findInstancesSatisfyingUpgradeCondition() {
        for (UpgradeConfiguration upgradeConfiguration : this.projectSpecifiedUpgradeConfigurations) {
            if (upgradeConfiguration.getDetectionBasedOn().equals("PRODUCT_CODE")) {
                this.updateEligiblePdtsList(upgradeConfiguration, this.availableProductsOnTheSystemBasedonProductId);
            }
            if (!upgradeConfiguration.getDetectionBasedOn().equals("UPGRADE_CODE")) continue;
            this.updateEligiblePdtsList(upgradeConfiguration, this.availableProductsOnTheSystemBasedonUpgradeId);
        }
    }

    private void updateEligiblePdtsList(UpgradeConfiguration upgradeConfiguration, List<Flexeraapu> list) {
        for (Flexeraapu flexeraapu : list) {
            UpgradableProduct upgradableProduct;
            boolean bl = this.belongsToUpgradeConfiguration(upgradeConfiguration, flexeraapu);
            if (!bl || this.productsEligibleForUpgrade.contains(upgradableProduct = new UpgradableProduct(flexeraapu, upgradeConfiguration))) continue;
            this.productsEligibleForUpgrade.add(upgradableProduct);
        }
    }

    private ArrayList<Flexeraapu> detectAvailableInstancesOnThisMachineBasedonProductId(UpgradeConfiguration upgradeConfiguration) {
        ArrayList arrayList = null;
        this.projectSpecifiedUpgradeConfigurations = this.installer.getUpgradeSettings().getUpgradeConfigurationsList();
        InstanceDetector instanceDetector = InstanceDetector.getInstance();
        instanceDetector.setIDefinition(this.installer.getInstanceDefinition());
        arrayList = upgradeConfiguration.getRequireValidationForPreviousProductCode() ? this.detectAvailableInstancesBasedOnPreviousProductCode(upgradeConfiguration.getPreviousProductCode()) : instanceDetector.getAlreadyInstalledInstances(this.installer);
        int n = arrayList.size();
        return arrayList;
    }

    private ArrayList<Flexeraapu> detectAvailableInstancesOnThisMachineBasedonUpgradeId(Installer installer) {
        this.projectSpecifiedUpgradeConfigurations = installer.getUpgradeSettings().getUpgradeConfigurationsList();
        InstanceDetector instanceDetector = InstanceDetector.getInstance();
        instanceDetector.setIDefinition(installer.getInstanceDefinition());
        int n = instanceDetector.getNumberOfInstancesAlreadyInstalledOnHost(installer);
        return instanceDetector.getAlreadyInstalledInstancesBasedOnUpgradeCode(installer);
    }

    public ArrayList detectAvailableInstancesBasedOnPreviousProductCode(UUID uUID) {
        ArrayList<Flexeraapu> arrayList = new ArrayList<Flexeraapu>();
        Flexeraavd.ai("Detecting Installed Instances ...");
        Flexeraap_ flexeraap_ = Flexeraap_.ak();
        if (flexeraap_ != null && flexeraap_.al() == null) {
            flexeraap_.af(this.installer, true);
        }
        Enumeration enumeration = flexeraap_.at();
        while (enumeration != null && enumeration.hasMoreElements()) {
            Flexeraapu flexeraapu = (Flexeraapu)enumeration.nextElement();
            if (!flexeraapu.ab().toString().equals(uUID.toString())) continue;
            arrayList.add(flexeraapu);
        }
        if (this.installer.getCheckCrossBit() && ZGUtil.WIN32) {
            arrayList.addAll(InstanceDetector.getInstance().handleCrossBitCaseforUUID(uUID));
        }
        return arrayList;
    }

    private void displayUpgradeConfirmationDialog() {
        List<String> list = this.getPathsOfInstancesSatisfyingUpgradeConfiguration();
        List<String> list2 = this.getPathsOfInstancesSatisfyingUpgradeMaintenance();
        if (!list.isEmpty() || !list2.isEmpty()) {
            if (Flexeraaq7.az()) {
                this.upgradeCustomizerGUI = new UpgradeCustomizerGUI(this.installer, list, list2);
                this.upgradeCustomizerGUI.setVisible(true);
            } else if (Flexeraaq7.ax()) {
                this.upgradeCustomizerConsole = new UpgradeCustomizerConsole(this.installer, list, list2);
            }
        }
    }

    public void triggerUpgradeInitialization() {
        this.setRunningInUpgradeMode(true);
        if (!this.productsEligibleForUpgrade.isEmpty()) {
            this.uninstallSelectedUpgradableInstances(this.userSelectedProducts);
        }
    }

    private void uninstallAllUpgradableInstances() {
        this.uninstallSelectedUpgradableInstances(this.productsEligibleForUpgrade);
    }

    private void uninstallSelectedUpgradableInstances(List<UpgradableProduct> list) {
        VariableManager.getInstance().setVariable(UPGRADE_PROCESS_EXIT_CODE_VARIABLE, "0");
        if (!list.isEmpty()) {
            for (UpgradableProduct upgradableProduct : list) {
                upgradableProduct.addUninstallProductActionToEndOfPreInstallPhase(this.installer);
            }
            if (this.installer.getUpgradeSettings().getAbortInstallationIfUninstallFails()) {
                this.addAbortOnUninstallationFailCheck();
            }
        }
    }

    public void initVarSerializedFromInstaller(String string) {
        if (!this.installer.getUpgradeSettings().getRetainFeaturePreferences()) {
            return;
        }
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(new File(new File(string).getParent(), "installvariables.properties"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            Flexeraavd.ai("installvariables.properties not adjacent to uninstaller.jar");
        }
        if (fileInputStream == null) {
            Flexeraavd.ai("Did not detect installvariables.properties file");
            return;
        }
        try {
            properties.load(fileInputStream);
        }
        catch (IOException iOException) {
            System.err.println("Not initializing variables from installer.");
        }
        Enumeration<Object> enumeration = properties.keys();
        String string2 = null;
        String string3 = null;
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!string2.startsWith("CHOSEN_INSTALL_FEATURE")) {
                if (!string2.equals("CHOSEN_INSTALL_SET")) continue;
            }
            string3 = (String)properties.get(string2);
            VariableFacade.getInstance().setVariable(string2, string3);
        }
    }

    private boolean belongsToUpgradeConfiguration(UpgradeConfiguration upgradeConfiguration, Flexeraapu flexeraapu) {
        boolean bl = false;
        this.maxConfigVersion = upgradeConfiguration.getMaxVersion();
        this.minConfigVersion = upgradeConfiguration.getMinVersion();
        this.currentProdVersion = new Version(flexeraapu.getVersion());
        if (this.currentProdVersion != null && this.maxConfigVersion != null && this.minConfigVersion != null && this.currentProdVersion.greaterThanOrEqualTo(this.minConfigVersion) && this.currentProdVersion.lessThanOrEqualTo(this.maxConfigVersion)) {
            bl = true;
        }
        return bl;
    }

    public boolean checkIfHigherVersionOfInstancesAvailable(List<Flexeraapu> list) {
        boolean bl = false;
        Version version = new Version(this.installer.getInstallerInfoData().getProductVersionString());
        for (Flexeraapu flexeraapu : list) {
            Version version2 = new Version(flexeraapu.getVersion());
            if (version2.greaterThanOrEqualTo(version)) {
                this.higherVersionInstalledProductsPath.add(flexeraapu.getInstallationPath());
                this.higherVersionInstalledProductsPathWithUninstaller.add(flexeraapu.getVersion() + this.displaySeperator + InstanceDetector.getInstance().getUninstallerLocation(this.installer, flexeraapu.getInstallationPath()) + this.valueSeperator + flexeraapu.getInstallationPath());
                bl = true;
                continue;
            }
            bl = false;
            break;
        }
        return bl;
    }

    public List<UpgradableProduct> getUserSelectedProducts() {
        return this.userSelectedProducts;
    }

    public List<UpgradableProduct> getProductsEligibleForUpgrade() {
        return this.productsEligibleForUpgrade;
    }

    public List<Flexeraapu> getAvailableProductsOnTheSystemBasedOnProductId() {
        return this.availableProductsOnTheSystemBasedonProductId;
    }

    public List<Flexeraapu> getAvailableProductsOnTheSystemBasedOnUpgradeId() {
        return this.availableProductsOnTheSystemBasedonUpgradeId;
    }

    public List<UpgradeConfiguration> getProjectSpecifiedUpgradeConfigurations() {
        return this.projectSpecifiedUpgradeConfigurations;
    }

    public List<UpgradableProduct> getProductsWhoseUninstallationFailed() {
        return this.productsWhoseUninstallationFailed;
    }

    public ArrayList<String> getHigherVersionInstalledProductsPath() {
        return this.higherVersionInstalledProductsPath;
    }

    public boolean getIsHigherVersionAvailable() {
        return this.isHigherVersionAvailable;
    }

    public Version getMaxConfigVersion() {
        return this.maxConfigVersion;
    }

    public Version getMinConfigVersion() {
        return this.minConfigVersion;
    }

    public Version getCurrentProdVersion() {
        return this.currentProdVersion;
    }

    public List<String> getPathsOfInstancesSatisfyingUpgradeConfiguration() {
        return this.pathsOfInstancesSatisfyingUpgradeConfiguration;
    }

    public List<String> getPathsOfInstancesSatisfyingUpgradeMaintenance() {
        return this.upgradedProductsPathWithMaintenanceMode;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    private void customizeUpgradeBaseLocationVariable(String string) {
        Flexeraany flexeraany = (Flexeraany)VariableManager.getInstance().getVariable("IA_UPGRADE_BASE_LOCATION");
        flexeraany.ab(true);
        VariableManager.getInstance().setVariable("IA_UPGRADE_BASE_LOCATION", string);
        flexeraany.ab(false);
    }

    private void customizeUpgradeBaseVersionVariable(String string) {
        Flexeraanz flexeraanz = (Flexeraanz)VariableManager.getInstance().getVariable("IA_UPGRADE_BASE_VERSION");
        flexeraanz.ab(true);
        VariableManager.getInstance().setVariable("IA_UPGRADE_BASE_VERSION", string);
        flexeraanz.ab(false);
    }

    private void addAbortOnUninstallationFailCheck() {
        AbortInstallAction abortInstallAction = new AbortInstallAction();
        abortInstallAction.setAbortType("Abort upgrade installation");
        int[] nArray = Flexeraaji.aa();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            CompareVariable compareVariable = new CompareVariable();
            compareVariable.setOperands(UPGRADE_PROCESS_EXIT_CODE_VARIABLE, "" + nArray[i]);
            compareVariable.setOperation("equals");
            abortInstallAction.addRule(compareVariable);
            if (i < nArray.length - 1) {
                stringBuffer.append(compareVariable.getRuleId() + " || ");
                continue;
            }
            stringBuffer.append(compareVariable.getRuleId());
        }
        abortInstallAction.setRuleExpression(stringBuffer.toString());
        abortInstallAction.setInstaller(this.installer);
        this.installer.getPreInstallActions().add(abortInstallAction);
    }

    public boolean isRunningInUpgradeMode() {
        return this.runningInUpgradeMode;
    }

    public void setRunningInUpgradeMode(boolean bl) {
        this.runningInUpgradeMode = bl;
    }

    public boolean getRetainFeaturePreferencesFl() {
        boolean bl = false;
        if (this.isUpgradeMode && this.installer != null) {
            bl = this.installer.getUpgradeSettings().getRetainFeaturePreferences();
        }
        return bl;
    }

    private void findUpgradedInstancesWithMaintenanceModeEnabled() {
        Scanner scanner = null;
        String string = "";
        for (String string2 : this.higherVersionInstalledProductsPathWithUninstaller) {
            String[] stringArray = string2.split(this.valueSeperator);
            string2 = stringArray[0].trim();
            String string3 = stringArray.length > 1 ? stringArray[1].trim() : "";
            string = string2.substring(0, string2.indexOf(this.displaySeperator));
            File file = new File(string2 = runTimeUpgradeManager.stripVersion(string2));
            if (!file.exists()) continue;
            try {
                scanner = new Scanner(new File(file.getParent() + File.separator + INSTALL_SCRIPT_NAME));
                while (scanner.hasNextLine()) {
                    String string4 = scanner.nextLine();
                    if (!string4.contains("maintModeSupportEnabled")) continue;
                    string4 = scanner.nextLine();
                    if (!string4.contains("true")) continue;
                    String string5 = string + this.displaySeperator + file.getParentFile().getParent();
                    this.upgradedProductsPathWithMaintenanceMode.add(string5);
                    this.mapsOfUpgradedProductsPathWithMaintenanceMode.put(string5.trim(), string3);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Uninstall script file not found at " + string2);
            }
        }
    }

    public String getMaintModeLocation() {
        return this.maintModeLocation;
    }

    public void setMaintModeLocation(String string) {
        this.maintModeLocation = string;
    }

    public boolean isUpgradeinMaintMode() {
        return this.isUpgradeinMaintMode;
    }

    public void setUpgradeinMaintMode(boolean bl) {
        this.isUpgradeinMaintMode = bl;
    }

    public int getDialogOption() {
        return this.dialogOption;
    }

    public void setDialogOption(int n) {
        this.dialogOption = n;
    }

    public boolean isReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(boolean bl) {
        this.returnValue = bl;
    }

    public String stripVersion(String string) {
        if (string != null) {
            string = string.substring(string.indexOf(this.displaySeperator) + 4);
        }
        return string;
    }

    public Map getMapsOfUpgradedProductsPathWithMaintMode() {
        return this.mapsOfUpgradedProductsPathWithMaintenanceMode;
    }
}

