/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.service;

public class ServiceException
extends Exception {
    public static final int INIT_GENERAL = 100;
    public static final int NO_SERVICESHOME = 101;
    public static final int CANNOT_LOAD_SERVICES_INF = 102;
    public static final int DIGEST_TEST_FAILED = 103;
    public static final int JAVA_EXCEPTION = 200;
    public static final int SERVICE_NOT_AVAILABLE = 300;
    public static final int SERVICE_INIT_FAILED = 301;
    public static final int IMPLPROXY_NOT_AVAILABLE = 302;
    public static final int SERVICEIMPL_INIT_FAILED = 303;
    public static final int INVALID_DEFAULT_IMPL = 304;
    public static final int OPERATION_NOT_SUPPORTED = 305;
    public static final int NO_SERVICE_DEF = 306;
    public static final int OPERATION_SINGATURE_MISMATCH = 308;
    public static final int CLASS_NOT_FOUND = 309;
    public static final int INSTANTIATION_EXCEPTION = 310;
    public static final int NO_SUCH_METHOD = 311;
    public static final int NO_IMPL_DEF = 312;
    public static final int CANNOT_CREATE_IMPL = 313;
    public static final int INVALID_PARAMETER_LIST = 314;
    public static final int OPERATION_FAILED = 315;
    public static final int INVALID_OPERATION = 316;
    public static final int UI_NOT_SUPPORTED = 317;
    public static final int IMPL_TYPE_MISMATCH = 318;
    public static final int ILLEGAL_SERVICES_STATE = 319;
    public static final int MISSING_RES_ID = 320;
    public static final int SERVICE_ERROR = 399;
    public static final int REMOTE_SERVICE_EXCEPTION = 401;
    public static final int REMOTE_INVOCATION_FAILED = 402;
    public static final int REMOTE_IO_EXCEPTION = 403;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final int FATAL_ERROR = 3;
    private int code = 0;
    private String msg = null;
    private Object data = null;
    private int severity = 0;

    public static String getErrorMsg(int n) {
        switch (n) {
            case 100: {
                return "general initialization error";
            }
            case 101: {
                return "could not find services home";
            }
            case 102: {
                return "could not load /services.inf";
            }
            case 103: {
                return "digest test failed";
            }
            case 200: {
                return "Java error";
            }
            case 300: {
                return "service is not available";
            }
            case 301: {
                return "could not initialize service";
            }
            case 302: {
                return "an implementor proxy is not available";
            }
            case 303: {
                return "could not initialize service implementor";
            }
            case 304: {
                return "the implementation specified in the services definition does not implement the correct implementor interface";
            }
            case 305: {
                return "the operation not supported by the current service implementation";
            }
            case 306: {
                return "service is not defined in the services definition";
            }
            case 308: {
                return "operation signature mistmatch";
            }
            case 309: {
                return "class not found";
            }
            case 310: {
                return "instantiation exception";
            }
            case 311: {
                return "no such method";
            }
            case 312: {
                return "the service does not have an implementation defined";
            }
            case 313: {
                return "could not create implementation";
            }
            case 314: {
                return "invalid parameter list";
            }
            case 315: {
                return "operation failed";
            }
            case 399: {
                return "general service error";
            }
            case 317: {
                return "user interface not supported";
            }
            case 320: {
                return "wizard.inf does not contain entry RES_ID";
            }
            case 318: {
                return "impl type for service does not match type required by service";
            }
            case 319: {
                return "services state does not support the current operation";
            }
            case 401: {
                return "general remote service error";
            }
            case 402: {
                return "remote service operation failed";
            }
            case 403: {
                return "remote service could not be utilized due to IO error";
            }
        }
        return "unknown error code";
    }

    public ServiceException(int n) {
        this.code = n;
    }

    public ServiceException(int n, String string) {
        this.code = n;
        this.msg = string;
    }

    public ServiceException(int n, String string, Object object) {
        this(n, string);
        this.data = object;
    }

    public ServiceException(Throwable throwable) {
        if (throwable instanceof ServiceException) {
            ServiceException serviceException = (ServiceException)throwable;
            this.code = serviceException.code;
            this.msg = serviceException.msg;
            this.data = serviceException.data;
            this.severity = serviceException.severity;
        } else {
            this.code = 200;
            this.msg = throwable.getMessage();
            this.data = throwable;
        }
    }

    public int getErrorCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.msg;
    }

    public Object getData() {
        return this.data;
    }

    public void setSeverity(int n) {
        this.severity = n;
    }

    public int getSeverity() {
        return this.severity;
    }

    @Override
    public String toString() {
        return "ServiceException";
    }

    private String getDataDesc() {
        if (this.code == 200) {
            return "exception";
        }
        return "additional data";
    }
}

