/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.macos.toolbox.ConvertMacAndUnicode;
import com.apple.mrj.macos.toolbox.Ptr;
import com.apple.mrj.macos.toolbox.StringPtr;
import com.apple.mrj.macos.toolbox.TextUtilities;
import java.util.Locale;

public class TranslateString {
    public static byte[] asBytes(String string) {
        byte[] byArray = string == null ? new byte[]{} : TranslateString.asBytes(string.toCharArray());
        return byArray;
    }

    public static byte[] asBytes(char[] cArray) {
        byte[] byArray = new byte[cArray.length * 3];
        int n = 0;
        n = TranslateString.toBytes(cArray, byArray, 0);
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray2[n2] = byArray[n2];
            ++n2;
        }
        return byArray2;
    }

    public static byte[] asCBytes(char[] cArray) {
        byte[] byArray = new byte[cArray.length * 3 + 1];
        int n = 0;
        n = TranslateString.toBytes(cArray, byArray, 0);
        byte[] byArray2 = new byte[n + 1];
        int n2 = 0;
        while (n2 < n) {
            byArray2[n2] = byArray[n2];
            ++n2;
        }
        byArray2[n] = 0;
        return byArray2;
    }

    public static int toBytes(char[] cArray, byte[] byArray, int n) {
        Locale locale = Locale.getDefault();
        short[] sArray = new short[]{-128};
        return TranslateString.toBytes(cArray, byArray, n, locale, sArray, false);
    }

    public static int toBytes(char[] cArray, byte[] byArray, int n, Locale locale, short[] sArray, boolean bl) {
        int n2 = 0;
        char[] cArray2 = new char[]{'\u2a2a'};
        char[] cArray3 = new char[]{'\u2a2a'};
        short[] sArray2 = new short[]{-128};
        short[] sArray3 = new short[]{-128};
        if (locale == null && sArray[0] == -128) {
            locale = Locale.getDefault();
        }
        if (locale != null) {
            String string = locale.getCountry();
            if (string.length() >= 2) {
                cArray3[0] = (char)((string.charAt(0) << 8) + string.charAt(1));
            }
            if ((string = locale.getLanguage()).length() >= 2) {
                cArray2[0] = (char)((string.charAt(0) << 8) + string.charAt(1));
            }
            ConvertMacAndUnicode.MapOSLocaleInfo(sArray2, sArray3, cArray3, cArray2, false);
        }
        n2 = ConvertMacAndUnicode.ConvertUnicodeToMacRegionalText(cArray, (short)cArray.length, byArray, (short)byArray.length, (short)n, sArray2[0], sArray3[0], sArray, bl);
        return n2;
    }

    public static String asString(byte[] byArray, short s, short s2, short s3) {
        int n;
        if (s2 > byArray.length) {
            s2 = (short)byArray.length;
        }
        if ((n = s2 - s) <= 0) {
            return new String();
        }
        char[] cArray = new char[n * 3];
        int n2 = ConvertMacAndUnicode.ConvertMacintoshCodeToUnicodes(cArray, (short)cArray.length, byArray, s2, s, s3);
        String string = new String(cArray, 0, n2);
        return string;
    }

    public static String pascalByteArrayToString(byte[] byArray) {
        int n = byArray[0];
        if (byArray.length - 1 < n) {
            n = byArray.length - 1;
        }
        char[] cArray = new char[n * 3];
        int n2 = ConvertMacAndUnicode.ConvertMacintoshCodeToUnicodes(cArray, (short)cArray.length, byArray, (short)(n + 1), 1, TextUtilities.SystemFontScript);
        String string = new String(cArray, 0, n2);
        return string;
    }

    public static String asString(byte[] byArray, short s, short s2) {
        return TranslateString.asString(byArray, s, s2, TextUtilities.SystemFontScript);
    }

    public static Ptr asPtr(String string) {
        return new Ptr(TranslateString.asBytes(string));
    }

    public static byte[] asPascalBytes(StringPtr stringPtr) {
        byte[] byArray = stringPtr == null ? new byte[]{0} : stringPtr.getBytes();
        return byArray;
    }

    public static byte[] asPascalBytes(String string) {
        short[] sArray = new short[]{-128};
        return TranslateString.asPascalBytes(string, sArray, false);
    }

    public static byte[] asPascalBytes(String string, short[] sArray, boolean bl) {
        byte[] byArray;
        if (string == null) {
            byArray = new byte[]{0};
        } else {
            int n = string.length() * 3;
            if (n > 255) {
                n = 255;
            }
            byte[] byArray2 = new byte[n];
            Locale locale = Locale.getDefault();
            sArray[0] = -128;
            n = (byte)TranslateString.toBytes(string.toCharArray(), byArray2, 0, locale, sArray, bl);
            byArray = new byte[n + 1];
            int n2 = 0;
            while (n2 < n) {
                byArray[n2 + 1] = byArray2[n2];
                ++n2;
            }
            byArray[0] = (byte)n;
        }
        return byArray;
    }

    public static Ptr asPascalPtr(String string) {
        return new Ptr(TranslateString.asPascalBytes(string));
    }

    public static final short setStringPtr(StringPtr stringPtr, String string, boolean bl) {
        return TranslateString.setStringPtr(stringPtr, string, null, bl);
    }

    public static final short setStringPtr(StringPtr stringPtr, String string, short[] sArray, boolean bl) {
        byte by = (byte)TranslateString.toBytes(string.toCharArray(), stringPtr.getByteArray(), 1, null, sArray, bl);
        stringPtr.setLengthByte(by);
        stringPtr.setScript(sArray[0]);
        return sArray[0];
    }

    public static final short setStringPtr(StringPtr stringPtr, String string, Locale locale, boolean bl) {
        short[] sArray = new short[]{-128};
        byte by = (byte)TranslateString.toBytes(string.toCharArray(), stringPtr.getByteArray(), 1, locale, sArray, bl);
        stringPtr.setLengthByte(by);
        stringPtr.setScript(sArray[0]);
        return sArray[0];
    }
}

