/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.jdirect.PointerStruct;
import com.apple.mrj.macos.generated.PrintingConstants;
import com.apple.mrj.macos.generated.PrintingFunctions;
import com.apple.mrj.macos.generated.TPrintStruct;
import com.apple.mrj.macos.toolbox.Handle;
import com.apple.mrj.macos.toolbox.Rect;
import com.apple.mrj.macos.toolbox.TPPrPort;
import com.apple.mrj.macos.toolbox.TPrInfo;
import com.apple.mrj.macos.toolbox.TPrJob;
import com.apple.mrj.macos.toolbox.TPrStatus;
import com.apple.mrj.macos.toolbox.TPrStl;
import com.apple.mrj.macos.toolbox.TPrXInfo;

public class THPrint
implements PrintingConstants {
    TPrintStruct data;
    Handle handle;

    public TPrintStruct getTPrintStruct() {
        return this.data;
    }

    public int getHandleValue() {
        return this.handle.getHandle();
    }

    public THPrint() {
        this.initialize();
    }

    void initialize() {
        this.handle = new Handle(120, true);
        this.data = new TPrintStruct(this.handle.getHandle());
    }

    public void dispose() {
        this.data = null;
        if (this.handle != null) {
            this.handle.dispose();
            this.handle = null;
        }
    }

    public static void prPurge() {
        PrintingFunctions.PrPurge();
    }

    public static void prNoPurge() {
        PrintingFunctions.PrNoPurge();
    }

    public static void prOpen() {
        PrintingFunctions.PrOpen();
    }

    public static void prClose() {
        PrintingFunctions.PrClose();
    }

    public static short prError() {
        return PrintingFunctions.PrError();
    }

    public static void prSetError(short s) {
        PrintingFunctions.PrSetError(s);
    }

    public static void prGeneral(PointerStruct pointerStruct) {
        PrintingFunctions.PrGeneral(pointerStruct == null ? 0 : pointerStruct.getPointer());
    }

    public static void prDrvrOpen() {
        PrintingFunctions.PrDrvrOpen();
    }

    public static void prDrvrClose() {
        PrintingFunctions.PrDrvrClose();
    }

    public void printDefault() {
        PrintingFunctions.PrintDefault(this.getHandleValue());
    }

    public boolean prValidate() {
        return PrintingFunctions.PrValidate(this.getHandleValue());
    }

    public boolean prStlDialog() {
        return PrintingFunctions.PrStlDialog(this.getHandleValue());
    }

    public boolean prJobDialog() {
        return PrintingFunctions.PrJobDialog(this.getHandleValue());
    }

    public int prStlInit() {
        return PrintingFunctions.PrStlInit(this.getHandleValue());
    }

    public int prJobInit() {
        return PrintingFunctions.PrJobInit(this.getHandleValue());
    }

    public void prJobMerge(THPrint tHPrint) {
        PrintingFunctions.PrJobMerge(this.getHandleValue(), tHPrint.getHandleValue());
    }

    public TPPrPort prOpenDoc(TPPrPort tPPrPort, PointerStruct pointerStruct) {
        return new TPPrPort(PrintingFunctions.PrOpenDoc(this.getHandleValue(), tPPrPort == null ? null : tPPrPort.getTPrPort(), pointerStruct == null ? 0 : pointerStruct.getPointer()));
    }

    public void prPicFile(TPPrPort tPPrPort, PointerStruct pointerStruct, PointerStruct pointerStruct2, TPrStatus tPrStatus) {
        PrintingFunctions.PrPicFile(this.getHandleValue(), tPPrPort.getTPrPort(), pointerStruct == null ? 0 : pointerStruct.getPointer(), pointerStruct2 == null ? 0 : pointerStruct2.getPointer(), tPrStatus.getTPrStatus());
    }

    public final short getIPrVersion() {
        return this.getTPrintStruct().getIPrVersion();
    }

    public final void setIPrVersion(short s) {
        this.getTPrintStruct().setIPrVersion(s);
    }

    public final TPrInfo getPrInfo() {
        return new TPrInfo(this.getTPrintStruct().getPrInfo());
    }

    public final void setPrInfo(TPrInfo tPrInfo) {
        this.getTPrintStruct().setPrInfo(tPrInfo.getTPrInfo());
    }

    public final Rect getRPaper() {
        return new Rect(this.getTPrintStruct().getRPaper());
    }

    public final void setRPaper(Rect rect) {
        this.getTPrintStruct().setRPaper(rect.getRect());
    }

    public final TPrStl getPrStl() {
        return new TPrStl(this.getTPrintStruct().getPrStl());
    }

    public final void setPrStl(TPrStl tPrStl) {
        this.getTPrintStruct().setPrStl(tPrStl.getTPrStl());
    }

    public final TPrInfo getPrInfoPT() {
        return new TPrInfo(this.getTPrintStruct().getPrInfoPT());
    }

    public final void setPrInfoPT(TPrInfo tPrInfo) {
        this.getTPrintStruct().setPrInfoPT(tPrInfo.getTPrInfo());
    }

    public final TPrXInfo getPrXInfo() {
        return new TPrXInfo(this.getTPrintStruct().getPrXInfo());
    }

    public final void setPrXInfo(TPrXInfo tPrXInfo) {
        this.getTPrintStruct().setPrXInfo(tPrXInfo.getTPrXInfo());
    }

    public final TPrJob getPrJob() {
        return new TPrJob(this.getTPrintStruct().getPrJob());
    }

    public final void setPrJob(TPrJob tPrJob) {
        this.getTPrintStruct().setPrJob(tPrJob.getTPrJob());
    }

    public final short getPrintX(int n) {
        return this.getTPrintStruct().getPrintX(n);
    }

    public final void setPrintX(int n, short s) {
        this.getTPrintStruct().setPrintX(n, s);
    }
}

