/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.macos.generated.ControlActionClosureUPP;
import com.apple.mrj.macos.generated.ControlActionInterface;
import com.apple.mrj.macos.generated.ControlConstants;
import com.apple.mrj.macos.toolbox.ControlHandle;
import com.apple.mrj.macos.toolbox.DataPointer;
import com.apple.mrj.macos.toolbox.Point;
import com.apple.mrj.macos.toolbox.Rect;
import com.apple.mrj.macos.toolbox.Region;
import com.apple.mrj.macos.toolbox.ScrollPane;
import com.apple.mrj.macos.toolbox.ScrollPaneComponent;
import com.apple.mrj.macos.toolbox.TEHandle;
import com.apple.mrj.macos.toolbox.WindowRef;

public class ScrollableTextEdit
extends TEHandle
implements ScrollPaneComponent,
ControlConstants {
    ScrollPane myPane;

    public ScrollableTextEdit(Rect rect, boolean bl, boolean bl2, boolean bl3, WindowRef windowRef) {
        super(rect, bl, windowRef);
        ControlActionClosureUPP controlActionClosureUPP = null;
        ControlActionClosureUPP controlActionClosureUPP2 = null;
        if (bl2) {
            controlActionClosureUPP = new ControlActionClosureUPP(new hActionProc());
        }
        if (bl3) {
            controlActionClosureUPP2 = new ControlActionClosureUPP(new vActionProc());
        }
        this.myPane = new ScrollPane(this, rect, bl2, bl3, controlActionClosureUPP, controlActionClosureUPP2, true);
    }

    public boolean hitTest(Point point) {
        return this.myPane.hitTest(point);
    }

    public void click(Point point, boolean bl) {
        if (super.hitTest(point)) {
            super.click(point, bl);
        } else {
            this.myPane.click(point);
        }
    }

    public void setBounds(Rect rect) {
        Rect rect2 = this.myPane.setBounds(rect);
        super.setBounds(rect2);
    }

    public Rect getBounds() {
        if (this.myPane != null) {
            return this.myPane.getBounds();
        }
        return null;
    }

    public void update(Region region) {
        this.draw();
    }

    public void draw() {
        if (this.myPane != null) {
            this.myPane.draw();
        }
        super.draw();
    }

    public int getIdentifier() {
        return this.data.getHandle();
    }

    public void dispose() {
        if (this.myPane != null) {
            this.myPane.dispose();
        }
        this.myPane = null;
        super.dispose();
    }

    public void adjustContentsForScrollBars(ControlHandle controlHandle, ControlHandle controlHandle2) {
        Rect rect = this.getViewRect();
        Rect rect2 = this.getDestRect();
        int n = 0;
        int n2 = 0;
        if (controlHandle != null) {
            n = rect.getLeft() - rect2.getLeft() - controlHandle.getValue();
        }
        if (controlHandle2 != null) {
            n2 = rect.getTop() - rect2.getTop() - controlHandle2.getValue();
        }
        this.scroll((short)n, (short)n2);
    }

    public int getScrollMax(Rect rect, Rect rect2, boolean bl) {
        if (bl) {
            return this.getHeight(this.getNLines(), 0) - rect.getHeight();
        }
        return this.calcMaxWidth() - rect.getWidth();
    }

    public int getHLine(short s) {
        return 4;
    }

    public int getVLine(short s) {
        int n = 0;
        int n2 = this.topLine();
        if (s == 20) {
            n = this.getHeight(n2 - 1, n2 - 1);
        } else if (s == 21) {
            n = this.getHeight(n2, n2);
        }
        return n;
    }

    int findLine(short s) {
        int n = this.getNLines();
        DataPointer dataPointer = this.getLineStarts();
        int n2 = 0;
        while (n2 < n && s < this.getLineStart(n2)) {
            ++n2;
        }
        return n2 + 1;
    }

    int topLine() {
        Rect rect = this.getViewRect();
        Point point = new Point(rect.getLeft() + 3, rect.getTop() + 3);
        return this.findLine(this.getOffset(point));
    }

    public void isVisible(boolean bl) {
        if (this.myPane != null) {
            this.myPane.isVisible(bl);
        }
        super.isVisible(bl);
    }

    public void isHilited(boolean bl) {
        if (this.myPane != null) {
            this.myPane.isHilited(bl);
        }
        super.isHilited(bl);
    }

    private short commonAction(ControlHandle controlHandle, short s) {
        short s2 = controlHandle.getValue();
        short s3 = controlHandle.getMaximum();
        short s4 = (short)(s2 - s);
        if (s4 < 0) {
            s4 = 0;
        } else if (s4 > s3) {
            s4 = s3;
        }
        controlHandle.setValue(s4);
        return (short)(s2 - s4);
    }

    class hActionProc
    implements ControlActionInterface {
        public void ControlAction(int n, short s) {
            short s2;
            ControlHandle controlHandle = new ControlHandle(n, this);
            System.out.println("inside a callback!");
            if (s == 0) {
                return;
            }
            Rect rect = ScrollableTextEdit.this.getViewRect();
            short s3 = s == 20 || s == 21 ? (short)4 : (short)((short)(rect.getRight() - rect.getLeft()));
            if (s == 21 || s == 23) {
                s3 = -s3;
            }
            if ((s2 = ScrollableTextEdit.this.commonAction(controlHandle, s3)) != 0) {
                ScrollableTextEdit.this.scroll(s2, (short)0);
            }
        }

        hActionProc() {
        }
    }

    class vActionProc
    implements ControlActionInterface {
        public void ControlAction(int n, short s) {
            short s2;
            ControlHandle controlHandle = new ControlHandle(n, this);
            System.out.println("inside a callback!");
            if (s == 0) {
                return;
            }
            Rect rect = ScrollableTextEdit.this.getViewRect();
            short s3 = s == 20 || s == 21 ? (short)24 : (short)((short)(rect.getBottom() - rect.getTop()));
            if (s == 21 || s == 23) {
                s3 = -s3;
            }
            if ((s2 = ScrollableTextEdit.this.commonAction(controlHandle, s3)) != 0) {
                ScrollableTextEdit.this.scroll((short)0, s2);
            }
        }

        vActionProc() {
        }
    }
}

