/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.macos.generated.LowMemFunctions;
import com.apple.mrj.macos.generated.QuickdrawFunctions;
import com.apple.mrj.macos.generated.RGBColorStruct;
import java.awt.Color;

public class RGBColor {
    RGBColorStruct data;
    public static int colorScale = 256;

    RGBColorStruct getRGBColor() {
        return this.data;
    }

    public RGBColor() {
        this.data = new RGBColorStruct();
    }

    public RGBColor(RGBColorStruct rGBColorStruct) {
        this.data = rGBColorStruct;
    }

    public RGBColor(short s, short s2, short s3) {
        this();
        this.data.setRed(s);
        this.data.setGreen(s2);
        this.data.setBlue(s3);
    }

    public RGBColor(Color color) {
        this(color.getRed() * colorScale, color.getGreen() * colorScale, color.getBlue() * colorScale);
    }

    public RGBColor(int n, int n2, int n3) {
        this((short)(n > Short.MAX_VALUE ? n - 65536 : n), (short)(n2 > Short.MAX_VALUE ? n2 - 65536 : n2), (short)(n3 > Short.MAX_VALUE ? n3 - 65536 : n3));
    }

    public short getRed() {
        return this.data.getRed();
    }

    public short getGreen() {
        return this.data.getGreen();
    }

    public short getBlue() {
        return this.data.getBlue();
    }

    public void setRed(short s) {
        this.data.setRed(s);
    }

    public void setGreen(short s) {
        this.data.setGreen(s);
    }

    public void setBlue(short s) {
        this.data.setBlue(s);
    }

    public void setForeColor() {
        QuickdrawFunctions.RGBForeColor(this.getRGBColor());
    }

    public void setBackColor() {
        QuickdrawFunctions.RGBBackColor(this.getRGBColor());
    }

    public static RGBColor getForeColor() {
        RGBColor rGBColor = new RGBColor();
        QuickdrawFunctions.GetForeColor(rGBColor.getRGBColor());
        return rGBColor;
    }

    public static RGBColor getBackColor() {
        RGBColor rGBColor = new RGBColor();
        QuickdrawFunctions.GetBackColor(rGBColor.getRGBColor());
        return rGBColor;
    }

    public Color asColor() {
        int n = this.getRed();
        int n2 = this.getBlue();
        int n3 = this.getGreen();
        int n4 = n < 0 ? 65536 + n : n;
        int n5 = n3 < 0 ? 65536 + n3 : n3;
        int n6 = n2 < 0 ? 65536 + n2 : n2;
        return new Color(n4 / colorScale, n5 / colorScale, n6 / colorScale);
    }

    public static RGBColor getHiliteRGB() {
        RGBColor rGBColor = new RGBColor();
        LowMemFunctions.LMGetHiliteRGB(rGBColor.getRGBColor());
        return rGBColor;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[red " + this.getRed() + ", green " + this.getGreen() + ", blue " + this.getBlue() + "]";
    }
}

