/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.macos.generated.PolygonStruct;
import com.apple.mrj.macos.generated.QuickdrawFunctions;
import com.apple.mrj.macos.toolbox.Pattern;
import com.apple.mrj.macos.toolbox.PenState;
import com.apple.mrj.macos.toolbox.Point;
import com.apple.mrj.macos.toolbox.Shape;
import java.awt.Polygon;

public class PolyHandle
implements Shape {
    PolygonStruct data;
    Point origin;
    private static Object thePolyLock = new Object();

    PolygonStruct getPolygon() {
        return this.data;
    }

    public PolyHandle() {
    }

    public PolyHandle(Polygon polygon) {
        this(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public PolyHandle(int[] nArray, int[] nArray2, int n) {
        this();
        Object object = thePolyLock;
        synchronized (object) {
            this.origin = new Point((short)nArray[0], (short)nArray2[0]);
            this.openPoly();
            PolyHandle.drawPolyline(nArray, nArray2, n);
            this.closePoly();
        }
    }

    public PolyHandle(Point[] pointArray, int n) {
        this();
        Object object = thePolyLock;
        synchronized (object) {
            this.origin = new Point(pointArray[0]);
            this.openPoly();
            this.drawPolyline(pointArray, n);
            this.closePoly();
        }
    }

    public static void drawPolyline(int[] nArray, int[] nArray2, int n) {
        Object object = thePolyLock;
        synchronized (object) {
            PenState.moveTo((short)nArray[0], (short)nArray2[0]);
            int n2 = 1;
            while (n2 < n) {
                PenState.lineTo((short)nArray[n2], (short)nArray2[n2]);
                ++n2;
            }
        }
    }

    public void drawPolyline(Point[] pointArray, int n) {
        Object object = thePolyLock;
        synchronized (object) {
            PenState.moveTo(pointArray[0].getH(), pointArray[0].getV());
            int n2 = 1;
            while (n2 < n) {
                PenState.lineTo(pointArray[n2].getH(), pointArray[n2].getV());
                ++n2;
            }
        }
    }

    void openPoly() {
        this.data = new PolygonStruct(QuickdrawFunctions.OpenPoly());
    }

    void closePoly() {
        QuickdrawFunctions.ClosePoly();
    }

    public short getLeft() {
        return this.origin.getH();
    }

    public short getTop() {
        return this.origin.getV();
    }

    public void moveTo(short s, short s2) {
        this.offset((short)(s - this.getLeft()), (short)(s2 - this.getTop()));
        this.origin.set(s, s2);
    }

    public void offset(short s, short s2) {
        QuickdrawFunctions.OffsetPoly(this.getPolygon(), s, s2);
        this.origin.offset(s, s2);
    }

    public boolean contains(Point point) {
        return false;
    }

    public void frame() {
        QuickdrawFunctions.FramePoly(this.getPolygon());
    }

    public void paint() {
        QuickdrawFunctions.PaintPoly(this.getPolygon());
    }

    public void fill(Pattern pattern) {
        QuickdrawFunctions.FillPoly(this.getPolygon(), pattern.getPattern());
    }

    public void erase() {
        QuickdrawFunctions.ErasePoly(this.getPolygon());
    }

    public void invert() {
        QuickdrawFunctions.InvertPoly(this.getPolygon());
    }
}

