/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.jdirect.Struct;
import com.apple.mrj.macos.generated.PointStruct;
import com.apple.mrj.macos.generated.QuickdrawFunctions;

public class Point {
    PointStruct data;

    PointStruct getPoint() {
        return this.data;
    }

    void initialize() {
        this.data = new PointStruct();
    }

    public Point() {
        this.initialize();
    }

    public Point(int n, int n2) {
        this((short)n, (short)n2);
    }

    public Point(short s, short s2) {
        this();
        this.data.setH(s);
        this.data.setV(s2);
    }

    public Point(Point point) {
        this.data.setH(point.getH());
        this.data.setV(point.getV());
    }

    public Point(int n) {
        this((short)(n & 0xFFFF), (short)(n >> 16));
    }

    public Point(Struct struct) {
        this(struct, 0);
    }

    public Point(Struct struct, int n) {
        this.data = new PointStruct(struct, n);
    }

    public final short getV() {
        return this.data.getV();
    }

    public final short getH() {
        return this.data.getH();
    }

    public final void setH(short s) {
        this.data.setH(s);
    }

    public final void setV(short s) {
        this.data.setV(s);
    }

    public final void setH(int n) {
        this.setH((short)n);
    }

    public final void setV(int n) {
        this.setV((short)n);
    }

    public final int toInt() {
        return this.data.getValue();
    }

    public final int getValue() {
        return this.data.getValue();
    }

    public final String toString() {
        return String.valueOf(this.getClass().getName()) + "[h " + this.getH() + ", v " + this.getV() + "]";
    }

    public final void localToGlobal() {
        QuickdrawFunctions.LocalToGlobal(this.getPoint());
    }

    public final void globalToLocal() {
        QuickdrawFunctions.GlobalToLocal(this.getPoint());
    }

    public final void add(Point point) {
        QuickdrawFunctions.AddPt(point.getPoint(), this.getPoint());
    }

    public final void sub(Point point) {
        QuickdrawFunctions.SubPt(point.getPoint(), this.getPoint());
    }

    public final Point delta(Point point) {
        return new Point(QuickdrawFunctions.DeltaPoint(this.getPoint(), point.getPoint()));
    }

    public final void offset(short s, short s2) {
        this.set(this.getH() + s, this.getV() + s2);
    }

    public final void set(short s, short s2) {
        QuickdrawFunctions.SetPt(this.getPoint(), s, s2);
    }

    public final void set(int n, int n2) {
        this.set((short)n, (short)n2);
    }

    public final void set(Point point) {
        this.set(point.getH(), point.getV());
    }

    public final boolean equal(Point point) {
        return QuickdrawFunctions.EqualPt(point.getPoint(), this.getPoint());
    }
}

