/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.jdirect.Struct;
import com.apple.mrj.macos.generated.FInfoStruct;
import com.apple.mrj.macos.generated.FSSpecStruct;
import com.apple.mrj.macos.generated.FileFunctions;
import com.apple.mrj.macos.toolbox.Handle;
import com.apple.mrj.macos.toolbox.MacOSError;
import com.apple.mrj.macos.toolbox.OSUtils;
import com.apple.mrj.macos.toolbox.TranslateString;
import com.apple.mrj.macos.toolbox.VMFunctions;
import java.io.File;

public class FSSpec {
    FSSpecStruct data;

    FSSpecStruct getFSSpec() {
        return this.data;
    }

    public FSSpec() {
        this.data = new FSSpecStruct();
    }

    public FSSpec(FSSpecStruct fSSpecStruct) {
        this.data = fSSpecStruct;
    }

    public FSSpec(String string) {
        this();
        short s = VMFunctions.Path2FSSpec(FSSpec.cstring(string), this.getFSSpec());
        if (s != 0 && s != -43) {
            MacOSError.checkResult(s);
        }
    }

    public FSSpec(File file) {
        this(file.getPath());
    }

    public FSSpec(short s, int n, String string) {
        this();
        this.setVRefNum(s);
        this.setParID(n);
        this.setName(string);
    }

    public FSSpec(short s, int n) {
        this(s, n, "");
    }

    public short makeFSSpec(short s, int n, byte[] byArray) {
        return FileFunctions.FSMakeFSSpec(s, n, byArray, this.getFSSpec());
    }

    public short makeFSSpec(short s, int n, String string) {
        return this.makeFSSpec(s, n, FSSpec.pstring(string));
    }

    public short makeFSSpec(short s, int n) {
        return this.makeFSSpec(s, n, (byte[])null);
    }

    public short makeFSSpec() {
        return this.makeFSSpec(this.getVRefNum(), this.getParID(), this.getName());
    }

    public FSSpec(Struct struct, int n) {
        this.data = new FSSpecStruct(struct, n);
    }

    public FSSpec(Struct struct) {
        this(struct, 0);
    }

    public final short getVRefNum() {
        return this.data.getVRefNum();
    }

    public final int getParID() {
        return this.data.getParID();
    }

    public final String getName() {
        return TranslateString.pascalByteArrayToString(this.data.getName());
    }

    public final void setVRefNum(short s) {
        this.data.setVRefNum(s);
    }

    public final void setParID(int n) {
        this.data.setParID(n);
    }

    public final void setName(String string) {
        this.data.setName(TranslateString.asPascalBytes(string));
    }

    public final byte[] getBytes() {
        return this.data.getByteArray();
    }

    public String toString() {
        return "[" + this.getVRefNum() + ", " + this.getParID() + ", " + this.getName() + "]";
    }

    public FSSpec makeParent() {
        FSSpec fSSpec = new FSSpec();
        short s = fSSpec.makeFSSpec(this.getVRefNum(), this.getParID(), "");
        return fSSpec;
    }

    public File toFile() {
        File file;
        int n = VMFunctions.Spec2FullPath(this.getFSSpec());
        if (n == 0) {
            FSSpec fSSpec = this.makeParent();
            n = VMFunctions.Spec2FullPath(fSSpec.getFSSpec());
            if (n == 0) {
                return null;
            }
            File file2 = new File(FSSpec.cstrToString(n));
            file = new File(file2, this.getName());
        } else {
            file = new File(FSSpec.cstrToString(n));
        }
        return file;
    }

    private static String cstrToString(int n) {
        Handle handle = new Handle(n);
        byte[] byArray = handle.getBytesAt(0, handle.getSize());
        handle.dispose();
        int n2 = byArray.length;
        if (byArray[n2 - 1] == 0) {
            --n2;
        }
        return new String(byArray, 0, n2);
    }

    private static byte[] cstring(String string) {
        byte[] byArray = string.getBytes();
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray.length] = 0;
        return byArray2;
    }

    private static byte[] pstring(String string) {
        byte[] byArray = string.getBytes();
        if (byArray.length > 255) {
            throw new ArrayIndexOutOfBoundsException(byArray.length);
        }
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        byArray2[0] = (byte)byArray.length;
        return byArray2;
    }

    public FInfoStruct getFInfo() {
        FInfoStruct fInfoStruct = new FInfoStruct();
        MacOSError.checkResult(FileFunctions.FSpGetFInfo(this.data, fInfoStruct));
        return fInfoStruct;
    }

    public void setFInfo(FInfoStruct fInfoStruct) {
        MacOSError.checkResult(FileFunctions.FSpSetFInfo(this.data, fInfoStruct));
    }

    public void setTypeAndCreator(int n, boolean bl, int n2, boolean bl2) {
        FInfoStruct fInfoStruct = this.getFInfo();
        if (bl) {
            fInfoStruct.setFdType(n);
        }
        if (bl2) {
            fInfoStruct.setFdCreator(n2);
        }
        this.setFInfo(fInfoStruct);
    }

    public void setTypeAndCreator(int n, int n2) {
        this.setTypeAndCreator(n, true, n2, true);
    }

    public void setTypeAndCreator(String string, String string2) {
        this.setTypeAndCreator(OSUtils.makeOSType(string), OSUtils.makeOSType(string2));
    }

    public int getType() {
        FInfoStruct fInfoStruct = this.getFInfo();
        return fInfoStruct.getFdType();
    }

    public int getCreator() {
        FInfoStruct fInfoStruct = this.getFInfo();
        return fInfoStruct.getFdCreator();
    }

    public void setType(int n) {
        this.setTypeAndCreator(n, true, -1, false);
    }

    public void setCreator(int n) {
        this.setTypeAndCreator(-1, false, n, true);
    }

    public void syncTypeAndCreatorWith(FSSpec fSSpec) {
        FInfoStruct fInfoStruct = fSSpec.getFInfo();
        this.setTypeAndCreator(fInfoStruct.getFdType(), fInfoStruct.getFdCreator());
    }

    public void syncTypeAndCreatorWith(File file) {
        this.syncTypeAndCreatorWith(new FSSpec(file));
    }

    public static void setTypeAndCreator(File file, int n, int n2) {
        new FSSpec(file).setTypeAndCreator(n, n2);
    }

    public static void setTypeAndCreator(File file, String string, String string2) {
        FSSpec.setTypeAndCreator(file, OSUtils.makeOSType(string), OSUtils.makeOSType(string2));
    }

    public static void setType(File file, int n) {
        new FSSpec(file).setType(n);
    }

    public static void setType(File file, String string) {
        FSSpec.setType(file, OSUtils.makeOSType(string));
    }

    public static void syncTypeAndCreator(File file, File file2) {
        new FSSpec(file2).syncTypeAndCreatorWith(file);
    }
}

