/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.macos.generated.ControlActionClosureUPP;
import com.apple.mrj.macos.toolbox.ControlHandle;
import com.apple.mrj.macos.toolbox.Point;
import com.apple.mrj.macos.toolbox.QuickdrawFont;
import com.apple.mrj.macos.toolbox.Rect;
import com.apple.mrj.macos.toolbox.Str255;
import com.apple.mrj.macos.toolbox.ToolboxObject;
import com.apple.mrj.macos.toolbox.WindowRef;

public class ControlHandleWFont
extends ControlHandle
implements ToolboxObject {
    QuickdrawFont qdFont;
    QuickdrawFont currentFont;
    WindowRef win;

    public ControlHandleWFont(WindowRef windowRef, Rect rect, Str255 str255, boolean bl, short s, QuickdrawFont quickdrawFont) {
        super(windowRef, rect, str255, bl, (short)(s + 8));
        this.qdFont = quickdrawFont;
        this.win = this.getWindowRef();
    }

    public void setFont(QuickdrawFont quickdrawFont) {
        this.qdFont = quickdrawFont;
    }

    public QuickdrawFont getFont() {
        return this.qdFont;
    }

    private void setup() {
        this.win.setPort();
        this.currentFont = this.win.currentFont();
        this.qdFont.install();
    }

    private void restore() {
        this.currentFont.install();
    }

    public void show() {
        this.setup();
        super.show();
        this.restore();
    }

    public void draw() {
        this.setup();
        super.draw();
        this.restore();
    }

    public short track(Point point, ControlActionClosureUPP controlActionClosureUPP) {
        this.setup();
        short s = super.track(point, controlActionClosureUPP);
        this.restore();
        return s;
    }

    public void setValue(short s) {
        this.setup();
        super.setValue(s);
        this.restore();
    }

    public void setMinimum(short s) {
        this.setup();
        super.setMinimum(s);
        this.restore();
    }

    public void setMaximum(short s) {
        this.setup();
        super.setMaximum(s);
        this.restore();
    }

    public void setTitle(String string) {
        this.setup();
        super.setTitle(string);
        this.restore();
    }

    public void move(short s, short s2) {
        this.setup();
        super.move(s, s2);
        this.restore();
    }

    public void size(short s, short s2) {
        this.setup();
        super.size(s, s2);
        this.restore();
    }

    public void hilite(short s) {
        this.setup();
        super.hilite(s);
        this.restore();
    }

    public void drag(Point point, Rect rect, Rect rect2, short s) {
        this.setup();
        super.drag(point, rect, rect2, s);
        this.restore();
    }

    public void setBounds(Rect rect) {
        this.setup();
        super.setBounds(rect);
        this.restore();
    }
}

