/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.jdirect;

import com.apple.mrj.internal.jdirect.Accessor;
import com.apple.mrj.internal.jdirect.ArrayCopy;
import com.apple.mrj.jdirect.Struct;

public abstract class PointerStruct
extends Struct {
    protected int pointer;

    public PointerStruct(int n) {
        this.pointer = n;
    }

    protected final boolean getBooleanAt(int n) {
        return Accessor.getBooleanFromPointer(this.pointer, n);
    }

    protected final byte getByteAt(int n) {
        return Accessor.getByteFromPointer(this.pointer, n);
    }

    protected final char getCharAt(int n) {
        return Accessor.getCharFromPointer(this.pointer, n);
    }

    protected final short getShortAt(int n) {
        return Accessor.getShortFromPointer(this.pointer, n);
    }

    protected final int getIntAt(int n) {
        return Accessor.getIntFromPointer(this.pointer, n);
    }

    protected final long getLongAt(int n) {
        return Accessor.getLongFromPointer(this.pointer, n);
    }

    protected final float getFloatAt(int n) {
        return Accessor.getFloatFromPointer(this.pointer, n);
    }

    protected final double getDoubleAt(int n) {
        return Accessor.getDoubleFromPointer(this.pointer, n);
    }

    protected final void setBooleanAt(int n, boolean bl) {
        Accessor.setBooleanInPointer(this.pointer, n, bl);
    }

    protected final void setByteAt(int n, byte by) {
        Accessor.setByteInPointer(this.pointer, n, by);
    }

    protected final void setCharAt(int n, char c) {
        Accessor.setCharInPointer(this.pointer, n, c);
    }

    protected final void setShortAt(int n, short s) {
        Accessor.setShortInPointer(this.pointer, n, s);
    }

    protected final void setIntAt(int n, int n2) {
        Accessor.setIntInPointer(this.pointer, n, n2);
    }

    protected final void setLongAt(int n, long l) {
        Accessor.setLongInPointer(this.pointer, n, l);
    }

    protected final void setFloatAt(int n, float f) {
        Accessor.setFloatInPointer(this.pointer, n, f);
    }

    protected final void setDoubleAt(int n, double d) {
        Accessor.setDoubleInPointer(this.pointer, n, d);
    }

    protected void setBytesAt(int n, byte[] byArray) {
        ArrayCopy.copyArrayToPointer(byArray, 0, this.pointer, n, byArray.length);
    }

    protected void setStructAt(int n, Struct struct) {
        byte[] byArray = struct.getBytesAt(0, struct.getSize());
        this.setBytesAt(n, byArray);
    }

    public byte[] getBytesAt(int n, int n2) {
        byte[] byArray = new byte[n2];
        ArrayCopy.copyPointerToArray(this.pointer, n, byArray, 0, n2);
        return byArray;
    }

    public byte[] getBytes() {
        return this.getBytesAt(0, this.getSize());
    }

    public abstract int getSize();

    public final int getPointer() {
        return this.pointer;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof PointerStruct) {
            PointerStruct pointerStruct = (PointerStruct)object;
            return this.pointer == pointerStruct.pointer;
        }
        return false;
    }
}

