/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.jdirect;

import com.apple.mrj.internal.jdirect.Accessor;
import com.apple.mrj.internal.jdirect.ArrayCopy;
import com.apple.mrj.jdirect.Struct;

public class GenericPointer {
    protected int pointer;

    public GenericPointer(int n) {
        this.pointer = n;
    }

    public final boolean getBooleanAt(int n) {
        return Accessor.getBooleanFromPointer(this.pointer, n);
    }

    public final byte getByteAt(int n) {
        return Accessor.getByteFromPointer(this.pointer, n);
    }

    public final char getCharAt(int n) {
        return Accessor.getCharFromPointer(this.pointer, n);
    }

    public final short getShortAt(int n) {
        return Accessor.getShortFromPointer(this.pointer, n);
    }

    public final int getIntAt(int n) {
        return Accessor.getIntFromPointer(this.pointer, n);
    }

    public final long getLongAt(int n) {
        return Accessor.getLongFromPointer(this.pointer, n);
    }

    public final float getFloatAt(int n) {
        return Accessor.getFloatFromPointer(this.pointer, n);
    }

    public final double getDoubleAt(int n) {
        return Accessor.getDoubleFromPointer(this.pointer, n);
    }

    public final void setBooleanAt(int n, boolean bl) {
        Accessor.setBooleanInPointer(this.pointer, n, bl);
    }

    public final void setByteAt(int n, byte by) {
        Accessor.setByteInPointer(this.pointer, n, by);
    }

    public final void setCharAt(int n, char c) {
        Accessor.setCharInPointer(this.pointer, n, c);
    }

    public final void setShortAt(int n, short s) {
        Accessor.setShortInPointer(this.pointer, n, s);
    }

    public final void setIntAt(int n, int n2) {
        Accessor.setIntInPointer(this.pointer, n, n2);
    }

    public final void setLongAt(int n, long l) {
        Accessor.setLongInPointer(this.pointer, n, l);
    }

    public final void setFloatAt(int n, float f) {
        Accessor.setFloatInPointer(this.pointer, n, f);
    }

    public final void setDoubleAt(int n, double d) {
        Accessor.setDoubleInPointer(this.pointer, n, d);
    }

    public void setBytesAt(int n, byte[] byArray) {
        ArrayCopy.copyArrayToPointer(byArray, 0, this.pointer, n, byArray.length);
    }

    public void setStructAt(int n, Struct struct) {
        byte[] byArray = struct.getBytesAt(0, struct.getSize());
        this.setBytesAt(n, byArray);
    }

    public byte[] getBytesAt(int n, int n2) {
        byte[] byArray = new byte[n2];
        ArrayCopy.copyPointerToArray(this.pointer, n, byArray, 0, n2);
        return byArray;
    }

    public final int getPointer() {
        return this.pointer;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof GenericPointer) {
            GenericPointer genericPointer = (GenericPointer)object;
            return this.pointer == genericPointer.pointer;
        }
        return false;
    }
}

