/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.jdirect;

import com.apple.mrj.internal.jdirect.Accessor;
import com.apple.mrj.internal.jdirect.ArrayCopy;
import com.apple.mrj.jdirect.Struct;

public class GenericHandle {
    protected int handle;

    public GenericHandle(int n) {
        this.handle = n;
    }

    public final boolean getBooleanAt(int n) {
        return Accessor.getBooleanFromHandle(this.handle, n);
    }

    public final byte getByteAt(int n) {
        return Accessor.getByteFromHandle(this.handle, n);
    }

    public final char getCharAt(int n) {
        return Accessor.getCharFromHandle(this.handle, n);
    }

    public final short getShortAt(int n) {
        return Accessor.getShortFromHandle(this.handle, n);
    }

    public final int getIntAt(int n) {
        return Accessor.getIntFromHandle(this.handle, n);
    }

    public final long getLongAt(int n) {
        return Accessor.getLongFromHandle(this.handle, n);
    }

    public final float getFloatAt(int n) {
        return Accessor.getFloatFromHandle(this.handle, n);
    }

    public final double getDoubleAt(int n) {
        return Accessor.getDoubleFromHandle(this.handle, n);
    }

    public final void setBooleanAt(int n, boolean bl) {
        Accessor.setBooleanInHandle(this.handle, n, bl);
    }

    public final void setByteAt(int n, byte by) {
        Accessor.setByteInHandle(this.handle, n, by);
    }

    public final void setCharAt(int n, char c) {
        Accessor.setCharInHandle(this.handle, n, c);
    }

    public final void setShortAt(int n, short s) {
        Accessor.setShortInHandle(this.handle, n, s);
    }

    public final void setIntAt(int n, int n2) {
        Accessor.setIntInHandle(this.handle, n, n2);
    }

    public final void setLongAt(int n, long l) {
        Accessor.setLongInHandle(this.handle, n, l);
    }

    public final void setFloatAt(int n, float f) {
        Accessor.setFloatInHandle(this.handle, n, f);
    }

    public final void setDoubleAt(int n, double d) {
        Accessor.setDoubleInHandle(this.handle, n, d);
    }

    public void setBytesAt(int n, byte[] byArray) {
        ArrayCopy.copyArrayToHandle(byArray, 0, this.handle, n, byArray.length);
    }

    public void setStructAt(int n, Struct struct) {
        byte[] byArray = struct.getBytesAt(0, struct.getSize());
        this.setBytesAt(n, byArray);
    }

    public byte[] getBytesAt(int n, int n2) {
        byte[] byArray = new byte[n2];
        ArrayCopy.copyHandleToArray(this.handle, n, byArray, 0, n2);
        return byArray;
    }

    public final int getHandle() {
        return this.handle;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof GenericHandle) {
            GenericHandle genericHandle = (GenericHandle)object;
            return this.handle == genericHandle.handle;
        }
        return false;
    }
}

