/*
 * Decompiled with CFR 0.152.
 */
package com.apple.memory;

import com.apple.memory.Disposeable;
import com.apple.memory.PointerObject;
import com.apple.memory.StdCLib;

public abstract class HeapPointer
extends PointerObject
implements Disposeable {
    protected HeapPointer(int n, boolean bl) {
        super(n);
        this.pointer = this.AllocatePointer(n, bl);
        this.size = n;
    }

    protected HeapPointer(byte[] byArray) {
        super(byArray.length);
        this.pointer = this.AllocatePointer(this.size, false);
        StdCLib.memcpy(this.pointer, byArray, byArray.length);
    }

    public synchronized void Dispose() {
        if (this.pointer != 0) {
            this.FreePointer(this.pointer);
            this.pointer = 0;
        }
    }

    protected abstract int AllocatePointer(int var1, boolean var2) throws NullPointerException;

    protected abstract void FreePointer(int var1);

    protected void finalize() {
        this.Dispose();
    }
}

