/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.MacOSError;
import com.apple.MacOS.TranslateString;
import com.apple.MacOS.gxColor;
import com.apple.MacOS.gxLine;
import com.apple.MacOS.gxPoint;
import com.apple.MacOS.gxRectangle;
import com.apple.MacOS.gxReference;
import com.apple.MacOS.gxViewPort;

public class gxShape
extends gxReference {
    public static final int gxEmptyType = 1;
    public static final int gxPointType = 2;
    public static final int gxLineType = 3;
    public static final int gxCurveType = 4;
    public static final int gxRectangleType = 5;
    public static final int gxPolygonType = 6;
    public static final int gxPathType = 7;
    public static final int gxBitmapType = 8;
    public static final int gxTextType = 9;
    public static final int gxGlyphType = 10;
    public static final int gxLayoutType = 11;
    public static final int gxFullType = 12;
    public static final int gxPictureType = 13;
    public static final int gxNoFill = 0;
    public static final int gxOpenFrameFill = 1;
    public static final int gxFrameFill = 1;
    public static final int gxClosedFrameFill = 2;
    public static final int gxHollowFill = 2;
    public static final int gxEvenOddFill = 3;
    public static final int gxSolidFill = 3;
    public static final int gxWindingFill = 4;
    public static final int gxInverseEvenOddFill = 5;
    public static final int gxInverseSolidFill = 5;
    public static final int gxInverseFill = 5;
    public static final int gxInverseWindingFill = 6;

    public gxShape(int n) throws MacOSError {
        super(gxShape.GXNewShape(n));
        this.CheckReference();
    }

    public gxShape(gxRectangle gxRectangle2) throws MacOSError {
        super(gxShape.GXNewRectangle(gxRectangle2));
        this.CheckReference();
    }

    public gxShape(gxLine gxLine2) throws MacOSError {
        super(gxShape.GXNewLine(gxLine2.vector));
        this.CheckReference();
    }

    public gxShape(String string, gxPoint gxPoint2) throws MacOSError {
        int n = string.length();
        byte[] byArray = TranslateString.asBytes(string);
        this.reference = gxShape.GXNewText(n, byArray, gxPoint2);
        this.CheckReference();
    }

    public void Dispose() {
        if (this.reference != 0) {
            gxShape.GXDisposeShape(this.reference);
            this.reference = 0;
        }
    }

    public void SetViewPort(gxViewPort gxViewPort2) {
        int[] nArray = new int[]{gxViewPort2.reference};
        gxShape.GXSetShapeViewPorts(this.reference, 1, nArray);
    }

    public void SetViewPorts(gxViewPort[] gxViewPortArray) {
        int n = gxViewPortArray.length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = gxViewPortArray[n2].reference;
            ++n2;
        }
        gxShape.GXSetShapeViewPorts(this.reference, n, nArray);
    }

    public void SetColor(gxColor gxColor2) {
        gxShape.GXSetShapeColor(this.reference, gxColor2.getBytes());
    }

    public void SetFill(int n) {
        gxShape.GXSetShapeFill(this.reference, n);
    }

    public void Draw() {
        gxShape.GXDrawShape(this.reference);
    }

    private static native int GXNewShape(int var0);

    private static native void GXDisposeShape(int var0);

    private static native int GXNewRectangle(gxRectangle var0);

    private static native int GXNewLine(int[] var0);

    private static native int GXNewText(int var0, byte[] var1, gxPoint var2);

    private static native void GXSetShapeViewPorts(int var0, int var1, int[] var2);

    private static native void GXSetShapeColor(int var0, byte[] var1);

    private static native void GXSetShapeFill(int var0, int var1);

    private static native void GXDrawShape(int var0);
}

