/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.GrafPtr;
import com.apple.MacOS.MenuManager;
import com.apple.MacOS.Point;
import com.apple.MacOS.Rect;
import com.apple.MacOS.Region;
import com.apple.MacOS.RgnHandle;
import com.apple.MacOS.Str255;
import com.apple.MacOS.StringPtr;
import com.apple.MacOS.ToolboxObject;
import com.apple.memory.HandleObject;

public class WindowRef
extends GrafPtr
implements ToolboxObject {
    public static final int sizeOfWindowRecord = 156;
    private boolean hasGrowBox;
    public static final short documentProc = 0;
    public static final short dBoxProc = 1;
    public static final short plainDBox = 2;
    public static final short altDBoxProc = 3;
    public static final short noGrowDocProc = 4;
    public static final short movableDBoxProc = 5;
    public static final short zoomDocProc = 8;
    public static final short zoomNoGrow = 9;
    public static final short rDocProc = 16;
    public static final short dialogKind = 2;
    public static final short userKind = 8;
    public static final short inDesk = 0;
    public static final short inMenuBar = 1;
    public static final short inSysWindow = 2;
    public static final short inContent = 3;
    public static final short inDrag = 4;
    public static final short inGrow = 5;
    public static final short inGoAway = 6;
    public static final short inZoomIn = 7;
    public static final short inZoomOut = 8;
    private static Rect wideOpenBounds = new Rect(Short.MIN_VALUE, Short.MIN_VALUE, Short.MAX_VALUE, Short.MAX_VALUE);
    protected boolean owner;
    private Region updateRgn;

    public WindowRef(Rect rect, StringPtr stringPtr, boolean bl, short s, boolean bl2, int n) {
        super(WindowRef.NewCWindow(0, rect, stringPtr.getBytes(), bl, s, -1, bl2, n));
        this.owner = true;
        this.size = 156;
        this.hasGrowBox = s == 8;
    }

    public WindowRef(Rect rect, StringPtr stringPtr, boolean bl, boolean bl2, boolean bl3) {
        super(WindowRef.NewCWindow(0, rect, stringPtr.getBytes(), bl, bl3 ? (short)8 : 4, -1, bl2, 0));
        this.owner = true;
        this.size = 156;
        this.hasGrowBox = bl3;
    }

    public WindowRef(Rect rect, StringPtr stringPtr, boolean bl, boolean bl2) {
        this(rect, stringPtr, bl, bl2, true);
    }

    public WindowRef(int n) {
        this.pointer = n;
        this.owner = false;
        this.size = 156;
    }

    WindowRef() {
    }

    public void Dispose() {
        if (this.pointer != 0) {
            if (this.owner) {
                this.UnsafeDispose();
            }
            this.pointer = 0;
        }
    }

    public void UnsafeDispose() {
        WindowRef.DisposeWindow(this.pointer);
    }

    public void SetTitle(String string) {
        this.SetTitle(new StringPtr(string));
    }

    public void SetTitle(StringPtr stringPtr) {
        WindowRef.SetWTitle(this.pointer, stringPtr.getBytes());
    }

    public String GetTitle() {
        Str255 str255 = new Str255();
        WindowRef.GetWTitle(this.pointer, str255.getBytes());
        return str255.asString();
    }

    public void DrawGrowIcon() {
        if (this.hasGrowBox) {
            WindowRef.DrawGrowIcon(this.pointer);
        }
    }

    public void Select() {
        WindowRef.SelectWindow(this.pointer);
    }

    public void Show() {
        WindowRef.ShowWindow(this.pointer);
    }

    public void Hide() {
        WindowRef.HideWindow(this.pointer);
    }

    public void ShowHide(boolean bl) {
        WindowRef.ShowHide(this.pointer, bl);
    }

    public void HiliteWindow(boolean bl) {
        WindowRef.HiliteWindow(this.pointer, bl);
    }

    public void BringToFront() {
        WindowRef.BringToFront(this.pointer);
    }

    public void SendBehind(WindowRef windowRef) {
        WindowRef.SendBehind(this.pointer, windowRef == null ? 0 : windowRef.getPointer());
    }

    public static WindowRef GetFrontWindow() {
        int n = WindowRef.FrontWindow();
        if (n != 0) {
            return new WindowRef(n);
        }
        return null;
    }

    public boolean IsFront() {
        return WindowRef.FrontWindow() == this.pointer;
    }

    public void DragWindow(int n) {
        WindowRef.DragWindow(this.pointer, n, wideOpenBounds);
    }

    public void Move(short s, short s2, boolean bl) {
        short s3;
        if (s2 < 0) {
            s2 = 0;
        }
        if (s2 < (s3 = (short)(MenuManager.getMBarHeight() * 2))) {
            s2 = (short)(s2 + s3);
        }
        WindowRef.MoveWindow(this.pointer, s, s2, bl);
    }

    public void Move(short s, short s2) {
        this.Move(s, s2, false);
    }

    public int Grow(Point point, Rect rect) {
        return WindowRef.GrowWindow(this.pointer, point.toInt(), rect);
    }

    public void Size(short s, short s2, boolean bl) {
        WindowRef.SizeWindow(this.pointer, s, s2, bl);
    }

    public void Size(short s, short s2) {
        this.Size(s, s2, true);
    }

    public boolean TrackGoAway(Point point) {
        return WindowRef.TrackGoAway(this.pointer, point.toInt());
    }

    public boolean TrackBox(Point point, short s) {
        return WindowRef.TrackBox(this.pointer, point.toInt(), s);
    }

    public void Zoom(short s, boolean bl) {
        WindowRef.ZoomWindow(this.pointer, s, bl);
    }

    public void BeginUpdate() {
        WindowRef.BeginUpdate(this.pointer);
    }

    public void EndUpdate() {
        WindowRef.EndUpdate(this.pointer);
    }

    public void Inval(Rect rect) {
        this.SetPort();
        WindowRef.InvalRect(rect);
    }

    public void Inval(RgnHandle rgnHandle) {
        this.SetPort();
        WindowRef.InvalRgn(rgnHandle.getHandle());
    }

    public void Valid(Rect rect) {
        this.SetPort();
        WindowRef.ValidRect(rect);
    }

    public void Valid(RgnHandle rgnHandle) {
        this.SetPort();
        WindowRef.ValidRgn(rgnHandle.getHandle());
    }

    public Region GetUpdateRgn() {
        if (this.updateRgn == null) {
            HandleObject handleObject = new HandleObject();
            handleObject.setHandle(super.getIntAt(122));
            this.updateRgn = new Region(handleObject);
        }
        return this.updateRgn;
    }

    boolean InGrowZone(Point point) {
        Rect rect = this.Bounds();
        return this.hasGrowBox && point.getH() > rect.Width() - 15 && point.getV() > rect.Height() - 15;
    }

    public Point GetOrigin() {
        Point point = new Point(0, 0);
        this.SetPort();
        point.LocalToGlobal();
        return point;
    }

    public void SetBounds(Rect rect) {
        this.Move(rect.getLeft(), rect.getTop());
        this.Size(rect.Width(), rect.Height());
    }

    public Rect GetBounds() {
        return this.Bounds();
    }

    public void Update(Region region) {
        this.DrawGrowIcon();
    }

    public void Draw() {
        this.DrawGrowIcon();
    }

    public WindowRef getWindowRef() {
        return this;
    }

    public void IsVisible(boolean bl) {
        if (bl) {
            this.Show();
        } else {
            this.Hide();
        }
    }

    public boolean IsVisible() {
        return this.getByteAt(110) != 0;
    }

    public void IsHilited(boolean bl) {
    }

    public boolean IsHilited() {
        return this.getByteAt(111) != 0;
    }

    public boolean HitTest(Point point) {
        return this.Bounds().Contains(point);
    }

    protected void finalize() {
        this.Dispose();
    }

    private static native int NewCWindow(int var0, Rect var1, byte[] var2, boolean var3, short var4, int var5, boolean var6, int var7);

    private static native void DisposeWindow(int var0);

    private static native int FrontWindow();

    private static native void SetWTitle(int var0, byte[] var1);

    private static native void GetWTitle(int var0, byte[] var1);

    private static native void DrawGrowIcon(int var0);

    private static native void SelectWindow(int var0);

    private static native void ShowWindow(int var0);

    private static native void HideWindow(int var0);

    private static native void ShowHide(int var0, boolean var1);

    private static native void HiliteWindow(int var0, boolean var1);

    private static native void BringToFront(int var0);

    private static native void SendBehind(int var0, int var1);

    private static native void DragWindow(int var0, int var1, Rect var2);

    private static native void MoveWindow(int var0, short var1, short var2, boolean var3);

    private static native int GrowWindow(int var0, int var1, Rect var2);

    private static native void SizeWindow(int var0, short var1, short var2, boolean var3);

    private static native boolean TrackGoAway(int var0, int var1);

    private static native boolean TrackBox(int var0, int var1, short var2);

    private static native void ZoomWindow(int var0, short var1, boolean var2);

    private static native void BeginUpdate(int var0);

    private static native void EndUpdate(int var0);

    private static native void InvalRect(Rect var0);

    private static native void InvalRgn(int var0);

    private static native void ValidRect(Rect var0);

    private static native void ValidRgn(int var0);
}

