/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.MacOSError;
import com.apple.MacOS.MacOSLibraries;
import com.apple.MacOS.SCStatus;
import com.apple.MacOS.SndCallBackUPP;
import com.apple.MacOS.SndCommand;
import com.apple.MacOS.SoundChannelPointer;
import com.apple.MacOS.SoundHeader;
import com.apple.MacOS.UniversalProcPtr;

public class SndChannel
extends SoundChannelPointer {
    public static final int sizeOfSndChannel = 36;
    public static final int stdQLength = 128;
    public static final short squareWaveSynth = 1;
    public static final short waveTableSynth = 3;
    public static final short sampledSynth = 5;
    private static final SndCommand freqCommand = new SndCommand(42);
    private static final SndCommand freqDurationCommand = new SndCommand(40);
    private static final SndCommand bufferCommand = new SndCommand(81);
    private static final SndCommand soundCommand = new SndCommand(80);
    private static final SndCommand quietCommand = new SndCommand(3);
    private static final SndCommand flushCommand = new SndCommand(4);
    private static final SndCommand callbackCommand = new SndCommand(13);
    private static final SCStatus status = new SCStatus();
    SndCallBackUPP itsCallbackUPP;
    private static String[] kNativeLibraryNames = MacOSLibraries.kInterfaceLibNames;

    public SndChannel(short s, short s2) throws MacOSError {
        super(36 + s2 * 8, true);
        this.setQLength(s2);
        int[] nArray = new int[]{this.pointer};
        short s3 = SndChannel.SndNewChannel(nArray, s, 0, 0);
        MacOSError.CheckResult(s3);
    }

    public SndChannel(short s) throws MacOSError {
        this(s, 128);
    }

    public synchronized void Dispose() {
        if (this.pointer != 0) {
            short s = SndChannel.SndDisposeChannel(this.pointer, true);
            super.Dispose();
        }
    }

    public void DoCommand(SndCommand sndCommand, boolean bl) throws MacOSError {
        short s = SndChannel.SndDoCommand(this.pointer, sndCommand, bl);
        MacOSError.CheckResult(s);
    }

    public void DoImmediate(SndCommand sndCommand) throws MacOSError {
        short s = SndChannel.SndDoImmediate(this.pointer, sndCommand);
        MacOSError.CheckResult(s);
    }

    public void PlayNote(int n) throws MacOSError {
        SndCommand sndCommand = freqCommand;
        synchronized (sndCommand) {
            freqCommand.setParam2(n);
            this.DoImmediate(freqCommand);
        }
    }

    public void PlayNote(int n, short s) throws MacOSError {
        SndCommand sndCommand = freqDurationCommand;
        synchronized (sndCommand) {
            freqDurationCommand.setParam1((short)(s * 2));
            freqDurationCommand.setParam2(n);
            this.DoImmediate(freqDurationCommand);
        }
    }

    public void PlaySound(SoundHeader soundHeader) {
        SndCommand sndCommand = bufferCommand;
        synchronized (sndCommand) {
            bufferCommand.setParam2(soundHeader.getPointer());
            this.DoCommand(bufferCommand, false);
        }
    }

    public void LoopSound(SoundHeader soundHeader) {
        SndCommand sndCommand = soundCommand;
        synchronized (sndCommand) {
            soundCommand.setParam2(soundHeader.getPointer());
            this.DoImmediate(soundCommand);
            this.PlayNote(60);
        }
    }

    public void Quiet() throws MacOSError {
        this.DoImmediate(quietCommand);
    }

    public void Flush() throws MacOSError {
        this.DoImmediate(flushCommand);
    }

    public boolean Busy() throws MacOSError {
        SCStatus sCStatus = status;
        synchronized (sCStatus) {
            MacOSError.CheckResult(SndChannel.SndChannelStatus(this.pointer, (short)status.getSize(), status));
            boolean bl = status.getChannelBusy();
            Object var3_3 = null;
            return bl;
        }
    }

    public synchronized boolean Full() {
        short s;
        short s2 = this.getQHead();
        return s2 == (s = this.getQTail());
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public synchronized short Capacity() {
        short s;
        block5: {
            short s2;
            short s3;
            short s4;
            short s5;
            block4: {
                s5 = this.getQLength();
                s4 = this.getQHead();
                s3 = this.getQTail();
                if (s4 == -1) {
                    return s5;
                }
                s = 0;
                if (!true) break block4;
                s2 = s3;
                s3 = (short)(s2 + 1);
                if (s2 == s4) break block5;
            }
            do {
                s = (short)(s + 1);
                if (s3 == s5) {
                    s3 = 0;
                }
                s2 = s3;
                s3 = (short)(s2 + 1);
            } while (s2 != s4);
        }
        return s;
    }

    public synchronized void CallBackWait() {
        if (this.itsCallbackUPP == null) {
            this.itsCallbackUPP = new SndCallBackUPP(this);
            this.setCallBack(this.itsCallbackUPP);
        }
        this.DoCommand(callbackCommand, false);
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {}
    }

    final void setCallBack(SndCallBackUPP sndCallBackUPP) {
        this.setIntAt(8, UniversalProcPtr.getUPP(sndCallBackUPP));
    }

    final void setQLength(short s) {
        this.setShortAt(30, s);
    }

    final short getQLength() {
        return this.getShortAt(30);
    }

    final short getQHead() {
        return this.getShortAt(32);
    }

    final short getQTail() {
        return this.getShortAt(34);
    }

    private static native short SndNewChannel(int[] var0, short var1, int var2, int var3);

    private static native short SndDisposeChannel(int var0, boolean var1);

    private static native short SndDoCommand(int var0, SndCommand var1, boolean var2);

    private static native short SndDoImmediate(int var0, SndCommand var1);

    private static native short SndChannelStatus(int var0, short var1, SCStatus var2);
}

