/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.MacOSLibraries;
import com.apple.MacOS.ResourceFile;
import com.apple.MacOS.Str255;
import com.apple.memory.HandleObject;

public class ResourceHandle
extends HandleObject {
    protected ResourceFile itsFile;
    protected Str255 itsName;
    protected int itsID;
    protected int itsType;
    protected boolean itsInMemory = false;
    protected boolean itsModified = false;
    protected boolean itsOwnedElsewhere = false;
    private static String[] kNativeLibraryNames = MacOSLibraries.kInterfaceLibNames;

    protected ResourceHandle(ResourceFile resourceFile, int n) {
        super(n);
        this.itsFile = resourceFile;
        this.itsName = new Str255();
        short[] sArray = new short[1];
        int[] nArray = new int[1];
        ResourceHandle.GetResInfo(n, sArray, nArray, this.itsName.getBytes());
        this.itsID = sArray[0];
        this.itsType = nArray[0];
        this.itsOwnedElsewhere = this.handleInMemory();
    }

    public int getID() {
        return this.itsID;
    }

    public int getType() {
        return this.itsType;
    }

    public void setSize(int n) {
        if (!this.itsFile.isReadOnly()) {
            if (!this.itsInMemory) {
                this.Load();
            }
            super.setSize(n);
        }
    }

    public int getSize() {
        if (this.itsInMemory) {
            return super.getSize();
        }
        return ResourceHandle.GetResourceSizeOnDisk(this.handle);
    }

    public void Load() {
        if (!this.itsInMemory) {
            ResourceHandle.LoadResource(this.handle);
            if (!this.handleInMemory()) {
                throw new OutOfMemoryError("Can't load resource");
            }
            ResourceHandle.HNoPurge(this.handle);
            this.itsInMemory = true;
        }
    }

    public void Release() {
        if (this.itsModified) {
            if (!this.itsOwnedElsewhere) {
                ResourceHandle.ChangedResource(this.handle);
                ResourceHandle.WriteResource(this.handle);
                ResourceHandle.HPurge(this.handle);
            }
            this.itsModified = false;
            this.itsInMemory = false;
        }
    }

    public void writeResource() {
        if (this.itsModified) {
            ResourceHandle.ChangedResource(this.handle);
            ResourceHandle.WriteResource(this.handle);
            this.itsModified = false;
        }
    }

    protected void finalize() {
        if (this.handle != 0 && !this.itsOwnedElsewhere) {
            ResourceHandle.ReleaseResource(this.handle);
        }
        this.handle = 0;
    }

    public void getBytes(int n, byte[] byArray, int n2, int n3) {
        if (!this.itsInMemory) {
            this.Load();
        }
        super.getBytes(n, byArray, n2, n3);
    }

    public void setBytes(int n, byte[] byArray, int n2, int n3) {
        if (!this.itsInMemory) {
            this.Load();
        }
        super.setBytes(n, byArray, n2, n3);
        this.itsModified = true;
    }

    private static native int GetResourceSizeOnDisk(int var0);

    private static native void LoadResource(int var0);

    private static native int HNoPurge(int var0);

    private static native int HPurge(int var0);

    private static native void GetResInfo(int var0, short[] var1, int[] var2, byte[] var3);

    private static native void RemoveResource(int var0);

    private static native int NewHandle(int var0);

    private static native void AddResource(int var0, int var1, short var2, byte[] var3);

    private static native void ChangedResource(int var0);

    private static native void WriteResource(int var0);

    private static native void ReleaseResource(int var0);
}

