/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.MacOSError;
import com.apple.MacOS.NoteAllocator;
import com.apple.MacOS.NoteRequest;
import com.apple.MacOS.QuickTimeLibrary;
import com.apple.NativeObject;

public class NoteChannel
implements NativeObject {
    private static String[] kNativeLibraryNames = QuickTimeLibrary.kNativeLibraryNames;
    private int channel;
    private int component;

    public NoteChannel(NoteAllocator noteAllocator, NoteRequest noteRequest) throws MacOSError {
        this.component = noteAllocator.getComponent();
        int[] nArray = new int[1];
        int n = NoteChannel.NANewNoteChannel(this.component, noteRequest.getPointer(), nArray);
        MacOSError.CheckResult(n);
        this.channel = nArray[0];
    }

    public void Dispose() {
        if (this.channel != 0 && this.component != 0) {
            NoteChannel.NADisposeNoteChannel(this.component, this.channel);
            this.channel = 0;
            this.component = 0;
        }
    }

    public void PlayNote(int n, int n2) throws MacOSError {
        int n3 = NoteChannel.NAPlayNote(this.component, this.channel, n, n2);
        MacOSError.CheckResult(n3);
    }

    private static native int NANewNoteChannel(int var0, int var1, int[] var2);

    private static native int NADisposeNoteChannel(int var0, int var1);

    private static native int NAPlayNote(int var0, int var1, int var2, int var3);
}

