/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.Arc;
import com.apple.MacOS.FontInfo;
import com.apple.MacOS.MacOSLibraries;
import com.apple.MacOS.MemoryUtils;
import com.apple.MacOS.Pattern;
import com.apple.MacOS.PenState;
import com.apple.MacOS.Point;
import com.apple.MacOS.PolyHandle;
import com.apple.MacOS.Ptr;
import com.apple.MacOS.QuickdrawFont;
import com.apple.MacOS.RGBColor;
import com.apple.MacOS.Rect;
import com.apple.MacOS.Region;
import com.apple.MacOS.Shape;
import com.apple.MacOS.TextUtilities;
import com.apple.MacOS.TranslateString;
import com.apple.MacOS.WindowRef;
import com.apple.memory.HandleObject;
import com.apple.memory.PointerObject;

public class GrafPtr
extends PointerObject {
    public static final int sizeOfGrafPort = 108;
    private Region clipRgn;
    private static String[] kNativeLibraryNames = MacOSLibraries.kInterfaceLibNames;

    public GrafPtr() {
        super(108);
        GrafPtr.GetPort(this);
    }

    public GrafPtr(int n) {
        super(108);
        this.pointer = n;
    }

    public native void SetOrigin(short var1, short var2);

    public Point GetOrigin() {
        return MemoryUtils.PointAt(this, 24);
    }

    public WindowRef getWindowRef() {
        return (WindowRef)this;
    }

    public boolean HitTest(Point point) {
        return this.Bounds().Contains(point);
    }

    public Rect Bounds() {
        return MemoryUtils.RectAt(this, 16);
    }

    public void GetClip(Region region) {
        region.Copy(this.GetClip());
    }

    public void Clip(Region region) {
        this.GetClip().Copy(region);
    }

    public void ResetClip() {
        Rect rect = new Rect(-32767, -32767, Short.MAX_VALUE, Short.MAX_VALUE);
        this.Clip(rect);
    }

    public void Clip(Rect rect) {
        this.SetPort();
        GrafPtr.ClipRect(rect);
    }

    private short txFont() {
        return this.getShortAt(76);
    }

    private short txFace() {
        return this.getShortAt(78);
    }

    private short txMode() {
        return this.getShortAt(80);
    }

    private short txSize() {
        return this.getShortAt(82);
    }

    public QuickdrawFont CurrentFont() {
        return new QuickdrawFont(this.txFont(), this.txFace(), this.txSize());
    }

    public FontInfo getFontInfo() {
        return new FontInfo(this);
    }

    public void GetPort() {
        GrafPtr.GetPort(this);
    }

    public void SetPort() {
        GrafPtr.SetPort(this.pointer);
    }

    public int Draw(String string, short s, short s2) {
        return this.Draw(TranslateString.asPtr(string), s, s2);
    }

    public int Draw(Ptr ptr, short s, short s2) {
        return this.Draw(ptr.getBytes(), s, s2, (short)0, (short)ptr.getSize());
    }

    public int Draw(char[] cArray, short s, short s2, short s3, short s4) {
        return 0;
    }

    public int Draw(byte[] byArray, short s, short s2, short s3, short s4) {
        short s5 = 0;
        this.SetPort();
        PenState.MoveTo(s, s2);
        s5 = TextUtilities.TextWidth(byArray, s3, s4);
        TextUtilities.Draw(byArray, s3, s4);
        return s5;
    }

    public void DrawLine(int n, int n2, int n3, int n4) {
        this.SetPort();
        PenState.MoveTo((short)n, (short)n2);
        PenState.LineTo((short)n, (short)n2);
    }

    public void DrawPolyline(int[] nArray, int[] nArray2, int n) {
        this.SetPort();
        PolyHandle.DrawPolyline(nArray, nArray2, n);
    }

    public void Frame(Shape shape) {
        this.SetPort();
        shape.Frame();
    }

    public void Paint(Shape shape) {
        this.SetPort();
        shape.Paint();
    }

    public void Fill(Shape shape, Pattern pattern) {
        this.SetPort();
        shape.Fill(pattern);
    }

    public void Erase(Shape shape) {
        this.SetPort();
        shape.Erase();
    }

    public void Invert(Shape shape) {
        this.SetPort();
        shape.Invert();
    }

    public void Frame(Rect rect, short s, short s2) {
        this.SetPort();
        rect.Frame(s, s2);
    }

    public void Paint(Rect rect, short s, short s2) {
        this.SetPort();
        rect.Paint(s, s2);
    }

    public void Fill(Rect rect, short s, short s2, Pattern pattern) {
        this.SetPort();
        rect.Fill(s, s2, pattern);
    }

    public void Erase(Rect rect, short s, short s2) {
        this.SetPort();
        rect.Erase(s, s2);
    }

    public void Invert(Rect rect, short s, short s2) {
        this.SetPort();
        rect.Invert(s, s2);
    }

    public void Frame(Arc arc, short s, short s2) {
        this.SetPort();
        arc.Frame(s, s2);
    }

    public void Paint(Arc arc, short s, short s2) {
        this.SetPort();
        arc.Paint(s, s2);
    }

    public void Fill(Arc arc, short s, short s2, Pattern pattern) {
        this.SetPort();
        arc.Fill(s, s2, pattern);
    }

    public void Erase(Arc arc, short s, short s2) {
        this.SetPort();
        arc.Erase(s, s2);
    }

    public void Invert(Arc arc, short s, short s2) {
        this.SetPort();
        arc.Invert(s, s2);
    }

    public void SetFont(QuickdrawFont quickdrawFont) {
        if (quickdrawFont != null) {
            this.SetPort();
            quickdrawFont.install();
        }
    }

    public void SetForeColor(RGBColor rGBColor) {
        this.SetPort();
        rGBColor.SetForeColor();
    }

    public void SetBackColor(RGBColor rGBColor) {
        this.SetPort();
        rGBColor.SetBackColor();
    }

    public RGBColor GetForeColor() {
        this.SetPort();
        return RGBColor.getForeColor();
    }

    public RGBColor GetBackColor() {
        this.SetPort();
        return RGBColor.getBackColor();
    }

    private Region GetClip() {
        if (this.clipRgn == null) {
            HandleObject handleObject = new HandleObject();
            handleObject.setHandle(super.getIntAt(28));
            this.clipRgn = new Region(handleObject);
        }
        return this.clipRgn;
    }

    private static native void GetPort(GrafPtr var0);

    private static native void SetPort(int var0);

    private static native void ClipRect(Rect var0);
}

