/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.MacOSError;
import com.apple.MacOS.MacOSLibraries;
import com.apple.NativeObject;
import com.apple.memory.PInt;

public class FileRef
implements NativeObject {
    short refNum;
    private static String[] kNativeLibraryNames = MacOSLibraries.kInterfaceLibNames;

    public int Read(int n, byte[] byArray) {
        PInt pInt = new PInt(n);
        MacOSError.CheckResult(FileRef.FSRead(this.refNum, pInt, byArray));
        return pInt.getValue();
    }

    public int Write(int n, byte[] byArray) {
        PInt pInt = new PInt(n);
        MacOSError.CheckResult(FileRef.FSWrite(this.refNum, pInt, byArray));
        return pInt.getValue();
    }

    public void Close() {
        MacOSError.CheckResult(FileRef.FSClose(this.refNum));
    }

    public int GetFPos() {
        PInt pInt = new PInt();
        MacOSError.CheckResult(FileRef.GetFPos(this.refNum, pInt));
        return pInt.getValue();
    }

    public void SetFPos(short s, int n) {
        MacOSError.CheckResult(FileRef.SetFPos(this.refNum, s, n));
    }

    public int GetEOF() {
        PInt pInt = new PInt();
        MacOSError.CheckResult(FileRef.GetEOF(this.refNum, pInt));
        return pInt.getValue();
    }

    public void SetEOF(int n) {
        MacOSError.CheckResult(FileRef.SetEOF(this.refNum, n));
    }

    public int Allocate(int n) {
        PInt pInt = new PInt(n);
        MacOSError.CheckResult(FileRef.Allocate(this.refNum, pInt));
        return pInt.getValue();
    }

    public int AllocContig(int n) {
        PInt pInt = new PInt(n);
        MacOSError.CheckResult(FileRef.AllocContig(this.refNum, pInt));
        return pInt.getValue();
    }

    private static native short FSClose(short var0);

    private static native short FSRead(short var0, PInt var1, byte[] var2);

    private static native short FSWrite(short var0, PInt var1, byte[] var2);

    private static native short GetEOF(short var0, PInt var1);

    private static native short SetEOF(short var0, int var1);

    private static native short GetFPos(short var0, PInt var1);

    private static native short SetFPos(short var0, short var1, int var2);

    private static native short Allocate(short var0, PInt var1);

    private static native short AllocContig(short var0, PInt var1);
}

