/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.FSSpec;
import com.apple.MacOS.MacOSLibraries;
import com.apple.MacOS.OSUtils;
import com.apple.MacOS.ResourceManager;
import com.apple.NativeObject;
import java.io.File;
import java.io.IOException;

public class DataForkFile
implements NativeObject,
ResourceManager {
    private boolean itsOpenedExplicitly;
    private boolean itsReadOnly;
    private short itsRefNum = (short)-1;
    private String itsPath;
    private static String[] kNativeLibraryNames = MacOSLibraries.kInterfaceLibNames;

    public DataForkFile(boolean bl) {
        this.itsOpenedExplicitly = false;
        this.itsReadOnly = bl;
    }

    public DataForkFile(short s, boolean bl) {
        this.itsOpenedExplicitly = false;
        this.itsReadOnly = bl;
        this.itsRefNum = s;
    }

    public DataForkFile() {
        this(false);
    }

    public DataForkFile(String string, boolean bl) {
        this.itsReadOnly = bl;
        this.itsPath = string;
    }

    public DataForkFile(File file, boolean bl) {
        this(file.getPath(), bl);
    }

    public void openFile() throws IOException {
        FSSpec fSSpec = null;
        fSSpec = new FSSpec(this.itsPath);
        short[] sArray = new short[1];
        short s = DataForkFile.FSpOpenDF(fSSpec.getBytes(), (byte)(this.itsReadOnly ? 1 : 3), sArray);
        if (s == 0 && sArray[0] != 0) {
            this.itsRefNum = sArray[0];
        } else {
            if (!this.itsReadOnly) {
                this.itsRefNum = this.createAsNewFile(fSSpec, OSUtils.makeOSType("ttxt"), OSUtils.makeOSType("TEXT"));
            }
            if (this.itsRefNum == -1) {
                throw new IOException("Can't open file: " + this.itsPath);
            }
        }
        this.itsOpenedExplicitly = true;
    }

    public boolean isReadOnly() {
        return this.itsReadOnly;
    }

    public void close() {
        if (this.itsRefNum != -1) {
            DataForkFile.FSClose(this.itsRefNum);
        }
        this.itsRefNum = (short)-1;
    }

    protected short createAsNewFile(FSSpec fSSpec, int n, int n2) throws IOException {
        short s = DataForkFile.FSpCreate(fSSpec.getBytes(), n, n2, 0);
        if (s != 0) {
            throw new IOException("Can't create file: " + fSSpec + " (" + s + ")");
        }
        short[] sArray = new short[1];
        s = DataForkFile.FSpOpenDF(fSSpec.getBytes(), (byte)(this.itsReadOnly ? 1 : 3), sArray);
        if (s != 0 || sArray[0] == -1) {
            DataForkFile.FSpDelete(fSSpec.getBytes());
        }
        return sArray[0];
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public short getRefNum() {
        return this.itsRefNum;
    }

    private static native short FSpOpenDF(byte[] var0, byte var1, short[] var2);

    private static native short FSpCreate(byte[] var0, int var1, int var2, int var3);

    private static native short FSpDelete(byte[] var0);

    private static native void FSClose(short var0);
}

