/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.AEDesc;
import com.apple.MacOS.AERecord;
import com.apple.MacOS.AETarget;
import com.apple.MacOS.MacOSError;
import com.apple.MacOS.OSUtils;
import com.apple.MacOS.ae;
import com.apple.memory.MemoryObject;
import com.apple.memory.PointerObject;

public class AppleEvent
extends AERecord {
    public static final int kAENoReply = 1;
    public static final int kAEQueueReply = 2;
    public static final int kAEWaitReply = 3;
    public static final int kAENeverInteract = 16;
    public static final int kAECanInteract = 32;
    public static final int kAEAlwaysInteract = 48;
    public static final int kAECanSwitchLayer = 64;
    public static final int kAEDontReconnect = 128;
    public static final int kAEWantReceipt = 512;
    public static final int kAEDontRecord = 4096;
    public static final int kAEDontExecute = 8192;
    public static final int kAENormalPriority = 0;
    public static final int kAEHighPriority = 1;
    public static final int kAutoGenerateReturnID = -1;
    public static final int kAnyTransactionID = 0;
    public static final int kAEDefaultTimeout = -1;
    public static final int kNoTimeOut = -2;
    public static final int kAEInteractWithSelf = 0;
    public static final int kAEInteractWithLocal = 1;
    public static final int kAEInteractWithAll = 2;
    public static final int kAEUnknownSource = 0;
    public static final int kAEDirectCall = 1;
    public static final int kAESameProcess = 2;
    public static final int kAELocalProcess = 3;
    public static final int kAERemoteProcess = 4;
    private boolean itsSuspended;
    private PointerObject itsReplyPtrForResume;

    private AppleEvent() {
        super(true);
    }

    protected AppleEvent(MemoryObject memoryObject) {
        super(memoryObject);
    }

    public AppleEvent(AppleEvent appleEvent) {
        super(appleEvent);
    }

    public AppleEvent(int n, int n2, AETarget aETarget) {
        this(n, n2, aETarget, -1, 0);
    }

    public AppleEvent(int n, int n2, AETarget aETarget, int n3, int n4) {
        super(true);
        MacOSError.CheckResult(AppleEvent.AECreateAppleEvent(n, n2, aETarget, (short)n3, n4, this));
    }

    public void putKeyDesc(AEDesc aEDesc) {
        this.putParam(ae.keyDirectObject, aEDesc);
    }

    public AEDesc getKeyDesc() {
        return this.getParam(ae.keyDirectObject);
    }

    public AppleEvent send() {
        AppleEvent appleEvent = new AppleEvent();
        int n = 4131;
        MacOSError.CheckResult(AppleEvent.AESend(this, appleEvent, n, (short)0, -1, 0, 0));
        return appleEvent;
    }

    public void sendNoReply() {
        AppleEvent appleEvent = new AppleEvent();
        int n = 1;
        MacOSError.CheckResult(AppleEvent.AESend(this, appleEvent, n, (short)0, -1, 0, 0));
    }

    public void getAttribute(int n, int n2, AEDesc aEDesc) {
        MacOSError.CheckResult(AppleEvent.AEGetAttributeDesc(this, n, n2, aEDesc));
    }

    public void getAttribute(int n, AEDesc aEDesc) {
        this.getAttribute(n, ae.typeWildCard, aEDesc);
    }

    public AEDesc getAttribute(int n) {
        AEDesc aEDesc = new AEDesc();
        this.getAttribute(n, aEDesc);
        return aEDesc;
    }

    public AETarget getSource() {
        AETarget aETarget = new AETarget();
        this.getAttribute(ae.keyEventSourceAttr, aETarget);
        return aETarget;
    }

    public AETarget getTarget() {
        AETarget aETarget = new AETarget();
        this.getAttribute(ae.keyAddressAttr, aETarget);
        return aETarget;
    }

    private int getIntAttribute(int n, int n2) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        if (AppleEvent.AEGetAttributePtr(this, n, ae.typeInteger, nArray, nArray2, 4, nArray3) != 0) {
            return 0;
        }
        return nArray2[0];
    }

    public int getEventClass() {
        return this.getIntAttribute(ae.keyEventClassAttr, ae.typeType);
    }

    public int getEventID() {
        return this.getIntAttribute(ae.keyEventIDAttr, ae.typeType);
    }

    public int getReturnID() {
        return this.getIntAttribute(ae.keyReturnIDAttr, ae.typeLongInteger);
    }

    public int getTransactionID() {
        return this.getIntAttribute(ae.keyTransactionIDAttr, ae.typeLongInteger);
    }

    public void getParameter(int n, int n2, AEDesc aEDesc) {
        MacOSError.CheckResult(AppleEvent.AEGetParamDesc(this, n, n2, aEDesc));
    }

    public void getParameter(int n, AEDesc aEDesc) {
        this.getParameter(n, ae.typeWildCard, aEDesc);
    }

    public AEDesc getParameter(int n, int n2) {
        AEDesc aEDesc = new AEDesc();
        this.getParameter(n, n2, aEDesc);
        return aEDesc;
    }

    public AEDesc getParameter(int n) {
        return this.getParameter(n, ae.typeWildCard);
    }

    public void putParameter(int n, AEDesc aEDesc) {
        AppleEvent.AEPutParamDesc(this, n, aEDesc);
    }

    public void putParameter(int n, int n2, byte[] byArray) {
        AppleEvent.AEPutParamPtr(this, n, n2, byArray, byArray.length);
    }

    public String toString() {
        return "AppleEvent[" + this.getTarget() + ", " + this.getSource() + ", " + OSUtils.osTypeToString(this.getEventClass()) + ", " + OSUtils.osTypeToString(this.getEventID()) + ", " + this.getReturnID() + ", " + this.getTransactionID() + ", " + super.toString() + "]";
    }

    public synchronized void suspendEvent() {
        AppleEvent.AESuspendTheCurrentEvent(this);
        this.itsSuspended = true;
    }

    public synchronized void resumeEvent(AppleEvent appleEvent) {
        AppleEvent.AEResumeTheCurrentEvent(this, appleEvent, 0, 0);
        appleEvent.Relinquish(this.itsReplyPtrForResume);
        this.itsSuspended = false;
    }

    public boolean isSuspended() {
        return this.itsSuspended;
    }

    void setReplyPtrForResume(PointerObject pointerObject) {
        this.itsReplyPtrForResume = pointerObject;
    }

    private static native short AECreateAppleEvent(int var0, int var1, AETarget var2, short var3, int var4, AppleEvent var5);

    private static native short AESend(AppleEvent var0, AppleEvent var1, int var2, short var3, int var4, int var5, int var6);

    private static native short AESizeOfAttribute(AppleEvent var0, int var1, int[] var2, int[] var3);

    private static native short AEGetAttributePtr(AppleEvent var0, int var1, int var2, int[] var3, int[] var4, int var5, int[] var6);

    private static native short AEGetAttributeDesc(AppleEvent var0, int var1, int var2, AEDesc var3);

    private static native short AEPutAttributePtr(AppleEvent var0, int var1, int var2, Object var3, int var4);

    private static native short AEPutAttributeDesc(AppleEvent var0, int var1, AEDesc var2);

    private static native short AEGetParamPtr(AppleEvent var0, int var1, int var2, int[] var3, int[] var4, int var5, int[] var6);

    private static native short AEGetParamDesc(AppleEvent var0, int var1, int var2, AEDesc var3);

    private static native int AEPutParamPtr(AppleEvent var0, int var1, int var2, byte[] var3, int var4);

    private static native int AEPutParamDesc(AppleEvent var0, int var1, AEDesc var2);

    private static native short AESuspendTheCurrentEvent(AppleEvent var0);

    private static native short AEResumeTheCurrentEvent(AppleEvent var0, AppleEvent var1, int var2, int var3);
}

