/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.xslf;

import java.awt.Dimension;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFPictureData;
import org.apache.poi.xslf.usermodel.XSLFPictureShape;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.poi.xslf.usermodel.XSLFTextShape;

public final class DataExtraction {
    private DataExtraction() {
    }

    public static void main(String[] args) throws IOException {
        PrintStream out = System.out;
        if (args.length == 0) {
            out.println("Input file is required");
            return;
        }
        FileInputStream is = new FileInputStream(args[0]);
        try (XMLSlideShow ppt = new XMLSlideShow(is);){
            InputStream pIs;
            String name;
            String type;
            is.close();
            for (PackagePart p : ppt.getAllEmbeddedParts()) {
                type = p.getContentType();
                name = p.getPartName().getName();
                out.println("Embedded file (" + type + "): " + name);
                pIs = p.getInputStream();
                pIs.close();
            }
            for (XSLFPictureData data : ppt.getPictureData()) {
                type = data.getContentType();
                name = data.getFileName();
                out.println("Picture (" + type + "): " + name);
                pIs = data.getInputStream();
                pIs.close();
            }
            Dimension pageSize = ppt.getPageSize();
            out.println("Pagesize: " + pageSize);
            for (XSLFSlide slide : ppt.getSlides()) {
                for (XSLFShape shape : slide) {
                    if (shape instanceof XSLFTextShape) {
                        XSLFTextShape txShape = (XSLFTextShape)shape;
                        out.println(txShape.getText());
                        continue;
                    }
                    if (shape instanceof XSLFPictureShape) {
                        XSLFPictureShape pShape = (XSLFPictureShape)shape;
                        XSLFPictureData pData = pShape.getPictureData();
                        out.println(pData.getFileName());
                        continue;
                    }
                    out.println("Process me: " + shape.getClass());
                }
            }
        }
    }
}

