/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.hslf;

import java.io.FileInputStream;
import java.util.Collection;
import java.util.Locale;
import org.apache.poi.hslf.usermodel.HSLFHyperlink;
import org.apache.poi.hslf.usermodel.HSLFSimpleShape;
import org.apache.poi.hslf.usermodel.HSLFSlide;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.hslf.usermodel.HSLFTextRun;

public final class Hyperlinks {
    private Hyperlinks() {
    }

    public static void main(String[] args) throws Exception {
        for (String arg : args) {
            try (FileInputStream is = new FileInputStream(arg);
                 HSLFSlideShow ppt = new HSLFSlideShow(is);){
                for (HSLFSlide slide : ppt.getSlides()) {
                    System.out.println("\nslide " + slide.getSlideNumber());
                    System.out.println("- reading hyperlinks from the text runs");
                    slide.getTextParagraphs().stream().flatMap(Collection::stream).map(HSLFTextParagraph::getTextRuns).flatMap(Collection::stream).forEach(run -> Hyperlinks.out(run.getHyperlink(), run));
                    System.out.println("- reading hyperlinks from the slide's shapes");
                    slide.getShapes().stream().filter(sh -> sh instanceof HSLFSimpleShape).forEach(sh -> Hyperlinks.out(((HSLFSimpleShape)sh).getHyperlink(), null));
                }
            }
        }
    }

    private static void out(HSLFHyperlink link, HSLFTextRun run) {
        if (link == null) {
            return;
        }
        String rawText = run == null ? null : run.getRawText();
        String formatStr = "title: %1$s, address: %2$s" + (rawText == null ? "" : ", start: %3$s, end: %4$s, substring: %5$s");
        String line = String.format(Locale.ROOT, formatStr, link.getLabel(), link.getAddress(), link.getStartIndex(), link.getEndIndex(), rawText);
        System.out.println(line);
    }
}

