/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.search.lucene;

import coldfusion.orm.search.ORMSearchException;
import coldfusion.util.RB;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleSpanFragmenter;

public class HighlighterUtil {
    public static final String MAX_CHAR_FOR_CONTEXT = "maxCharForContext";
    public static final String MAX_NUM_OF_FRAGMENTS = "maxBestMatch";
    public static final String CONTEXT_MARKUP_BEGIN = "contextHighlightBegin";
    public static final String CONTEXT_MARKUP_END = "contextHighlightEnd";

    public String[] getFragmentsWithHighlightedTerms(Analyzer analyzer, Query query, String fieldName, String fieldContents, int fragmentNumber, int fragmentSize) throws IOException {
        TokenStream stream = analyzer.tokenStream(fieldName, fieldContents);
        QueryScorer scorer = new QueryScorer(query, fieldName);
        SimpleSpanFragmenter fragmenter = new SimpleSpanFragmenter(scorer, fragmentSize);
        Highlighter highlighter = new Highlighter((Scorer)scorer);
        highlighter.setTextFragmenter((Fragmenter)fragmenter);
        highlighter.setMaxDocCharsToAnalyze(Integer.MAX_VALUE);
        String[] fragments = new String[]{};
        try {
            fragments = highlighter.getBestFragments(stream, fieldContents, fragmentNumber);
        }
        catch (InvalidTokenOffsetsException e) {
            throw new ORMSearchException(RB.getString((Object)this, (String)"HighLighterFailed"), e);
        }
        return fragments;
    }
}

