/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.search.lucene;

import coldfusion.util.RB;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class FSDirectoryProvider {
    private FSDirectory directory;

    public FSDirectory initialize(File baseIndexDir, String indexName) {
        File indexDir = this.createAndVerifyDir(baseIndexDir, indexName);
        try {
            this.directory = this.createFSIndex(indexDir);
        }
        catch (IOException e) {
            throw new IndexDirectoryCreateException(RB.getString((Object)this, (String)"FSDirectoryInitializationFailed"), e);
        }
        return this.directory;
    }

    public void destroy() throws IOException {
        this.directory.close();
    }

    public FSDirectory getDirectory() {
        return this.directory;
    }

    private FSDirectory createFSIndex(File indexDir) throws IOException {
        Path indexPath = FileSystems.getDefault().getPath(indexDir.getAbsolutePath(), new String[0]);
        FSDirectory fsDirectory = FSDirectory.open((Path)indexPath);
        if (!DirectoryReader.indexExists((Directory)fsDirectory)) {
            IndexWriter iw = new IndexWriter((Directory)fsDirectory, new IndexWriterConfig((Analyzer)new SimpleAnalyzer()));
            iw.close();
        }
        return fsDirectory;
    }

    private File createAndVerifyDir(File baseIndexDir, String indexName) {
        this.verifyDir(baseIndexDir);
        File indexDir = new File(baseIndexDir, indexName);
        this.verifyDir(indexDir);
        return indexDir;
    }

    private void verifyDir(File directory) {
        if (!directory.exists()) {
            if (!directory.mkdirs()) {
                throw new IndexDirectoryCreateException(RB.getString((Object)this, (String)"indexDirCreationFailed", (Object)directory.getAbsolutePath()));
            }
        } else if (!directory.isDirectory()) {
            throw new IndexDirectoryCreateException(RB.getString((Object)this, (String)"IndexPathNotADirectory", (Object)directory.getAbsolutePath()));
        }
        if (!directory.canWrite()) {
            throw new IndexDirectoryCreateException(RB.getString((Object)this, (String)"indexDirNotwritable", (Object)directory.getAbsolutePath()));
        }
    }

    public static class IndexDirectoryCreateException
    extends RuntimeException {
        public IndexDirectoryCreateException(String message) {
            super(message);
        }

        public IndexDirectoryCreateException(String message, Exception e) {
            super(message, e);
        }
    }
}

