/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.vfs.s3;

import coldfusion.vfs.s3.S3FileName;
import coldfusion.vfs.s3.S3FileObject;
import coldfusion.vfs.s3.S3FileProvider;
import coldfusion.vfs.s3.S3FileSystemConfigBuilder;
import java.util.Collection;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.StorageOwner;

public class S3FileSystem
extends AbstractFileSystem {
    private S3Service s3Service;
    private S3Bucket bucket;
    private String bucketName;
    private FileObject root;
    private StorageOwner owner;

    public S3FileSystem(S3Service s3Service, S3FileName rootFileName, S3Bucket bucket, FileSystemOptions fileSystemOptions) {
        super((FileName)rootFileName, null, fileSystemOptions);
        this.bucketName = rootFileName.getBucket();
        this.s3Service = s3Service;
        this.bucket = bucket;
    }

    S3Service getS3Service() {
        return this.s3Service;
    }

    synchronized S3Bucket getBucket() {
        return this.bucket;
    }

    synchronized void setBucket(S3Bucket bucket) {
        this.bucket = bucket;
    }

    String getBucketName() {
        return this.bucketName;
    }

    public S3Bucket createBucket(String location, AccessControlList acl) throws Exception {
        S3Bucket s3Bucket = new S3Bucket(this.bucketName);
        s3Bucket.setAcl(acl);
        if (location == null) {
            location = S3FileSystemConfigBuilder.getInstance().getDefaultLocation(this.getFileSystemOptions());
        }
        s3Bucket.setLocation(location);
        this.s3Service.createBucket(s3Bucket);
        this.refreshBucket();
        return this.bucket;
    }

    protected FileObject createFile(AbstractFileName name) throws Exception {
        if (this.bucket == null) {
            this.refreshBucket();
        }
        return new S3FileObject(name, this, (S3FileName)this.getRootName());
    }

    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(S3FileProvider.capabilities);
    }

    public StorageOwner getAccountOwner() throws ServiceException {
        if (this.owner == null) {
            this.owner = this.s3Service.getAccountOwner();
        }
        return this.owner;
    }

    protected void refreshBucket() throws Exception {
        try {
            this.bucket = this.s3Service.getBucket(this.bucketName);
            if (this.bucket != null && !this.bucket.isLocationKnown()) {
                this.bucket.setLocation(this.s3Service.getBucketLocation(this.bucketName));
            }
            if (this.bucket == null && this.s3Service.isBucketAccessible(this.bucketName)) {
                this.bucket = new S3Bucket(this.bucketName);
            }
        }
        catch (S3ServiceException s3ServiceException) {
            // empty catch block
        }
    }
}

