/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.azure.blob.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import com.microsoft.azure.storage.blob.BlobProperties;
import java.util.Collections;

public class BlobPropertiesConsumer
extends ConsumerMap<BlobProperties> {
    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private final String CACHE_CONTROL = "cachecontrol";
    private final String CONTENT_DISPOSITION = "contentdisposition";
    private final String CONTENT_ENCODING = "contentencoding";
    private final String CONTENT_LANGUAGE = "contentlanguage";
    private final String CONTENT_MD5 = "contentmd5";
    private final String CONTENT_TYPE = "contenttype";

    public BlobPropertiesConsumer() {
        this.put("cachecontrol", new ConsumerValidator((blobProperties, value) -> {
            blobProperties.setCacheControl(this.cast.getStringProperty(value));
            ValidationUtil.validNonBlankString((String)blobProperties.getCacheControl(), (String)"cachecontrol");
        }, Collections.emptyList()));
        this.put("contentdisposition", new ConsumerValidator((blobProperties, value) -> {
            blobProperties.setContentDisposition(this.cast.getStringProperty(value));
            ValidationUtil.validNonBlankString((String)blobProperties.getContentDisposition(), (String)"contentdisposition");
        }, Collections.emptyList()));
        this.put("contentencoding", new ConsumerValidator((blobProperties, value) -> {
            blobProperties.setContentEncoding(this.cast.getStringProperty(value));
            ValidationUtil.validNonBlankString((String)blobProperties.getContentEncoding(), (String)"contentencoding");
        }, Collections.emptyList()));
        this.put("contentlanguage", new ConsumerValidator((blobProperties, value) -> {
            blobProperties.setContentLanguage(this.cast.getStringProperty(value));
            ValidationUtil.validNonBlankString((String)blobProperties.getContentLanguage(), (String)"contentlanguage");
        }, Collections.emptyList()));
        this.put("contentmd5", new ConsumerValidator((blobProperties, value) -> {
            blobProperties.setContentMD5(this.cast.getStringProperty(value));
            ValidationUtil.validNonBlankString((String)blobProperties.getContentMD5(), (String)"contentmd5");
        }, Collections.emptyList()));
        this.put("contenttype", new ConsumerValidator((blobProperties, value) -> {
            blobProperties.setContentType(this.cast.getStringProperty(value));
            ValidationUtil.validNonBlankString((String)blobProperties.getContentType(), (String)"contenttype");
        }, Collections.emptyList()));
    }
}

