/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.azure.blob;

import coldfusion.azure.blob.BlobUtil;
import coldfusion.azure.blob.consumer.AccessConditionRequestConsumer;
import coldfusion.azure.blob.consumer.AcquireLeaseRequestConsumer;
import coldfusion.azure.blob.consumer.AzureBlobContainerPermissionsConsumer;
import coldfusion.azure.blob.consumer.BlobCopyRequestConsumer;
import coldfusion.azure.blob.consumer.BlobDeleteRequestConsumer;
import coldfusion.azure.blob.consumer.BlobDownloadRequestConsumer;
import coldfusion.azure.blob.consumer.BlobLeaseRequestConsumer;
import coldfusion.azure.blob.consumer.BlobListRequestConsumer;
import coldfusion.azure.blob.consumer.BlobSnapshotRequestConsumer;
import coldfusion.azure.blob.consumer.BlockUploadRequestConsumer;
import coldfusion.azure.blob.consumer.ChangeLeaseRequestConsumer;
import coldfusion.azure.blob.consumer.CommitBlockListRequestConsumer;
import coldfusion.azure.blob.consumer.CreatePartFileRequestConsumer;
import coldfusion.azure.blob.consumer.DownloadObjectBlobRequestConsumer;
import coldfusion.azure.blob.consumer.GenerateBlobSasRequestConsumer;
import coldfusion.azure.blob.consumer.UploadDirectoryRequestConsumer;
import coldfusion.azure.blob.consumer.UploadFileBlobRequestConsumer;
import coldfusion.azure.blob.consumer.UploadMetadataRequestConsumer;
import coldfusion.azure.blob.consumer.UploadObjectBlobRequestConsumer;
import coldfusion.azure.blob.exception.AzureBlobApiException;
import coldfusion.azure.blob.request.AbstractAzureBlobRequest;
import coldfusion.azure.blob.request.AccessConditionRequest;
import coldfusion.azure.blob.request.AcquireLeaseRequest;
import coldfusion.azure.blob.request.AzureBlobContainerPermissions;
import coldfusion.azure.blob.request.BlobCopyRequest;
import coldfusion.azure.blob.request.BlobDeleteRequest;
import coldfusion.azure.blob.request.BlobDownloadRequest;
import coldfusion.azure.blob.request.BlobListRequest;
import coldfusion.azure.blob.request.BlobSnapshotRequest;
import coldfusion.azure.blob.request.BlockUploadRequest;
import coldfusion.azure.blob.request.BreakLeaseRequest;
import coldfusion.azure.blob.request.ChangeLeaseRequest;
import coldfusion.azure.blob.request.CommitBlockList;
import coldfusion.azure.blob.request.CreatePartFileRequest;
import coldfusion.azure.blob.request.DownloadObjectBlobRequest;
import coldfusion.azure.blob.request.GenerateSasRequest;
import coldfusion.azure.blob.request.UploadDirectoryRequest;
import coldfusion.azure.blob.request.UploadFileBlobRequest;
import coldfusion.azure.blob.request.UploadMetadataRequest;
import coldfusion.azure.blob.request.UploadObjectBlobRequest;
import coldfusion.cloud.CloudServiceName;
import coldfusion.cloud.exception.ValidationException;
import coldfusion.cloud.util.CloudDeserializationUtil;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.SerializationUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.monitor.event.RequestMonitorEventProcessor;
import coldfusion.monitor.util.CloudMonitoringUtil;
import coldfusion.runtime.ArgumentCollection;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.GenerateCFNamedInvoke;
import coldfusion.runtime.InvokeNamedMethodInvocationMap;
import coldfusion.runtime.JSONUtils;
import coldfusion.runtime.NamedInvokable;
import coldfusion.runtime.NamedMethodInvoker;
import coldfusion.runtime.Struct;
import coldfusion.util.RB;
import coldfusion.vfs.VFSFileFactory;
import coldfusion.vfs.VFile;
import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobContainerPermissions;
import com.microsoft.azure.storage.blob.BlobProperties;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.microsoft.azure.storage.blob.CopyStatus;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.jsp.PageContext;

@GenerateCFNamedInvoke
public class ContainerReference
implements NamedInvokable {
    private final CloudBlobClient client;
    private CloudBlobContainer container;
    private OperationContext context;
    private ValidatorFiller filler = ValidatorFiller.INSTANCE;
    private final Logger logger = CFLogs.SERVER_LOG;
    private static ExecutorService executorService = Executors.newFixedThreadPool(5);
    private TagAttributeList tagAttributeList = new TagAttributeList("service", (Object)CloudServiceName.AZURE_BLOB.name());
    private static InvokeNamedMethodInvocationMap<ContainerReference> __InvokeNamedMethodInvocationMap = new InvokeNamedMethodInvocationMap();

    public ContainerReference(CloudBlobContainer container, CloudBlobClient client, OperationContext context) {
        this.logger.debug((Object)("new container reference created for container: " + container.getName()));
        this.container = container;
        this.client = client;
        this.context = context;
        this.tagAttributeList.addTagAttribute("container", (Object)container.getName());
    }

    public Struct listAll() {
        return this.listAll(null);
    }

    public Struct listAll(Map listRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"listAll", (boolean)true);
        BlobListRequest request = new BlobListRequest();
        request.setUseFlatBlobListing(true);
        String statusCode = "Success";
        try {
            this.filler.fillObject((Object)request, listRequest, (ConsumerMap)new BlobListRequestConsumer());
            LinkedList structs = new LinkedList();
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling azure-blob in listAll, request : " + request.toString()));
            Iterable iterable = this.container.listBlobs(request.getPrefix(), request.isUseFlatBlobListing(), request.getListingDetails(), request.getOptions(), this.getOperationContext(request));
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to azure-blob inlistAll is completed in  " + (endTime - startTime) + " ms"));
            iterable.forEach(blob -> {
                if (blob instanceof CloudBlob) {
                    CloudBlob cloudBlob = (CloudBlob)blob;
                    Struct blobStruct = new Struct();
                    blobStruct.put((Object)"blobName", (Object)cloudBlob.getName());
                    blobStruct.put((Object)"metadata", (Object)cloudBlob.getMetadata());
                    blobStruct.put((Object)"properties", (Object)CloudDeserializationUtil.INSTANCE.beanToStruct((Object)cloudBlob.getProperties()));
                    if (cloudBlob.isSnapshot()) {
                        blobStruct.put((Object)"snapshotID", (Object)cloudBlob.getSnapshotID());
                    }
                    structs.add(blobStruct);
                }
            });
            Struct response = new Struct();
            response.put((Object)"response", structs);
            Struct struct = response;
            return struct;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in listAll : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"listAllError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"listAll", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct putPolicy(Map policyRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"putPolicy", (boolean)true);
        String statusCode = "Success";
        RequestMonitorEventProcessor.onFunctionStart((String)"putPolicy", (boolean)true);
        AzureBlobContainerPermissions request = new AzureBlobContainerPermissions();
        AzureBlobContainerPermissionsConsumer containerPermissionsConsumer = AzureBlobContainerPermissionsConsumer.getInstance();
        try {
            this.filler.fillObject((Object)request, policyRequest, (ConsumerMap)containerPermissionsConsumer);
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling azure-blob in putPolicy, request : " + request.toString()));
            this.container.uploadPermissions(request.getPermissions(), request.getAccessCondition(), request.getOptions(), this.getOperationContext(request));
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to azure-blob inputPolicy is completed in  " + (endTime - startTime) + " ms"));
            Struct response = new Struct();
            response.put((Object)"status", (Object)"success");
            Struct struct = response;
            return struct;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in putPolicy : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"putPolicyError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"putPolicy", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct getPolicies() {
        return this.getPolicies(null);
    }

    public Struct getPolicies(Map getPolicyRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"getPolicies", (boolean)true);
        String statusCode = "Success";
        AccessConditionRequest request = new AccessConditionRequest();
        try {
            this.filler.fillObject((Object)request, getPolicyRequest, (ConsumerMap)new AccessConditionRequestConsumer());
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling azure-blob in getPolicies, request : " + request.toString()));
            BlobContainerPermissions permissions = this.container.downloadPermissions(request.getAccessCondition(), request.getOptions(), this.getOperationContext(request));
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to azure-blob ingetPolicies is completed in  " + (endTime - startTime) + " ms"));
            Struct response = new Struct();
            response.put((Object)"status", (Object)"success");
            response.putAll((Map)AzureBlobContainerPermissionsConsumer.getInstance().getAzureBlobContainerPermissionsStruct(permissions));
            Struct struct = response;
            return struct;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in getPolicies : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"getPoliciesError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"getPolicies", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct deletePolicies() {
        RequestMonitorEventProcessor.onFunctionStart((String)"deletePolicies", (boolean)true);
        String statusCode = "Success";
        BlobContainerPermissions permissions = null;
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)"Calling azure-blob in deletePolicies");
            permissions = this.container.downloadPermissions();
            permissions.setSharedAccessPolicies(new HashMap());
            this.container.uploadPermissions(permissions);
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to azure-blob indeletePolicies is completed in  " + (endTime - startTime) + " ms"));
            Struct response = new Struct();
            response.put((Object)"status", (Object)"success");
            Struct struct = response;
            return struct;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in deletePolicies : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"deletePoliciesError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"deletePolicies", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct uploadFile(Map uploadRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"uploadFile", (boolean)true);
        String statusCode = "Success";
        UploadFileBlobRequest request = new UploadFileBlobRequest();
        try {
            this.filler.fillObject((Object)request, uploadRequest, (ConsumerMap)UploadFileBlobRequestConsumer.getInstance());
            Struct struct = this.uploadFile(request);
            return struct;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in uploadFile: ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"uploadFileError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"uploadFile", null, (Object)statusCode, null, (String)request.getKey(), (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct uploadObject(Map uploadRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"uploadObject", (boolean)true);
        String statusCode = "Success";
        UploadObjectBlobRequest request = new UploadObjectBlobRequest();
        try {
            this.filler.fillObject((Object)request, uploadRequest, (ConsumerMap)UploadObjectBlobRequestConsumer.getInstance());
            Struct structResponse = new Struct();
            CloudBlockBlob blockBlob = this.container.getBlockBlobReference(request.getKey());
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling azure-blob in uploadObject, request : " + request.toString()));
            String serializedString = SerializationUtil.Serialize((Object)request.getInputObject(), (String)request.getType(), (boolean)request.isUseCustomSerializer());
            blockBlob.upload((InputStream)new ByteArrayInputStream(serializedString.getBytes()), (long)serializedString.length(), request.getAccessCondition(), request.getOptions(), this.getOperationContext(request));
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to azure-blob inuploadObject is completed in  " + (endTime - startTime) + " ms"));
            structResponse.put((Object)"blobName", (Object)request.getKey());
            structResponse.put((Object)"status", (Object)"success");
            structResponse.put((Object)"statusCode", (Object)statusCode);
            Struct struct = structResponse;
            return struct;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in uploadObject : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"uploadObjectError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"uploadObject", null, (Object)statusCode, null, (String)request.getKey(), (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct downloadObject(Map downloadRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"downloadObject", (boolean)true);
        String statusCode = "Success";
        DownloadObjectBlobRequest request = new DownloadObjectBlobRequest();
        try {
            this.filler.fillObject((Object)request, downloadRequest, (ConsumerMap)DownloadObjectBlobRequestConsumer.getInstance());
            Struct structResponse = new Struct();
            CloudBlockBlob blockBlob = this.container.getBlockBlobReference(request.getKey());
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling azure-blob in downloadObject, request : " + request.toString()));
            String downloadedText = blockBlob.downloadText(null, request.getAccessCondition(), request.getOptions(), this.getOperationContext(request));
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to azure-blob indownloadObject is completed in  " + (endTime - startTime) + " ms"));
            structResponse.put((Object)"blobName", (Object)request.getKey());
            structResponse.put((Object)"object", SerializationUtil.Deserialize((String)downloadedText, (String)request.getType(), (boolean)request.isUseCustomSerializer()));
            structResponse.put((Object)"status", (Object)"success");
            structResponse.put((Object)"statusCode", (Object)statusCode);
            Struct struct = structResponse;
            return struct;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in downloadObject : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"downloadObjectError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"downloadObject", null, (Object)statusCode, null, (String)request.getKey(), (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct downloadToFile(Map downloadRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"downloadToFile", (boolean)true);
        String statusCode = "Success";
        BlobDownloadRequest request = new BlobDownloadRequest();
        try {
            this.filler.fillObject((Object)request, downloadRequest, (ConsumerMap)new BlobDownloadRequestConsumer());
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling azure-blob in downloadToFile, request : " + request.toString()));
            this.downloadToFile(request.getBlobName(), request.getDestinationFile(), request.getAccessCondition(), request.getOptions(), this.getOperationContext(request));
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to azure-blob indownloadToFile is completed in  " + (endTime - startTime) + " ms"));
            Struct structResponse = new Struct();
            structResponse.put((Object)"status", (Object)"success");
            Struct struct = structResponse;
            return struct;
        }
        catch (StorageException e) {
            this.logger.error((Object)"Error occurred in downloadToFile : ", (Throwable)e);
            statusCode = String.valueOf(e.getHttpStatusCode());
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"downloadToFileError"), e);
        }
        catch (URISyntaxException e) {
            this.logger.error((Object)"Error occurred in downloadToFile : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"downloadToFileError"), e);
        }
        catch (IOException e) {
            this.logger.error((Object)"Error occurred in downloadToFile : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"downloadToFileError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in downloadToFile : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"downloadToFileError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"downloadToFile", null, (Object)statusCode, null, (String)request.getBlobName(), (TagAttributeList)this.tagAttributeList);
        }
    }

    private void downloadToFile(String blobName, String path, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException, URISyntaxException {
        CloudBlockBlob blockBlob = this.container.getBlockBlobReference(blobName);
        BufferedOutputStream outputStream = new BufferedOutputStream(VFSFileFactory.getOutputStream((String)path));
        try {
            blockBlob.download((OutputStream)outputStream, accessCondition, options, opContext);
            ((OutputStream)outputStream).close();
        }
        catch (StorageException | IOException e) {
            try {
                ((OutputStream)outputStream).close();
                File fileToDelete = VFSFileFactory.getFileObject((String)path);
                fileToDelete.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public Struct delete(Object key) {
        if (key instanceof Struct) {
            return this.delete((Map)((Struct)key));
        }
        return this.delete(String.valueOf(key));
    }

    private Struct delete(String blobName) {
        RequestMonitorEventProcessor.onFunctionStart((String)"delete", (boolean)true);
        String statusCode = "Success";
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling azure-blob in delete, blobName : " + blobName));
            CloudBlockBlob blockBlob = this.container.getBlockBlobReference(blobName);
            blockBlob.delete();
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to azure-blob indelete is completed in  " + (endTime - startTime) + " ms"));
            Struct structResponse = new Struct();
            structResponse.put((Object)"status", (Object)"success");
            Struct struct = structResponse;
            return struct;
        }
        catch (StorageException e) {
            this.logger.error((Object)"Error occurred in delete : ", (Throwable)e);
            statusCode = String.valueOf(e.getHttpStatusCode());
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"deleteError"), e);
        }
        catch (URISyntaxException e) {
            this.logger.error((Object)"Error occurred in delete : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"deleteError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in delete : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"deleteError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"delete", null, (Object)statusCode, null, (String)blobName, (TagAttributeList)this.tagAttributeList);
        }
    }

    private Struct delete(Map deleteRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"delete", (boolean)true);
        String statusCode = "Success";
        BlobDeleteRequest request = new BlobDeleteRequest();
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling azure-blob in delete, request : " + request.toString()));
            this.filler.fillObject((Object)request, deleteRequest, (ConsumerMap)new BlobDeleteRequestConsumer());
            CloudBlockBlob blockBlob = this.container.getBlockBlobReference(request.getBlobName());
            blockBlob.delete(request.getDeleteSnapshotsOption(), request.getAccessCondition(), request.getOptions(), this.getOperationContext(request));
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to azure-blob indelete is completed in  " + (endTime - startTime) + " ms"));
            Struct structResponse = new Struct();
            structResponse.put((Object)"status", (Object)"success");
            Struct struct = structResponse;
            return struct;
        }
        catch (StorageException | URISyntaxException e) {
            this.logger.error((Object)"Error occurred in delete : ", e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"deleteError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in delete : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"deleteError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"delete", null, (Object)statusCode, null, (String)request.getBlobName(), (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct copy(Map copyRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"copy", (boolean)true);
        String statusCode = "Success";
        BlobCopyRequest request = new BlobCopyRequest();
        try {
            CopyStatus copyStatus;
            this.filler.fillObject((Object)request, copyRequest, (ConsumerMap)new BlobCopyRequestConsumer());
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling azure-blob in copy, request : " + request.toString()));
            CloudBlobClient sourceClient = this.client;
            if (Objects.nonNull(request.getAzureCredential())) {
                sourceClient = BlobUtil.authenticate(request.getAzureCredential());
            }
            CloudBlobContainer sourceContainer = sourceClient.getContainerReference(request.getSourceContainer());
            CloudBlockBlob sourceBlob = sourceContainer.getBlockBlobReference(request.getSourceBlob(), request.getSnapshotId());
            CloudBlockBlob targetBlob = this.container.getBlockBlobReference(request.getDestinationBlob());
            String copyId = targetBlob.startCopy(sourceBlob, request.getSourceAccessCondition(), request.getAccessCondition(), request.getOptions(), this.getOperationContext(request));
            targetBlob.uploadStandardBlobTier(request.getStorageClass());
            do {
                if ((copyStatus = targetBlob.getCopyState().getStatus()).equals((Object)CopyStatus.SUCCESS) || copyStatus.equals((Object)CopyStatus.PENDING)) continue;
                this.logger.error((Object)("Blob operation failed with status: " + copyStatus.name()));
                break;
            } while (!copyStatus.equals((Object)CopyStatus.SUCCESS));
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to azure-blob incopy is completed in  " + (endTime - startTime) + " ms"));
            Struct structResponse = new Struct();
            structResponse.put((Object)"status", (Object)"success");
            Struct struct = structResponse;
            return struct;
        }
        catch (StorageException | URISyntaxException e) {
            this.logger.error((Object)"Error occurred in copy : ", e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"copyError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in copy : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"copyError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"copy", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct createSnapshot(Map createSnapshotRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"createSnapshot", (boolean)true);
        String statusCode = "Success";
        BlobSnapshotRequest request = new BlobSnapshotRequest();
        try {
            this.filler.fillObject((Object)request, createSnapshotRequest, (ConsumerMap)new BlobSnapshotRequestConsumer());
            CloudBlockBlob blockBlob = null;
            Struct response = new Struct();
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling azure-blob in createSnapshot, request : " + request.toString()));
            blockBlob = this.container.getBlockBlobReference(request.getBlobName());
            CloudBlob blob = blockBlob.createSnapshot(request.getAccessCondition(), request.getOptions(), this.getOperationContext(request));
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to azure-blob increateSnapshot is completed in  " + (endTime - startTime) + " ms"));
            response.put((Object)"status", (Object)"success");
            response.put((Object)"blobName", (Object)blob.getName());
            response.put((Object)"snapshotID", (Object)blob.getSnapshotID());
            Struct metadata = new Struct();
            metadata.putAll((Map)blob.getMetadata());
            response.put((Object)"metadata", (Object)metadata);
            Struct struct = response;
            return struct;
        }
        catch (StorageException e) {
            this.logger.error((Object)"Error occurred in createSnapshot : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"createSnapshotError"), e);
        }
        catch (URISyntaxException e) {
            this.logger.error((Object)"Error occurred in createSnapshot : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"createSnapshotError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in createSnapshot : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"createSnapshotError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"createSnapshot", null, (Object)statusCode, null, (String)request.getBlobName(), (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct generateSas(Map sasRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"generateSas", (boolean)true);
        String statusCode = "Success";
        CloudBlockBlob blockBlob = null;
        GenerateSasRequest request = new GenerateSasRequest();
        try {
            this.filler.fillObject((Object)request, sasRequest, (ConsumerMap)new GenerateBlobSasRequestConsumer());
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling azure-blob in generateSas, request : " + request.toString()));
            blockBlob = this.container.getBlockBlobReference(request.getBlob());
            String sas = blockBlob.generateSharedAccessSignature(request.getPolicy(), request.getHeaders(), request.getGroupPolicyIdentifier(), request.getIpRange(), request.getProtocols());
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to azure-blob ingenerateSas is completed in  " + (endTime - startTime) + " ms"));
            Struct response = new Struct();
            response.put((Object)"sas", (Object)sas);
            response.put((Object)"status", (Object)"success");
            Struct struct = response;
            return struct;
        }
        catch (StorageException | URISyntaxException | InvalidKeyException e) {
            this.logger.error((Object)"Error occurred in generateSas : ", e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"generateSasError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in generateSas : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"generateSasError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"generateSas", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct uploadDirectory(Map uploadDirectoryRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"uploadDirectory", (boolean)true);
        UploadDirectoryRequest request = new UploadDirectoryRequest();
        this.filler.fillObject((Object)request, uploadDirectoryRequest, (ConsumerMap)new UploadDirectoryRequestConsumer());
        File file = VFSFileFactory.getFileObject((String)request.getSrcDirectory());
        LinkedList<String> successList = new LinkedList<String>();
        LinkedList<Struct> failedList = new LinkedList<Struct>();
        this.uploadDirectory(request, file, successList, failedList);
        Struct response = new Struct();
        response.put((Object)"status", (Object)"success");
        response.put((Object)"successList", successList);
        response.put((Object)"failedList", failedList);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"uploadDirectory", null, (Object)response.getOrDefault((Object)"statusCode", (Object)200), (TagAttributeList)this.tagAttributeList);
        return response;
    }

    private void uploadDirectory(UploadDirectoryRequest request, File file, List<String> successList, List<Struct> failedList) {
        File[] files;
        if (!file.isDirectory()) {
            throw new ValidationException(request.getSrcDirectory() + " is not a directory.");
        }
        this.logger.info((Object)file.getAbsolutePath());
        for (File childFile : files = Optional.ofNullable(file.listFiles()).orElse(new File[0])) {
            if (childFile.isDirectory()) {
                if (!request.isUploadNestedDirectory()) continue;
                this.uploadDirectory(request, childFile, successList, failedList);
                continue;
            }
            UploadFileBlobRequest uploadFileBlobRequest = new UploadFileBlobRequest();
            uploadFileBlobRequest.setKey(Optional.ofNullable(request.getPrefix()).orElse("") + childFile.getAbsolutePath().replace(request.getSrcDirectory() + "\\", "").replace(request.getSrcDirectory() + "/", ""));
            uploadFileBlobRequest.setSrcFile(childFile.getAbsolutePath());
            uploadFileBlobRequest.setAccessCondition(request.getAccessCondition());
            uploadFileBlobRequest.setOptions(request.getOptions());
            uploadFileBlobRequest.setOpContext(this.getOperationContext(request));
            Struct response = null;
            try {
                response = this.uploadFile(uploadFileBlobRequest);
            }
            catch (Exception e) {
                this.logger.error((Object)"Error occurred in uploadDirectory : ", (Throwable)e);
                throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"generateSasError"), e);
            }
            if ("success".equalsIgnoreCase((String)response.get((Object)"status"))) {
                successList.add(uploadFileBlobRequest.getSrcFile());
                continue;
            }
            failedList.add(response);
        }
    }

    private Struct uploadFile(UploadFileBlobRequest request) throws URISyntaxException, StorageException, IOException {
        Struct structResponse = new Struct();
        int statusCode = 200;
        long startTime = System.currentTimeMillis();
        this.logger.debug((Object)("Calling azure-blob in uploadFile, request : " + request.toString()));
        this.uploadFromFile(request.getKey(), request.getSrcFile(), request.getAccessCondition(), request.getOptions(), this.getOperationContext(request), request.getProperties());
        long endTime = System.currentTimeMillis();
        this.logger.info((Object)("Call to azure-blob inuploadFile is completed in  " + (endTime - startTime) + " ms"));
        structResponse.put((Object)"blobName", (Object)request.getKey());
        structResponse.put((Object)"status", (Object)"success");
        structResponse.put((Object)"statusCode", (Object)statusCode);
        return structResponse;
    }

    public void uploadFromFile(String blobName, String path, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext, BlobProperties properties) throws StorageException, IOException, URISyntaxException {
        File file;
        CloudBlockBlob blockBlob = this.container.getBlockBlobReference(blobName);
        if (blockBlob != null && properties != null) {
            blockBlob = this.updateBlobProperties(blockBlob, properties);
        }
        if (!((file = VFSFileFactory.getFileObject((String)path)) instanceof VFile)) {
            file = new File(file.getAbsolutePath());
        }
        try (InputStream inputStream = VFSFileFactory.getInputStream((File)file);){
            blockBlob.upload(inputStream, file.length(), accessCondition, options, opContext);
        }
    }

    private CloudBlockBlob updateBlobProperties(CloudBlockBlob blockBlob, BlobProperties properties) {
        String cacheControl = properties.getCacheControl();
        String contentDisposition = properties.getContentDisposition();
        String contentEncoding = properties.getContentEncoding();
        String contentLanguage = properties.getContentLanguage();
        String contentMD5 = properties.getContentMD5();
        String contentType = properties.getContentType();
        BlobProperties blockBlobProperties = blockBlob.getProperties();
        if (blockBlobProperties != null) {
            if (cacheControl != null) {
                blockBlobProperties.setCacheControl(cacheControl);
            }
            if (contentDisposition != null) {
                blockBlobProperties.setContentDisposition(contentDisposition);
            }
            if (contentEncoding != null) {
                blockBlobProperties.setContentEncoding(contentEncoding);
            }
            if (contentLanguage != null) {
                blockBlobProperties.setContentLanguage(contentLanguage);
            }
            if (contentMD5 != null) {
                blockBlobProperties.setContentMD5(contentMD5);
            }
            if (contentType == null) {
                contentType = this.detectFileType(blockBlob);
            }
            if (contentType != null) {
                blockBlobProperties.setContentType(contentType);
            }
        }
        return blockBlob;
    }

    private String detectFileType(CloudBlockBlob blockBlob) {
        return null;
    }

    public Struct parallelUploadFile(Map parallelUploadRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"parallelUploadFile", (boolean)true);
        Struct structResponse = new Struct();
        String statusCode = "Success";
        UploadFileBlobRequest request = new UploadFileBlobRequest();
        try {
            this.filler.fillObject((Object)request, parallelUploadRequest, (ConsumerMap)UploadFileBlobRequestConsumer.getInstance());
            if (Objects.isNull(request.getOptions())) {
                BlobRequestOptions requestOptions = Objects.isNull(this.client.getDefaultRequestOptions()) ? new BlobRequestOptions() : new BlobRequestOptions(this.client.getDefaultRequestOptions());
                request.setOptions(requestOptions);
            }
            if (Objects.isNull(request.getOptions().getConcurrentRequestCount())) {
                request.getOptions().setConcurrentRequestCount(Integer.valueOf(5));
            }
            if (Objects.isNull(request.getOptions().getSingleBlobPutThresholdInBytes())) {
                request.getOptions().setSingleBlobPutThresholdInBytes(Integer.valueOf(0x2000000));
            }
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling azure-blob in parallelUploadFile, request : " + request.toString()));
            this.uploadFile(request);
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to azure-blob inparallelUploadFile is completed in  " + (endTime - startTime) + " ms"));
            structResponse.put((Object)"blobName", (Object)request.getKey());
            structResponse.put((Object)"status", (Object)"success");
            Struct struct = structResponse;
            return struct;
        }
        catch (IOException e) {
            this.logger.error((Object)"Error occurred in parallelUploadFile : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"parallelUploadFileError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in parallelUploadFile : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"parallelUploadFileError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"parallelUploadFile", null, (Object)statusCode, null, (String)request.getKey(), (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct parallelDownloadFile(Map parallelDownloadRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"parallelDownloadFile", (boolean)true);
        Struct structResponse = new Struct();
        String statusCode = "Success";
        BlobDownloadRequest request = new BlobDownloadRequest();
        try {
            this.filler.fillObject((Object)request, parallelDownloadRequest, (ConsumerMap)new BlobDownloadRequestConsumer());
            if (Objects.isNull(request.getOptions())) {
                BlobRequestOptions requestOptions = Objects.isNull(this.client.getDefaultRequestOptions()) ? new BlobRequestOptions() : new BlobRequestOptions(this.client.getDefaultRequestOptions());
                request.setOptions(requestOptions);
            }
            if (Objects.isNull(request.getOptions().getConcurrentRequestCount())) {
                request.getOptions().setConcurrentRequestCount(Integer.valueOf(5));
            }
            if (Objects.isNull(request.getOptions().getSingleBlobPutThresholdInBytes())) {
                request.getOptions().setSingleBlobPutThresholdInBytes(Integer.valueOf(0x2000000));
            }
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling azure-blob in parallelDownloadFile, request : " + request.toString()));
            CloudBlockBlob blockBlob = this.container.getBlockBlobReference(request.getBlobName());
            blockBlob.downloadAttributes();
            BlobProperties properties = blockBlob.getProperties();
            long blobTotalLength = properties.getLength();
            long chunkLength = request.getOptions().getSingleBlobPutThresholdInBytes().intValue();
            this.parallelDownloadBlob(request, blockBlob, blobTotalLength, chunkLength);
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to azure-blob inparallelDownloadFile is completed in  " + (endTime - startTime) + " ms"));
            structResponse.put((Object)"blobName", (Object)request.getBlobName());
            structResponse.put((Object)"status", (Object)"success");
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in parallelDownloadFile : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"parallelDownloadFileError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"parallelDownloadFile", null, (Object)statusCode, null, (String)request.getBlobName(), (TagAttributeList)this.tagAttributeList);
        }
        return structResponse;
    }

    private void parallelDownloadBlob(BlobDownloadRequest request, CloudBlockBlob blockBlob, long totalBlobLength, long chunkLength) throws IOException {
        File file = VFSFileFactory.getFileObject((String)request.getDestinationFile());
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        RandomAccessFile randomAccessFile = VFSFileFactory.getRandomAccessFile((File)file, (String)"rw");
        LinkedList<Struct> queues = new LinkedList<Struct>();
        long offset = 0L;
        int count = 0;
        ExecutorCompletionService<Integer> completionService = new ExecutorCompletionService<Integer>(executorService);
        ArrayList<Future<Integer>> futures = new ArrayList<Future<Integer>>();
        for (long blobRemainingLength = totalBlobLength; blobRemainingLength > 0L; blobRemainingLength -= chunkLength) {
            int cl = Integer.valueOf(String.valueOf(Math.min(chunkLength, blobRemainingLength)));
            Struct struct = new Struct();
            struct.put((Object)"offset", (Object)offset);
            struct.put((Object)"chunkLength", (Object)chunkLength);
            struct.put((Object)"count", (Object)(++count));
            queues.add(struct);
            offset += chunkLength;
            futures.add(completionService.submit(() -> {
                byte[] arr = new byte[cl];
                try {
                    this.logger.info((Object)("started downloading from offset : " + (Long)struct.get((Object)"offset")));
                    int downloaded = blockBlob.downloadRangeToByteArray(((Long)struct.get((Object)"offset")).longValue(), Long.valueOf(cl), arr, 0, request.getAccessCondition(), request.getOptions(), this.getOperationContext(request));
                    this.logger.info((Object)("finished downloading from offset : " + (Long)struct.get((Object)"offset")));
                    randomAccessFile.seek(Integer.valueOf(String.valueOf(struct.get((Object)"offset"))).intValue());
                    randomAccessFile.write(arr, 0, cl);
                    this.logger.info((Object)("written to file from offset : " + (Long)struct.get((Object)"offset")));
                    this.logger.info((Object)("part number : " + String.valueOf(struct.get((Object)"count"))));
                    return downloaded;
                }
                catch (StorageException | IOException e) {
                    this.logger.error((Object)"Error occurred in parallelDownloadBlob : ", e);
                    throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"parallelDownloadFileError"), e);
                }
            }));
        }
        try {
            long totaldownloads = 0L;
            for (Future future : futures) {
                totaldownloads += (long)((Integer)completionService.take().get(5L, TimeUnit.MINUTES)).intValue();
            }
            this.logger.info((Object)("Total bytes downloaded " + totaldownloads));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.logger.error((Object)"Error occurred in parallelDownloadBlob  : ", (Throwable)e);
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"parallelDownloadFileError"), e);
        }
        finally {
            try {
                randomAccessFile.close();
            }
            catch (IOException e) {
                this.logger.error((Object)"Error occurred in parallelDownloadBlob  : ", (Throwable)e);
                throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"parallelDownloadFileError"), e);
            }
        }
    }

    public Struct acquireLease(Map acquireLeaseRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"acquireLease", (boolean)true);
        String statusCode = "Success";
        AcquireLeaseRequest request = new AcquireLeaseRequest();
        this.filler.fillObject((Object)request, acquireLeaseRequest, (ConsumerMap)new AcquireLeaseRequestConsumer());
        CloudBlockBlob blockBlob = null;
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling azure-blob in acquireLease, request : " + request.toString()));
            blockBlob = this.container.getBlockBlobReference(request.getBlobName());
            String leaseId = blockBlob.acquireLease(Integer.valueOf(request.getLeaseTimeInSeconds()), request.getProposedLeaseId(), request.getAccessCondition(), request.getOptions(), this.getOperationContext(request));
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to azure-blob inacquireLease is completed in  " + (endTime - startTime) + " ms"));
            Struct response = new Struct();
            response.put((Object)"status", (Object)"success");
            response.put((Object)"blobName", (Object)request.getBlobName());
            response.put((Object)"leaseID", (Object)leaseId);
            Struct struct = response;
            return struct;
        }
        catch (StorageException e) {
            this.logger.error((Object)"Error occurred in acquireLease : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"acquireLeaseError"), e);
        }
        catch (URISyntaxException e) {
            this.logger.error((Object)"Error occurred in acquireLease : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"acquireLeaseError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in acquireLease : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"acquireLeaseError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"acquireLease", null, (Object)statusCode, null, (String)request.getBlobName(), (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct renewLease(Map renewLeaseRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"renewLease", (boolean)true);
        String statusCode = "Success";
        BreakLeaseRequest request = new BreakLeaseRequest();
        this.filler.fillObject((Object)request, renewLeaseRequest, (ConsumerMap)new BlobLeaseRequestConsumer());
        CloudBlockBlob blockBlob = null;
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling azure-blob in renewLease, request : " + request.toString()));
            blockBlob = this.container.getBlockBlobReference(request.getBlobName());
            blockBlob.renewLease(request.getAccessCondition(), request.getOptions(), this.getOperationContext(request));
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to azure-blob inrenewLease is completed in  " + (endTime - startTime) + " ms"));
            Struct response = new Struct();
            response.put((Object)"status", (Object)"success");
            response.put((Object)"blobName", (Object)request.getBlobName());
            Struct struct = response;
            return struct;
        }
        catch (StorageException e) {
            this.logger.error((Object)"Error occurred in renewLease : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"renewLeaseError"), e);
        }
        catch (URISyntaxException e) {
            this.logger.error((Object)"Error occurred in renewLease : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"renewLeaseError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in renewLease : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"renewLeaseError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"renewLease", null, (Object)statusCode, null, (String)request.getBlobName(), (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct changeLease(Map changeLeaseRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"changeLease", (boolean)true);
        String statusCode = "Success";
        ChangeLeaseRequest request = new ChangeLeaseRequest();
        this.filler.fillObject((Object)request, changeLeaseRequest, (ConsumerMap)new ChangeLeaseRequestConsumer());
        CloudBlockBlob blockBlob = null;
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling azure-blob in changeLease, request : " + request.toString()));
            blockBlob = this.container.getBlockBlobReference(request.getBlobName());
            String leaseId = blockBlob.changeLease(request.getProposedLeaseId(), request.getAccessCondition(), request.getOptions(), this.getOperationContext(request));
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to azure-blob inchangeLease is completed in  " + (endTime - startTime) + " ms"));
            Struct response = new Struct();
            response.put((Object)"status", (Object)"success");
            response.put((Object)"blobName", (Object)request.getBlobName());
            response.put((Object)"leaseID", (Object)leaseId);
            Struct struct = response;
            return struct;
        }
        catch (StorageException e) {
            this.logger.error((Object)"Error occurred in changeLease : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"changeLeaseError"), e);
        }
        catch (URISyntaxException e) {
            this.logger.error((Object)"Error occurred in changeLease : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"changeLeaseError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in changeLease : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"changeLeaseError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"changeLease", null, (Object)statusCode, null, (String)request.getBlobName(), (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct breakLease(Map breakLeaseRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"breakLease", (boolean)true);
        String statusCode = "Success";
        BreakLeaseRequest request = new BreakLeaseRequest();
        this.filler.fillObject((Object)request, breakLeaseRequest, (ConsumerMap)new BlobLeaseRequestConsumer());
        CloudBlockBlob blockBlob = null;
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling azure-blob in breakLease, request : " + request.toString()));
            blockBlob = this.container.getBlockBlobReference(request.getBlobName());
            long time = blockBlob.breakLease(Integer.valueOf(request.getBreakPeriodInSeconds()), request.getAccessCondition(), request.getOptions(), this.getOperationContext(request));
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to azure-blob inbreakLease is completed in  " + (endTime - startTime) + " ms"));
            Struct response = new Struct();
            response.put((Object)"status", (Object)"success");
            response.put((Object)"blobName", (Object)request.getBlobName());
            Struct struct = response;
            return struct;
        }
        catch (StorageException e) {
            this.logger.error((Object)"Error occurred in breakLease : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"breakLeaseError"), e);
        }
        catch (URISyntaxException e) {
            this.logger.error((Object)"Error occurred in breakLease : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"breakLeaseError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in breakLease : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"breakLeaseError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"breakLease", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct releaseLease(Map releaseLeaseRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"releaseLease", (boolean)true);
        String statusCode = "Success";
        BreakLeaseRequest request = new BreakLeaseRequest();
        this.filler.fillObject((Object)request, releaseLeaseRequest, (ConsumerMap)new BlobLeaseRequestConsumer());
        CloudBlockBlob blockBlob = null;
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling azure-blob in releaseLease, request : " + request.toString()));
            blockBlob = this.container.getBlockBlobReference(request.getBlobName());
            blockBlob.releaseLease(request.getAccessCondition(), request.getOptions(), this.getOperationContext(request));
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to azure-blob inreleaseLease is completed in  " + (endTime - startTime) + " ms"));
            Struct response = new Struct();
            response.put((Object)"status", (Object)"success");
            response.put((Object)"blobName", (Object)request.getBlobName());
            Struct struct = response;
            return struct;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in releaseLease : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"releaseLeaseError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"releaseLease", null, (Object)statusCode, null, (String)request.getBlobName(), (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct uploadMetadata(Map metadataRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"uploadMetadata", (boolean)true);
        String statusCode = "Success";
        UploadMetadataRequest request = new UploadMetadataRequest();
        this.filler.fillObject((Object)request, metadataRequest, (ConsumerMap)new UploadMetadataRequestConsumer());
        CloudBlockBlob blockBlob = null;
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling azure-blob in uploadMetadata, request : " + request.toString()));
            blockBlob = this.container.getBlockBlobReference(request.getBlobName());
            blockBlob.setMetadata(request.getMetadata());
            blockBlob.uploadMetadata(request.getAccessCondition(), request.getOptions(), this.getOperationContext(request));
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to azure-blob inuploadMetadata is completed in  " + (endTime - startTime) + " ms"));
            Struct response = new Struct();
            response.put((Object)"status", (Object)"success");
            Struct struct = response;
            return struct;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in uploadMetadata : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"uploadMetadataError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"uploadMetadata", null, (Object)statusCode, null, (String)request.getBlobName(), (TagAttributeList)this.tagAttributeList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Struct createPartFiles(Map createPartFilesrequest) {
        CreatePartFileRequest request = new CreatePartFileRequest();
        this.filler.fillObject((Object)request, createPartFilesrequest, (ConsumerMap)CreatePartFileRequestConsumer.getInstance());
        File file = VFSFileFactory.getFileObject((String)request.getSourceFileName());
        InputStream inputStream = null;
        try {
            int readLength;
            inputStream = VFSFileFactory.getInputStream((File)file);
            byte[] bytes = new byte[request.getBlockSizeInBytes()];
            int part = 1;
            LinkedList<String> partFileList = new LinkedList<String>();
            while (inputStream.available() > 0 && (readLength = inputStream.read(bytes)) > 0) {
                String newFileName = Objects.isNull(request.getDirectory()) ? file.getParentFile().getAbsolutePath() + File.separator + part++ + "-" + file.getName() + ".part" : request.getDirectory() + File.separator + part++ + "-" + file.getName() + ".part";
                File partFile = VFSFileFactory.getFileObject((String)newFileName);
                if (!partFile.exists() || partFile.delete() && partFile.createNewFile()) {
                    try (OutputStream outputStream = null;){
                        outputStream = VFSFileFactory.getOutputStream((File)partFile);
                        outputStream.write(bytes);
                    }
                    partFileList.add(newFileName);
                    continue;
                }
                throw new AzureBlobApiException("Unable to deleting/creating file " + newFileName);
            }
            Struct result = new Struct();
            result.put((Object)"status", (Object)"success");
            result.put((Object)"partFiles", partFileList);
            Struct struct = result;
            return struct;
        }
        catch (IOException e) {
            throw new AzureBlobApiException("error making part file", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new AzureBlobApiException("error closing input file", e);
                }
            }
        }
    }

    public Struct blockUpload(Map blockUploadRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"blockUpload", (boolean)true);
        String statusCode = "Success";
        BlockUploadRequest request = new BlockUploadRequest();
        this.filler.fillObject((Object)request, blockUploadRequest, (ConsumerMap)BlockUploadRequestConsumer.getInstance());
        InputStream inputStream = null;
        try {
            CloudBlockBlob blockBlob = this.container.getBlockBlobReference(request.getBlobName());
            if (Objects.nonNull(request.getInputObject())) {
                inputStream = new ByteArrayInputStream(JSONUtils.serializeJSON((Object)request.getInputObject()).getBytes());
            } else if (Objects.nonNull(request.getSourceFile())) {
                File file = VFSFileFactory.getFileObject((String)request.getSourceFile());
                inputStream = VFSFileFactory.getInputStream((File)file);
            } else {
                throw new ValidationException(RB.getString(ContainerReference.class, (String)"invalidInputObjectAndFile"));
            }
            blockBlob.uploadBlock(request.getBlockId(), inputStream, (long)inputStream.available(), request.getAccessCondition(), request.getOptions(), this.getOperationContext(request));
            Struct result = new Struct();
            result.put((Object)"status", (Object)"success");
            Struct struct = result;
            return struct;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in blockUpload : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"uploadBlockBlobError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"blockUpload", null, (Object)statusCode, null, (String)request.getBlobName(), (TagAttributeList)this.tagAttributeList);
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)"Error occurred in closing file input stream ", (Throwable)e);
                }
            }
        }
    }

    public Struct commitBlockList(Map struct) {
        RequestMonitorEventProcessor.onFunctionStart((String)"commitBlockList", (boolean)true);
        String statusCode = "Success";
        CommitBlockList request = new CommitBlockList();
        try {
            this.filler.fillObject((Object)request, struct, (ConsumerMap)CommitBlockListRequestConsumer.getInstance());
            CloudBlockBlob blockBlob = this.container.getBlockBlobReference(request.getBlobName());
            blockBlob.commitBlockList(request.getBlockIds(), request.getAccessCondition(), request.getOptions(), this.getOperationContext(request));
            Struct result = new Struct();
            result.put((Object)"status", (Object)"success");
            Struct struct2 = result;
            return struct2;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in commitBlockList : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(ContainerReference.class, (String)"commitBlocksError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"commitBlockList", null, (Object)statusCode, null, (String)request.getBlobName(), (TagAttributeList)this.tagAttributeList);
        }
    }

    private OperationContext getOperationContext(AbstractAzureBlobRequest request) {
        return Objects.nonNull(request.getOpContext()) ? request.getOpContext() : this.context;
    }

    public Object invoke(String methodName, Map args, PageContext pageContext) throws Throwable {
        NamedMethodInvoker NamedMethodInvoker2 = __InvokeNamedMethodInvocationMap.get((Object)methodName);
        if (NamedMethodInvoker2 == null) {
            throw new CfJspPage.UnsupportedBaseTypeException(methodName, (Object)this);
        }
        this.logger.info((Object)("blob service method " + methodName + " invoked and started excecution... "));
        long startTime = System.currentTimeMillis();
        Object invokeObject = NamedMethodInvoker2.invoke((Object)this, args);
        long endTime = System.currentTimeMillis();
        long timeElapsed = endTime - startTime;
        this.logger.info((Object)("blob service method " + methodName + " finished execution successfully. Turn around time : " + timeElapsed + " milli secs"));
        return invokeObject;
    }

    static {
        __InvokeNamedMethodInvocationMap.put((Object)"listAll", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.listAll();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"listRequest"}, args);
                    return obj.listAll((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"listRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("listAll", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"putPolicy", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"policyRequest"}, args);
                    return obj.putPolicy((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"policyRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("putPolicy", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getPolicies", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getPolicies();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"getPolicyRequest"}, args);
                    return obj.getPolicies((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"getPolicyRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getPolicies", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"deletePolicies", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.deletePolicies();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("deletePolicies", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"uploadFile", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"uploadRequest"}, args);
                    return obj.uploadFile((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"uploadRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("uploadFile", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"uploadObject", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"uploadRequest"}, args);
                    return obj.uploadObject((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"uploadRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("uploadObject", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"downloadObject", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"downloadRequest"}, args);
                    return obj.downloadObject((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"downloadRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("downloadObject", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"downloadToFile", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"downloadRequest"}, args);
                    return obj.downloadToFile((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"downloadRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("downloadToFile", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"delete", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"key"}, args);
                    return obj.delete(argColl.get((Object)"key"));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("delete", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"copy", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"copyRequest"}, args);
                    return obj.copy((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"copyRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("copy", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"createSnapshot", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"createSnapshotRequest"}, args);
                    return obj.createSnapshot((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"createSnapshotRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("createSnapshot", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"generateSas", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"sasRequest"}, args);
                    return obj.generateSas((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"sasRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("generateSas", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"uploadDirectory", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"uploadDirectoryRequest"}, args);
                    return obj.uploadDirectory((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"uploadDirectoryRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("uploadDirectory", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"uploadFromFile", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 6: {
                    argColl = new ArgumentCollection((Object[])new String[]{"blobName", "path", "accessCondition", "options", "opContext", "properties"}, args);
                    obj.uploadFromFile(Cast._String((Object)argColl.get((Object)"blobName")), Cast._String((Object)argColl.get((Object)"path")), (AccessCondition)Cast._castForInvokeGen((Object)argColl.get((Object)"accessCondition"), AccessCondition.class), (BlobRequestOptions)Cast._castForInvokeGen((Object)argColl.get((Object)"options"), BlobRequestOptions.class), (OperationContext)Cast._castForInvokeGen((Object)argColl.get((Object)"opContext"), OperationContext.class), (BlobProperties)Cast._castForInvokeGen((Object)argColl.get((Object)"properties"), BlobProperties.class));
                    return null;
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("uploadFromFile", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"parallelUploadFile", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"parallelUploadRequest"}, args);
                    return obj.parallelUploadFile((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"parallelUploadRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("parallelUploadFile", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"parallelDownloadFile", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"parallelDownloadRequest"}, args);
                    return obj.parallelDownloadFile((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"parallelDownloadRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("parallelDownloadFile", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"acquireLease", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"acquireLeaseRequest"}, args);
                    return obj.acquireLease((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"acquireLeaseRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("acquireLease", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"renewLease", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"renewLeaseRequest"}, args);
                    return obj.renewLease((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"renewLeaseRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("renewLease", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"changeLease", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"changeLeaseRequest"}, args);
                    return obj.changeLease((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"changeLeaseRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("changeLease", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"breakLease", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"breakLeaseRequest"}, args);
                    return obj.breakLease((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"breakLeaseRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("breakLease", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"releaseLease", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"releaseLeaseRequest"}, args);
                    return obj.releaseLease((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"releaseLeaseRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("releaseLease", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"uploadMetadata", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"metadataRequest"}, args);
                    return obj.uploadMetadata((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"metadataRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("uploadMetadata", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"createPartFiles", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"createPartFilesrequest"}, args);
                    return obj.createPartFiles((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"createPartFilesrequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("createPartFiles", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"blockUpload", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"blockUploadRequest"}, args);
                    return obj.blockUpload((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"blockUploadRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("blockUpload", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"commitBlockList", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"struct"}, args);
                    return obj.commitBlockList((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"struct"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("commitBlockList", obj);
        });
    }
}

