/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.exchange;

import coldfusion.exchange.ExchangeTask;
import coldfusion.exchange.TaskFilterInfo;
import coldfusion.tagext.net.exchange.ExchangeExceptions;
import coldfusion.tagext.net.exchange.ExchangeFilterable;
import coldfusion.tagext.net.exchange.ExchangeTag;
import coldfusion.tagext.net.exchange.TaskConstants;
import coldfusion.tagext.net.exchange.TaskTagHelper;
import coldfusion.tagext.validation.RequiredAttributesException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

public class ExchangeTaskTag
extends ExchangeTag
implements ExchangeFilterable,
TaskConstants {
    TaskFilterInfo filterInfo = new TaskFilterInfo();
    private Map task = null;
    private static HashMap validFilterAttributes = new HashMap();
    private static HashMap validTaskAttributes = new HashMap();

    PageContext getPageContext() {
        return this.pageContext;
    }

    TaskFilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    @Override
    public void addFilter(String attribName, HashMap values) {
        if (!this.isValidAttributeKey(attribName, validFilterAttributes)) {
            ExchangeExceptions.throwInvalidFilterAttributeKeyException(attribName, "cfexchangetask");
        }
        Date fromDate = null;
        Date toDate = null;
        Object value = values.get("value");
        if (attribName.equalsIgnoreCase("StartDate")) {
            if (values.containsKey("from")) {
                fromDate = ExchangeTag.castDate(values.get("from"), "from");
            }
            if (values.containsKey("to")) {
                toDate = ExchangeTag.castDate(values.get("to"), "to");
            }
            if (fromDate != null || toDate != null) {
                this.filterInfo.setFromStartDate(fromDate);
                this.filterInfo.setToStartDate(toDate);
            } else {
                if (value != null) {
                    ExchangeExceptions.throwInvalidFilterAttributesForDateExcpetion();
                }
                ExchangeExceptions.throwInvalidAttributeValueException("StartDate");
            }
            return;
        }
        if (attribName.equalsIgnoreCase("DueDate")) {
            if (values.containsKey("from")) {
                fromDate = ExchangeTag.castDate(values.get("from"), "from");
            }
            if (values.containsKey("to")) {
                toDate = ExchangeTag.castDate(values.get("to"), "to");
            }
            if (fromDate != null || toDate != null) {
                this.filterInfo.setFromDueDate(fromDate);
                this.filterInfo.setToDueDate(toDate);
            } else {
                if (value != null) {
                    ExchangeExceptions.throwInvalidFilterAttributesForDateExcpetion();
                }
                ExchangeExceptions.throwInvalidAttributeValueException("DueDate");
            }
            return;
        }
        if (attribName.equalsIgnoreCase("ReminderDate")) {
            if (values.containsKey("from")) {
                fromDate = ExchangeTag.castDate(values.get("from"), "from");
            }
            if (values.containsKey("to")) {
                toDate = ExchangeTag.castDate(values.get("to"), "to");
            }
            if (fromDate != null || toDate != null) {
                this.filterInfo.setFromReminderDate(fromDate);
                this.filterInfo.setToReminderDate(toDate);
            } else {
                if (value != null) {
                    ExchangeExceptions.throwInvalidFilterAttributesForDateExcpetion();
                }
                ExchangeExceptions.throwInvalidAttributeValueException("ReminderDate");
            }
            return;
        }
        if (attribName.equalsIgnoreCase("DateCompleted")) {
            if (values.containsKey("from")) {
                fromDate = ExchangeTag.castDate(values.get("from"), "from");
            }
            if (values.containsKey("to")) {
                toDate = ExchangeTag.castDate(values.get("to"), "to");
            }
            if (fromDate != null || toDate != null) {
                this.filterInfo.setFromDateCompleted(fromDate);
                this.filterInfo.setToDateCompleted(toDate);
            } else {
                if (value != null) {
                    ExchangeExceptions.throwInvalidFilterAttributesForDateExcpetion();
                }
                ExchangeExceptions.throwInvalidAttributeValueException("DateCompleted");
            }
            return;
        }
        if (attribName.equalsIgnoreCase("lastModified")) {
            if (values.containsKey("from")) {
                fromDate = ExchangeTag.castDate(values.get("from"), "from");
            }
            if (values.containsKey("to")) {
                toDate = ExchangeTag.castDate(values.get("to"), "to");
            }
            if (fromDate != null && toDate != null && toDate.compareTo(fromDate) < 0) {
                ExchangeExceptions.throwInvalidStartEndTimeException();
            }
            if (fromDate != null || toDate != null) {
                this.filterInfo.setFromLastModifiedDate(fromDate);
                this.filterInfo.setToLastModifiedDate(toDate);
            } else {
                if (value != null) {
                    ExchangeExceptions.throwInvalidFilterAttributesForDateExcpetion();
                }
                ExchangeExceptions.throwInvalidAttributeValueException("lastModified");
            }
            return;
        }
        if (value == null || value.toString().length() == 0) {
            ExchangeExceptions.throwEmptyAttributeValueException(attribName);
        }
        if (!(value instanceof String)) {
            ExchangeExceptions.throwInvalidStringValueException(attribName);
        }
        if (attribName.equalsIgnoreCase("MaxRows")) {
            int tmpInt = ExchangeTag.castInt(value, "MaxRows");
            if (tmpInt <= 0 && tmpInt != -1) {
                ExchangeExceptions.throwNonPositiveValueException("MaxRows");
            }
            this.filterInfo.setMaxRows(tmpInt);
        } else if (attribName.equalsIgnoreCase("Status")) {
            if (ExchangeTask.statusStringToInt(value.toString()) == -1) {
                ExchangeExceptions.throwInvalidTaskStatusException("Status");
            }
            this.filterInfo.setStatus(value.toString());
        } else if (attribName.equalsIgnoreCase("PercentCompleted")) {
            int percentComplete = ExchangeTag.castInt(value, "PercentCompleted");
            if (percentComplete < 0 || percentComplete > 100) {
                ExchangeExceptions.throwInvalidPercentException("PercentCompleted");
            }
            this.filterInfo.setPercentComplete(percentComplete);
        } else if (attribName.equalsIgnoreCase("TotalWork")) {
            this.filterInfo.setTotalWork(ExchangeTag.castInt(value, "TotalWork"));
            if (this.filterInfo.getTotalWork() < 0) {
                ExchangeExceptions.throwNegativeValueException(attribName);
            }
        } else if (attribName.equalsIgnoreCase("ActualWork")) {
            this.filterInfo.setActualWork(ExchangeTag.castInt(value, "ActualWork"));
            if (this.filterInfo.getActualWork() < 0) {
                ExchangeExceptions.throwNegativeValueException(attribName);
            }
        } else if (attribName.equalsIgnoreCase("Mileage")) {
            this.filterInfo.setMileage(value.toString());
        } else if (attribName.equalsIgnoreCase("BillingInfo")) {
            this.filterInfo.setBillingInfo(value.toString());
        } else if (attribName.equalsIgnoreCase("Companies")) {
            this.filterInfo.setCompanies(value.toString());
        } else if (attribName.equalsIgnoreCase("Subject")) {
            this.filterInfo.setSubject(value.toString());
        } else if (attribName.equalsIgnoreCase("Message")) {
            this.filterInfo.setMessage(value.toString());
        } else if (attribName.equalsIgnoreCase("Priority")) {
            int priority = ExchangeTaskTag.stringPriorityToInt(value.toString());
            if (priority == -1) {
                ExchangeExceptions.throwInvalidPriorityException("Priority");
            }
            this.filterInfo.setPriority(priority);
        } else if (attribName.equalsIgnoreCase("uid")) {
            if (value == null || value.toString().trim().length() == 0) {
                ExchangeExceptions.throwInvalidAttributeValueException("uid");
            }
            this.filterInfo.setId(value.toString());
        } else if (attribName.equalsIgnoreCase("Categories")) {
            this.filterInfo.setCategories(value.toString());
        }
    }

    public static int stringPriorityToInt(String priority) {
        if (priority.equalsIgnoreCase("high")) {
            return 2;
        }
        if (priority.equalsIgnoreCase("low")) {
            return 0;
        }
        if (priority.equalsIgnoreCase("normal")) {
            return 1;
        }
        return -1;
    }

    public static String intPriorityToString(int priority) {
        switch (priority) {
            case 0: {
                return "low";
            }
            case 1: {
                return "normal";
            }
            case 2: {
                return "high";
            }
        }
        return null;
    }

    @Override
    public int doStartTag() throws JspException {
        super.doStartTag();
        this.onTagStart();
        if ((this.action.equalsIgnoreCase("create") || this.action.equalsIgnoreCase("modify")) && this.getTask() == null) {
            throw new RequiredAttributesException(this.getTagPublicName(), "Task");
        }
        return 6;
    }

    @Override
    public int doEndTag() throws JspException {
        super.doEndTag();
        if (this.action.equalsIgnoreCase("get")) {
            if (this.getName() == null) {
                throw new RequiredAttributesException(this.getTagPublicName(), "name");
            }
            TaskTagHelper.getTasks(this);
        } else if (this.action.equalsIgnoreCase("create")) {
            TaskTagHelper.saveTask(this, this.getTask(), true);
        } else if (this.action.equalsIgnoreCase("modify")) {
            TaskTagHelper.saveTask(this, this.getTask(), false);
        } else if (this.action.equalsIgnoreCase("delete")) {
            if (this.getUid() == null || this.getUid().trim().length() == 0) {
                ExchangeExceptions.throwInvalidAttributeValueException("uid");
            }
            TaskTagHelper.deleteTasks(this);
        } else if (this.action.equalsIgnoreCase("getAttachments")) {
            this.getAttachments(3);
        } else if (this.action.equalsIgnoreCase("deleteAttachments")) {
            this.deleteAttachments(3);
        }
        this.release();
        this.onTagEnd();
        return 6;
    }

    public Map getTask() {
        return this.task;
    }

    public void setTask(Map task) {
        this.validateStruct(task, validTaskAttributes, "cfexchangetask", "task");
        this.task = task;
    }

    @Override
    public void release() {
        super.release();
        this.filterInfo = new TaskFilterInfo();
        this.task = null;
    }

    static {
        validTaskAttributes.put("StartDate".toUpperCase(), "StartDate".toUpperCase());
        validTaskAttributes.put("DueDate".toUpperCase(), "DueDate".toUpperCase());
        validTaskAttributes.put("Status".toUpperCase(), "Status".toUpperCase());
        validTaskAttributes.put("Priority".toUpperCase(), "Priority".toUpperCase());
        validTaskAttributes.put("PercentCompleted".toUpperCase(), "PercentCompleted".toUpperCase());
        validTaskAttributes.put("ReminderDate".toUpperCase(), "ReminderDate".toUpperCase());
        validTaskAttributes.put("Companies".toUpperCase(), "Companies".toUpperCase());
        validTaskAttributes.put("DateCompleted".toUpperCase(), "DateCompleted".toUpperCase());
        validTaskAttributes.put("TotalWork".toUpperCase(), "TotalWork".toUpperCase());
        validTaskAttributes.put("ActualWork".toUpperCase(), "ActualWork".toUpperCase());
        validTaskAttributes.put("Mileage".toUpperCase(), "Mileage".toUpperCase());
        validTaskAttributes.put("BillingInfo".toUpperCase(), "BillingInfo".toUpperCase());
        validTaskAttributes.put("Message".toUpperCase(), "Message".toUpperCase());
        validTaskAttributes.put("Subject".toUpperCase(), "Subject".toUpperCase());
        validTaskAttributes.put("attachments".toUpperCase(), "attachments".toUpperCase());
        validTaskAttributes.put("Categories".toUpperCase(), "Categories".toUpperCase());
        validFilterAttributes.put("StartDate".toUpperCase(), "StartDate".toUpperCase());
        validFilterAttributes.put("from".toUpperCase(), "from".toUpperCase());
        validFilterAttributes.put("to".toUpperCase(), "to".toUpperCase());
        validFilterAttributes.put("DueDate".toUpperCase(), "DueDate".toUpperCase());
        validFilterAttributes.put("ReminderDate".toUpperCase(), "ReminderDate".toUpperCase());
        validFilterAttributes.put("DateCompleted".toUpperCase(), "DateCompleted".toUpperCase());
        validFilterAttributes.put("value".toUpperCase(), "value".toUpperCase());
        validFilterAttributes.put("MaxRows".toUpperCase(), "MaxRows".toUpperCase());
        validFilterAttributes.put("Status".toUpperCase(), "Status".toUpperCase());
        validFilterAttributes.put("PercentCompleted".toUpperCase(), "PercentCompleted".toUpperCase());
        validFilterAttributes.put("TotalWork".toUpperCase(), "TotalWork".toUpperCase());
        validFilterAttributes.put("Mileage".toUpperCase(), "Mileage".toUpperCase());
        validFilterAttributes.put("BillingInfo".toUpperCase(), "BillingInfo".toUpperCase());
        validFilterAttributes.put("Companies".toUpperCase(), "Companies".toUpperCase());
        validFilterAttributes.put("Subject".toUpperCase(), "Subject".toUpperCase());
        validFilterAttributes.put("Message".toUpperCase(), "Message".toUpperCase());
        validFilterAttributes.put("Priority".toUpperCase(), "Priority".toUpperCase());
        validFilterAttributes.put("uid".toUpperCase(), "uid".toUpperCase());
        validFilterAttributes.put("ActualWork".toUpperCase(), "ActualWork".toUpperCase());
        validFilterAttributes.put("Categories".toUpperCase(), "Categories".toUpperCase());
        validFilterAttributes.put("lastModified".toUpperCase(), "lastModified".toUpperCase());
    }
}

