/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.ftp;

import coldfusion.util.CFDumpable;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPListParseEngine;

public class FTPClientWrapper
extends FTPClient
implements CFDumpable {
    private String userName;
    private final String systemType;
    private final String fileNameEncoding;

    public FTPClientWrapper(String systemType, String fileNameEncoding) {
        this.systemType = systemType;
        this.fileNameEncoding = fileNameEncoding;
    }

    String getsystemType() {
        return this.systemType;
    }

    public String getFileNameEncoding() {
        return this.fileNameEncoding;
    }

    public String getLabel() {
        return "FTPConnection";
    }

    public Object getMetadata() {
        HashMap<String, Object> mp = new HashMap<String, Object>();
        mp.put("RemoteAddress", this.getRemoteAddress().getHostAddress());
        mp.put("LocalAddress", this.getLocalAddress().getHostAddress());
        mp.put("DefaultPort", new Integer(this.getDefaultPort()));
        mp.put("RemotePort", new Integer(this.getRemotePort()));
        mp.put("User", this.userName);
        mp.put("DefaultTimeout", new Integer(this.getDefaultTimeout()));
        try {
            mp.put("Status", this.getStatus());
            mp.put("SystemName", this.getSystemName());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return mp;
    }

    public boolean login(String userName, String password) throws IOException {
        boolean result = super.login(userName, password);
        this.userName = userName;
        return result;
    }

    public boolean login(String userName, String password, String account) throws IOException {
        boolean result = super.login(userName, password, account);
        return result;
    }

    public FTPFile[] listFiles(String key, final String pathname) throws IOException {
        FTPFile[] fFiles;
        if (key == null || key.trim().equals("")) {
            key = this.systemType;
        }
        if (System.getSecurityManager() == null) {
            FTPListParseEngine engine = this.initiateListParsing(key, pathname);
            fFiles = engine.getFiles();
        } else {
            try {
                final String parserKey = key;
                fFiles = (FTPFile[])AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        FTPListParseEngine engine = FTPClientWrapper.this.initiateListParsing(parserKey, pathname);
                        return engine.getFiles();
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw (IOException)pae.getException();
            }
        }
        return fFiles;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.isConnected()) {
            try {
                this.quit();
                this.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

