/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.poi.ss.formula.eval.AreaEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.OperandResolver;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.Function;

public class PercentileFunc
implements Function {
    @Override
    public ValueEval evaluate(ValueEval[] args, int srcRowIndex, int srcColumnIndex) {
        double percentileToCalculate;
        if (args.length < 2) {
            throw new IllegalArgumentException("Percentile function expectes two arguments");
        }
        Double[] values = null;
        if (args[0] instanceof AreaEval) {
            try {
                values = this.getSelectedValues((AreaEval)args[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        try {
            percentileToCalculate = OperandResolver.coerceValueToDouble(args[1]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        if (values == null) {
            throw new IllegalArgumentException();
        }
        double result = PercentileFunc.calculatePercentile(values, percentileToCalculate);
        return new NumberEval(result);
    }

    private Double[] getSelectedValues(AreaEval areaEval) throws EvaluationException {
        int startRow = areaEval.getFirstRow();
        int startCol = areaEval.getFirstColumn();
        int endRow = areaEval.getLastRow();
        int endCol = areaEval.getLastColumn();
        ArrayList<Double> values = new ArrayList<Double>();
        for (int i = startRow; i <= endRow; ++i) {
            for (int j = startCol; j <= endCol; ++j) {
                if (!areaEval.contains(i, j)) continue;
                values.add(OperandResolver.coerceValueToDouble(this.getAbsoluteValue(areaEval, i, j)));
            }
        }
        return values.toArray(new Double[0]);
    }

    static double calculatePercentile(Double[] values, double percentileToCalculate) {
        Arrays.sort((Object[])values);
        double posInArray = (double)(values.length - 1) * percentileToCalculate + 1.0;
        int intPart = (int)posInArray;
        float fractionPart = (float)(posInArray - (double)intPart);
        return values[intPart - 1] + (values[intPart] - values[intPart - 1]) * (double)fractionPart;
    }

    public final ValueEval getAbsoluteValue(AreaEval areaEval, int row, int col) {
        int rowOffsetIx = row - areaEval.getFirstRow();
        int colOffsetIx = col - areaEval.getFirstColumn();
        int _nRows = areaEval.getLastRow() - areaEval.getFirstRow() + 1;
        int _firstRow = areaEval.getFirstRow();
        int _lastRow = areaEval.getLastRow();
        int _nColumns = areaEval.getLastColumn() - areaEval.getFirstColumn() + 1;
        int _firstColumn = areaEval.getFirstColumn();
        if (rowOffsetIx < 0 || rowOffsetIx >= _nRows) {
            throw new IllegalArgumentException("Specified row index (" + row + ") is outside the allowed range (" + _firstRow + ".." + _lastRow + ")");
        }
        if (colOffsetIx < 0 || colOffsetIx >= _nColumns) {
            throw new IllegalArgumentException("Specified column index (" + col + ") is outside the allowed range (" + _firstColumn + ".." + col + ")");
        }
        return areaEval.getRelativeValue(rowOffsetIx, colOffsetIx);
    }
}

