/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket.server.protocol;

import coldfusion.log.CFLogs;
import coldfusion.wddx.Base64Encoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;

public class HandShakeProcessor {
    private static final String UPGRADE_STATUS_MESSAGE_OLD = "WebSocket Protocol Handshake";
    private static final String UPGRADE_STATUS_MESSAGE_NEW = "Switching Protocols";
    private static final String SEC_MAGIC_KEY = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";

    public static HttpResponse generateHandShakeResponse(ChannelHandlerContext context, HttpRequest httpRequest, int version) throws NoSuchAlgorithmException {
        String origin;
        CFLogs.WEBSOCKET_LOG.info((Object)("In begining of upgrading protocol for welcome request. The Websocket version is " + version));
        String statusMessage = version > 3 ? UPGRADE_STATUS_MESSAGE_NEW : UPGRADE_STATUS_MESSAGE_OLD;
        DefaultHttpResponse lResp = new DefaultHttpResponse(HttpVersion.HTTP_1_1, new HttpResponseStatus(101, statusMessage));
        lResp.addHeader("Upgrade", (Object)"WebSocket");
        lResp.addHeader("Connection", (Object)"Upgrade");
        String string = origin = httpRequest.containsHeader("Sec-WebSocket-Origin") ? httpRequest.getHeader("Sec-WebSocket-Origin") : httpRequest.getHeader("origin");
        if (origin != null) {
            lResp.addHeader("Sec-WebSocket-Origin", (Object)origin);
        }
        String location = "ws://" + httpRequest.getHeader("Host") + httpRequest.getUri();
        if (httpRequest.containsHeader("Sec-WebSocket-Key") && version >= 6) {
            String protocol;
            lResp.addHeader("Sec-WebSocket-Location", (Object)location);
            String string2 = protocol = httpRequest.containsHeader("Sec-WebSocket-Protocol") ? httpRequest.getHeader("Sec-WebSocket-Protocol") : httpRequest.getHeader("WebSocket-Protocol");
            if (protocol != null) {
                lResp.addHeader("WebSocket-Protocol", (Object)protocol);
            }
            String sec_key = httpRequest.getHeader("Sec-WebSocket-Key");
            sec_key = sec_key + SEC_MAGIC_KEY;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] secKeyFinal = messageDigest.digest(sec_key.getBytes());
            String finalKey = Base64Encoder.encode((byte[])secKeyFinal);
            lResp.addHeader("Sec-WebSocket-Accept", (Object)finalKey);
            httpRequest.getContent().clear();
        } else if (httpRequest.containsHeader("Sec-WebSocket-Key1") && httpRequest.containsHeader("Sec-WebSocket-Key2")) {
            lResp.addHeader("Sec-WebSocket-Location", (Object)location);
            String lProtocol = httpRequest.getHeader("Sec-WebSocket-Protocol");
            if (lProtocol != null) {
                lResp.addHeader("Sec-WebSocket-Protocol", (Object)lProtocol);
            } else {
                lProtocol = httpRequest.getHeader("WebSocket-Protocol");
                if (lProtocol != null) {
                    lResp.addHeader("Sec-WebSocket-Protocol", (Object)lProtocol);
                }
            }
            String lKey1 = httpRequest.getHeader("Sec-WebSocket-Key1");
            String lKey2 = httpRequest.getHeader("Sec-WebSocket-Key2");
            int lA = (int)(Long.parseLong(lKey1.replaceAll("[^0-9]", "")) / (long)lKey1.replaceAll("[^ ]", "").length());
            int lB = (int)(Long.parseLong(lKey2.replaceAll("[^0-9]", "")) / (long)lKey2.replaceAll("[^ ]", "").length());
            long lC = httpRequest.getContent().readLong();
            ChannelBuffer lInput = ChannelBuffers.buffer((int)16);
            lInput.writeInt(lA);
            lInput.writeInt(lB);
            lInput.writeLong(lC);
            ChannelBuffer lOutput = ChannelBuffers.wrappedBuffer((byte[])MessageDigest.getInstance("MD5").digest(lInput.array()));
            lResp.setContent(lOutput);
        } else {
            lResp.addHeader("WebSocket-Location", (Object)location);
            String protocol = httpRequest.getHeader("WebSocket-Protocol");
            if (protocol != null) {
                lResp.addHeader("WebSocket-Protocol", (Object)protocol);
            }
        }
        return lResp;
    }
}

