/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket.server.netty;

import coldfusion.tagext.net.websocket.server.protocol.RequestPacketReader;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.http.websocket.DefaultWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocket.WebSocketFrame;
import org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import org.jboss.netty.handler.codec.replay.VoidEnum;

public class WebSocketFrameDecoder
extends ReplayingDecoder<VoidEnum> {
    public static final int DEFAULT_MAX_FRAME_SIZE = 16384;
    private final int maxFrameSize;
    private boolean receivedClosingHandshake;
    private int webSocket_spec_version;

    public WebSocketFrameDecoder(int maxFrameSize, int spec_version) {
        this.maxFrameSize = maxFrameSize;
        this.webSocket_spec_version = spec_version;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, VoidEnum state) throws Exception {
        if (this.receivedClosingHandshake) {
            buffer.skipBytes(this.actualReadableBytes());
            return null;
        }
        byte type = buffer.readByte();
        if ((type & 0xFF) > 128) {
            return RequestPacketReader.readHybi_textFrame(type, buffer);
        }
        if ((type & 0x80) == 128) {
            return this.decodeBinaryFrame(type, buffer);
        }
        return RequestPacketReader.readHixie_textFrame(type, buffer, this.actualReadableBytes());
    }

    private WebSocketFrame decodeBinaryFrame(int type, ChannelBuffer buffer) throws TooLongFrameException {
        byte b;
        long frameSize = 0L;
        int lengthFieldSize = 0;
        do {
            b = buffer.readByte();
            frameSize <<= 7;
            frameSize |= (long)(b & 0x7F);
            if (++lengthFieldSize <= 8) continue;
            throw new TooLongFrameException();
        } while ((b & 0x80) == 128);
        if (type == 255 && frameSize == 0L) {
            this.receivedClosingHandshake = true;
        }
        return new DefaultWebSocketFrame(type, buffer.readBytes((int)frameSize));
    }
}

