/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket.server.core;

import coldfusion.log.CFLogs;
import coldfusion.server.ServiceFactory;
import coldfusion.server.WebSocketService;
import coldfusion.tagext.net.websocket.messaging.ChannelRequestProcessor;
import coldfusion.tagext.net.websocket.server.core.AbstractClientConnection;
import coldfusion.tagext.net.websocket.server.core.JSONTokenizer;
import coldfusion.tagext.net.websocket.server.core.TokenMap;
import org.apache.log4j.Logger;

public class WSTaskProcessor {
    private static WSTaskProcessor taskProcessor = new WSTaskProcessor();
    private static ChannelRequestProcessor channelProcessor = new ChannelRequestProcessor(taskProcessor);
    private static Logger exceptionLogger = Logger.getLogger(WSTaskProcessor.class);
    private static WebSocketService webSocketService = ServiceFactory.getWebsocketService();

    public WSTaskProcessor() {
        channelProcessor = new ChannelRequestProcessor(this);
    }

    public static WSTaskProcessor getTaskProcessor() {
        return taskProcessor;
    }

    public void processWebSocketRequest(AbstractClientConnection clientConnection, String data) {
        CFLogs.WEBSOCKET_LOG.info((Object)("WSTaskProcessor:  request Data=" + data));
        if (data.length() < 1) {
            return;
        }
        TokenMap tokens = JSONTokenizer.jsonStringToToken(data);
        if (data.length() > webSocketService.getMaxFrameSize() * 1024) {
            WSTaskProcessor.sendErrorToken(clientConnection, tokens, 4001, "'Data being received exceeds the limit defined in the Administrator.");
            return;
        }
        channelProcessor.processToken(clientConnection, tokens);
    }

    public void connectionClosed(AbstractClientConnection connection) {
        CFLogs.WEBSOCKET_LOG.info((Object)"WSTaskProcessor:  Connection is being closed");
        channelProcessor.connectorStopped(connection);
    }

    public static void sendToken(AbstractClientConnection target, TokenMap tokens) {
        try {
            String data = JSONTokenizer.tokenToJSON(tokens);
            if (data.length() > webSocketService.getMaxFrameSize() * 1024) {
                WSTaskProcessor.sendErrorToken(target, tokens, 4001, "'Data being sent exceeds the limit defined in the Administrator.'");
            }
            CFLogs.WEBSOCKET_LOG.info((Object)("WSTaskProcessor: Response being sent to clinet=" + data));
            target.writeData(data);
        }
        catch (Exception e) {
            exceptionLogger.error((Object)("Error while writting response back to client, Data=" + tokens.getMap().toString()), (Throwable)e);
        }
    }

    public static void sendErrorToken(AbstractClientConnection clientConnection, TokenMap inToken, int aErrCode, String aMessage) {
        TokenMap lResToken = WSTaskProcessor.createResponse(clientConnection.getConnectionId(), inToken);
        lResToken.setInteger("code", aErrCode);
        lResToken.put("msg", aMessage);
        CFLogs.WEBSOCKET_LOG.info((Object)("WSTaskProcessor:  Error message is being sent to client status code=" + aErrCode + " and message=" + aMessage));
        WSTaskProcessor.sendToken(clientConnection, lResToken);
    }

    public static TokenMap createResponse(String clientId, TokenMap inToken) {
        TokenMap responseToken = new TokenMap();
        String tokenId = null;
        String type = null;
        String lNS = null;
        if (inToken != null) {
            tokenId = inToken.getString("clientid");
            type = inToken.getString("type");
            lNS = inToken.getString("ns");
        }
        responseToken.setType("response");
        responseToken.setInteger("code", responseToken.getInteger("code", 0));
        responseToken.setString("msg", responseToken.getString("msg", "ok"));
        if (tokenId != null) {
            responseToken.setString("clientid", tokenId);
        } else {
            responseToken.setString("clientid", clientId);
        }
        if (lNS != null) {
            responseToken.setString("ns", lNS);
        }
        if (type != null) {
            responseToken.setString("reqType", type);
        }
        return responseToken;
    }
}

