/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.module;

import coldfusion.monitor.util.MonitoringServiceUtils;
import oshi.SystemInfo;

public class MonitoringServiceUtilsImpl
implements MonitoringServiceUtils {
    private static MonitoringServiceUtilsImpl instance = null;
    private static SystemInfo sinf = null;

    private MonitoringServiceUtilsImpl() {
    }

    public static MonitoringServiceUtilsImpl getInstance() {
        if (instance == null) {
            instance = new MonitoringServiceUtilsImpl();
        }
        return instance;
    }

    public double getSystemCPUUsage(long[] oldTicks) {
        double systemCpu = -1.0;
        if (oldTicks == null || oldTicks.length == 0) {
            oldTicks = this.getCurrentCPULoadTicks();
        }
        systemCpu = sinf.getHardware().getProcessor().getSystemCpuLoadBetweenTicks(oldTicks);
        return systemCpu;
    }

    public SystemInfo getSystemInfo() {
        if (sinf == null) {
            sinf = new SystemInfo();
        }
        return sinf;
    }

    public long[] getCurrentCPULoadTicks() {
        return this.getSystemInfo().getHardware().getProcessor().getSystemCpuLoadTicks();
    }

    public long getSystemTotalMemory() {
        return this.getSystemInfo().getHardware().getMemory().getTotal();
    }

    public long getSystemFreeMemory() {
        return this.getSystemInfo().getHardware().getMemory().getAvailable();
    }
}

