/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.firestore.impl;

import coldfusion.cloud.CloudServiceName;
import coldfusion.cloud.exception.ValidationException;
import coldfusion.cloud.gcp.firestore.FirestoreCollectionReference;
import coldfusion.cloud.gcp.firestore.FirestoreDocumentReference;
import coldfusion.cloud.gcp.firestore.codecs.FirestoreSerializer;
import coldfusion.cloud.gcp.firestore.impl.FirestoreCollectionReferenceImpl;
import coldfusion.cloud.gcp.firestore.impl.FirestoreDocumentSnapshot;
import coldfusion.cloud.gcp.firestore.pmt.util.GCPFirestoreApis;
import coldfusion.cloud.gcp.firestore.pmt.util.PMTUtilForGCPFirestore;
import coldfusion.cloud.gcp.firestore.util.CallBackExecutor;
import coldfusion.cloud.gcp.firestore.util.FirestoreUtils;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.filter.FusionContext;
import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.runtime.Array;
import coldfusion.runtime.JSONUtils;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.async.Future;
import coldfusion.util.RB;
import com.google.cloud.firestore.CollectionReference;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.FieldMask;
import com.google.cloud.firestore.ListenerRegistration;
import com.google.cloud.firestore.Precondition;
import com.google.cloud.firestore.SetOptions;
import java.util.Map;
import java.util.Objects;

public class FirestoreDocumentReferenceImpl
implements FirestoreDocumentReference {
    private final DocumentReference reference;
    private TagAttributeList tagAttributeList = new TagAttributeList("service", (Object)CloudServiceName.FIRESTORE.name());

    public FirestoreDocumentReferenceImpl(DocumentReference documentReference) {
        this.reference = documentReference;
        this.tagAttributeList.addTagAttribute("document", (Object)this.reference.getId());
    }

    DocumentReference getReference() {
        return this.reference;
    }

    @Override
    public String getId() {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.getId, this.tagAttributeList);
        String status = "Success";
        try {
            String string = this.reference.getId();
            return string;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.getId, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public String getPath() {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.getPath, this.tagAttributeList);
        String status = "Success";
        try {
            String string = this.reference.getPath();
            return string;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.getId, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public FirestoreCollectionReference getParent() {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.getParent, this.tagAttributeList);
        String status = "Success";
        try {
            FirestoreCollectionReferenceImpl firestoreCollectionReferenceImpl = new FirestoreCollectionReferenceImpl(this.reference.getParent());
            return firestoreCollectionReferenceImpl;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.getParent, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public FirestoreCollectionReference collection(String path) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.collection, this.tagAttributeList);
        String status = "Success";
        try {
            if (FirestoreUtils.isNullOrEmpty(path)) {
                throw new ValidationException(RB.getString(FirestoreDocumentReferenceImpl.class, (String)"COLLECTION_PATH_NULL_EMPTY"));
            }
            FirestoreCollectionReferenceImpl firestoreCollectionReferenceImpl = new FirestoreCollectionReferenceImpl(this.reference.collection(path));
            return firestoreCollectionReferenceImpl;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.collection, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public Future create(Map<?, ?> data) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.create, this.tagAttributeList);
        String status = "Success";
        try {
            FirestoreUtils.validateDocumentData(data, "create");
            if (data instanceof TemplateProxy) {
                data = JSONUtils.getCFCDataAsMap((TemplateProxy)((TemplateProxy)data));
            }
            Future future = new Future((java.util.concurrent.Future)this.reference.create(FirestoreSerializer.serializeMap(FieldTypecastUtil.INSTANCE.getStringObjectMapProperty((Object)data))), FirestoreUtils.getWriteResultConverter());
            return future;
        }
        catch (IllegalArgumentException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(RB.getString(FirestoreDocumentReferenceImpl.class, (String)"PROVIDED_INCORRECT_INPUT", (Object)"create"), e);
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.create, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap("post", status));
        }
    }

    @Override
    public Future set(Map<?, ?> data) {
        return this.set(data, false);
    }

    @Override
    public Future set(Map<?, ?> data, boolean merge) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.set, this.tagAttributeList);
        String status = "Success";
        try {
            FirestoreUtils.validateDocumentData(data, "set");
            if (data instanceof TemplateProxy) {
                data = JSONUtils.getCFCDataAsMap((TemplateProxy)((TemplateProxy)data));
            }
            if (merge) {
                Future future = new Future((java.util.concurrent.Future)this.reference.set(FirestoreSerializer.serializeMap(FieldTypecastUtil.INSTANCE.getStringObjectMapProperty((Object)data)), SetOptions.merge()), FirestoreUtils.getWriteResultConverter());
                return future;
            }
            Future future = new Future((java.util.concurrent.Future)this.reference.set(FirestoreSerializer.serializeMap(FieldTypecastUtil.INSTANCE.getStringObjectMapProperty((Object)data))), FirestoreUtils.getWriteResultConverter());
            return future;
        }
        catch (IllegalArgumentException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(RB.getString(FirestoreDocumentReferenceImpl.class, (String)"PROVIDED_INCORRECT_INPUT", (Object)"set"), e);
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.set, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap("put", status));
        }
    }

    @Override
    public Future getDocument() {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.getDocument, this.tagAttributeList);
        String status = "Success";
        try {
            Future future = new Future((java.util.concurrent.Future)this.reference.get(), FirestoreUtils.getDocumentSnapshotStruct());
            return future;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.getDocument, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap("get", status));
        }
    }

    @Override
    public Future getDocument(Array mask) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.getDocument, this.tagAttributeList);
        String status = "Success";
        try {
            FieldMask fieldMask = FirestoreUtils.getFieldMask(mask);
            Future future = new Future((java.util.concurrent.Future)this.reference.get(fieldMask), FirestoreUtils.getDocumentSnapshotStruct());
            return future;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.getDocument, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap("get", status));
        }
    }

    @Override
    public Array listCollections() {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.listCollections, this.tagAttributeList);
        String status = "Success";
        try {
            Array result = new Array();
            this.reference.listCollections().forEach(colRef -> result.addElement((Object)new FirestoreCollectionReferenceImpl((CollectionReference)colRef)));
            Array array = result;
            return array;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.listCollections, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap("get", status));
        }
    }

    @Override
    public Future update(Map<?, ?> fields) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.update, this.tagAttributeList);
        String status = "Success";
        try {
            FirestoreUtils.validateDocumentData(fields, "update");
            Future future = new Future((java.util.concurrent.Future)this.reference.update(FirestoreSerializer.serializeMap(FieldTypecastUtil.INSTANCE.getStringObjectMapProperty(fields))), FirestoreUtils.getWriteResultConverter());
            return future;
        }
        catch (IllegalArgumentException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(RB.getString(FirestoreDocumentReferenceImpl.class, (String)"PROVIDED_INCORRECT_INPUT", (Object)"update"), e);
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.update, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap("put", status));
        }
    }

    @Override
    public Future update(Map<?, ?> fields, OleDateTime timestamp) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.update, this.tagAttributeList);
        String status = "Success";
        try {
            FirestoreUtils.validateDocumentData(fields, "update");
            Precondition precondition = FirestoreUtils.getPrecondition(timestamp);
            Future future = new Future((java.util.concurrent.Future)this.reference.update(FirestoreSerializer.serializeMap(FieldTypecastUtil.INSTANCE.getStringObjectMapProperty(fields)), precondition), FirestoreUtils.getWriteResultConverter());
            return future;
        }
        catch (IllegalArgumentException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(RB.getString(FirestoreDocumentReferenceImpl.class, (String)"PROVIDED_INCORRECT_INPUT", (Object)"update"), e);
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.update, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap("put", status));
        }
    }

    @Override
    public Future delete() {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.delete, this.tagAttributeList);
        String status = "Success";
        try {
            Future future = new Future((java.util.concurrent.Future)this.reference.delete(), FirestoreUtils.getWriteResultConverter());
            return future;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.delete, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap("delete", status));
        }
    }

    @Override
    public Future delete(OleDateTime timestamp) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.delete, this.tagAttributeList);
        String status = "Success";
        try {
            Precondition precondition = FirestoreUtils.getPrecondition(timestamp);
            Future future = new Future((java.util.concurrent.Future)this.reference.delete(precondition), FirestoreUtils.getWriteResultConverter());
            return future;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.delete, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap("delete", status));
        }
    }

    @Override
    public ListenerRegistration addSnapshotListener(UDFMethod onSuccess, UDFMethod onFailure) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.addSnapshotListener, this.tagAttributeList);
        String status = "Success";
        try {
            if (Objects.isNull(onSuccess)) {
                status = "Failure";
                throw new ValidationException(RB.getString(FirestoreDocumentReferenceImpl.class, (String)"SUCCESS_METHOD_NULL"));
            }
            if (Objects.isNull(onFailure)) {
                status = "Failure";
                throw new ValidationException(RB.getString(FirestoreDocumentReferenceImpl.class, (String)"FAILURE_METHOD_NULL"));
            }
            CallBackExecutor successHandler = new CallBackExecutor(onSuccess, FusionContext.getCurrent(), FusionContext.getCurrent().pageContext, RequestMonitorData.getCurrent());
            CallBackExecutor failureHandler = new CallBackExecutor(onFailure, FusionContext.getCurrent(), FusionContext.getCurrent().pageContext, RequestMonitorData.getCurrent());
            ListenerRegistration listenerRegistration = this.reference.addSnapshotListener((documentSnapshot, firestoreException) -> {
                Object[] args = new Object[1];
                if (documentSnapshot != null) {
                    args[0] = new FirestoreDocumentSnapshot((DocumentSnapshot)documentSnapshot);
                    successHandler.execute(args);
                } else if (firestoreException != null) {
                    args[0] = FirestoreUtils.HandleFirestoreException(firestoreException.getMessage(), (Throwable)firestoreException);
                    failureHandler.execute(args);
                }
            });
            return listenerRegistration;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.addSnapshotListener, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap("get", status));
        }
    }
}

