/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.firestore.impl;

import coldfusion.cloud.CloudServiceName;
import coldfusion.cloud.exception.ValidationException;
import coldfusion.cloud.gcp.GCPCredential;
import coldfusion.cloud.gcp.firestore.FirestoreClient;
import coldfusion.cloud.gcp.firestore.FirestoreCollectionGroup;
import coldfusion.cloud.gcp.firestore.FirestoreCollectionReference;
import coldfusion.cloud.gcp.firestore.FirestoreDocumentReference;
import coldfusion.cloud.gcp.firestore.FirestoreWriteBatch;
import coldfusion.cloud.gcp.firestore.GCPCredentialValidator;
import coldfusion.cloud.gcp.firestore.config.FirestoreConfig;
import coldfusion.cloud.gcp.firestore.exception.GCPFirestoreException;
import coldfusion.cloud.gcp.firestore.impl.FirestoreCollectionGroupImpl;
import coldfusion.cloud.gcp.firestore.impl.FirestoreCollectionReferenceImpl;
import coldfusion.cloud.gcp.firestore.impl.FirestoreDocumentReferenceImpl;
import coldfusion.cloud.gcp.firestore.impl.FirestoreTransactionImpl;
import coldfusion.cloud.gcp.firestore.impl.FirestoreWriteBatchImpl;
import coldfusion.cloud.gcp.firestore.pmt.util.GCPFirestoreApis;
import coldfusion.cloud.gcp.firestore.pmt.util.PMTUtilForGCPFirestore;
import coldfusion.cloud.gcp.firestore.util.CallBackExecutor;
import coldfusion.cloud.gcp.firestore.util.FirestoreUtils;
import coldfusion.filter.FusionContext;
import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.runtime.Array;
import coldfusion.runtime.GenerateCFInvoke;
import coldfusion.runtime.GenerateCFNamedInvoke;
import coldfusion.runtime.MethodUnsupportedParameterException;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.async.Future;
import coldfusion.util.RB;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.firestore.CollectionGroup;
import com.google.cloud.firestore.CollectionReference;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.TransactionOptions;
import java.security.AccessController;
import java.util.Objects;

@GenerateCFInvoke
@GenerateCFNamedInvoke
public class FirestoreClientImpl
implements FirestoreClient {
    private final Firestore firestoreClient;
    private TagAttributeList tagAttributeList = new TagAttributeList("service", (Object)CloudServiceName.FIRESTORE.name());

    public FirestoreClientImpl(GCPCredential credential, FirestoreConfig config) {
        try {
            GCPCredentialValidator credentialValidator = new GCPCredentialValidator(credential);
            GoogleCredentials gcpCredentials = credentialValidator.getGcpCredentials();
            this.firestoreClient = System.getSecurityManager() == null ? (Firestore)((FirestoreOptions.Builder)config.getFirestoreOptions().setCredentials((Credentials)gcpCredentials)).build().getService() : AccessController.doPrivileged(() -> (Firestore)((FirestoreOptions.Builder)config.getFirestoreOptions().setCredentials((Credentials)gcpCredentials)).build().getService());
        }
        catch (RuntimeException e) {
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
    }

    @Override
    public FirestoreWriteBatch batch() {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.batch, this.tagAttributeList);
        String status = "Success";
        try {
            FirestoreWriteBatchImpl firestoreWriteBatchImpl = new FirestoreWriteBatchImpl(this.firestoreClient.batch());
            return firestoreWriteBatchImpl;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.batch, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(null, status));
        }
    }

    @Override
    public FirestoreCollectionReference collection(String path) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.collection, this.tagAttributeList);
        String status = "Success";
        try {
            if (FirestoreUtils.isNullOrEmpty(path)) {
                status = "Failure";
                throw new ValidationException(RB.getString(FirestoreClientImpl.class, (String)"COLLECTION_PATH_NULL_EMPTY"));
            }
            CollectionReference collectionReference = this.firestoreClient.collection(path);
            FirestoreCollectionReferenceImpl firestoreCollectionReferenceImpl = new FirestoreCollectionReferenceImpl(collectionReference);
            return firestoreCollectionReferenceImpl;
        }
        catch (IllegalArgumentException e) {
            status = "Failure";
            throw new GCPFirestoreException(RB.getString(FirestoreClientImpl.class, (String)"INVALID_COLLECTION_PATH", (Object)e.getMessage()), e);
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.collection, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public FirestoreCollectionGroup collectionGroup(String id) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.collectionGroup, this.tagAttributeList);
        String status = "Success";
        try {
            if (FirestoreUtils.isNullOrEmpty(id)) {
                status = "Failure";
                throw new ValidationException(RB.getString(FirestoreClientImpl.class, (String)"COLLECTION_GROUP_ID_NULL_EMPTY"));
            }
            CollectionGroup collectionGroup = this.firestoreClient.collectionGroup(id);
            FirestoreCollectionGroupImpl firestoreCollectionGroupImpl = new FirestoreCollectionGroupImpl(collectionGroup);
            return firestoreCollectionGroupImpl;
        }
        catch (IllegalArgumentException e) {
            status = "Failure";
            throw new GCPFirestoreException(RB.getString(FirestoreClientImpl.class, (String)"INVALID_COLLECTION_GROUP_ID", (Object)e.getMessage()), e);
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.collectionGroup, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public FirestoreDocumentReference document(String path) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.document, this.tagAttributeList);
        String status = "Success";
        try {
            if (FirestoreUtils.isNullOrEmpty(path)) {
                status = "Failure";
                throw new ValidationException(RB.getString(FirestoreClientImpl.class, (String)"DOCUMENT_PATH_NULL_EMPTY"));
            }
            DocumentReference documentReference = this.firestoreClient.document(path);
            FirestoreDocumentReferenceImpl firestoreDocumentReferenceImpl = new FirestoreDocumentReferenceImpl(documentReference);
            return firestoreDocumentReferenceImpl;
        }
        catch (IllegalArgumentException e) {
            status = "Failure";
            throw new GCPFirestoreException(RB.getString(FirestoreClientImpl.class, (String)"INVALID_DOCUMENT_PATH", (Object)e.getMessage()), e);
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.document, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    private DocumentReference[] getReferencesArray(Array documentReferences) {
        if (Objects.nonNull(documentReferences)) {
            DocumentReference[] referencesArray = new DocumentReference[documentReferences.size()];
            for (int i = 0; i < documentReferences.size(); ++i) {
                if (!(documentReferences.get(i) instanceof FirestoreDocumentReferenceImpl)) {
                    throw new MethodUnsupportedParameterException("first", "getAll", "document references but found something else at index " + i);
                }
                referencesArray[i] = ((FirestoreDocumentReferenceImpl)documentReferences.get(i)).getReference();
            }
            return referencesArray;
        }
        throw new ValidationException(RB.getString(FirestoreClientImpl.class, (String)"DOCUMENT_REFERENCES_NULL"));
    }

    @Override
    public Future getAll(Array documentReferences) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.getAll, this.tagAttributeList);
        String status = "Success";
        try {
            DocumentReference[] referencesArray = this.getReferencesArray(documentReferences);
            Future future = new Future((java.util.concurrent.Future)this.firestoreClient.getAll(referencesArray), FirestoreUtils.documentSnapshotList());
            return future;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.getAll, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap("get", status));
        }
    }

    @Override
    public Future getAll(Array documentReferences, Array fieldMask) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.getAll, this.tagAttributeList);
        String status = "Success";
        try {
            DocumentReference[] referencesArray = this.getReferencesArray(documentReferences);
            Future future = new Future((java.util.concurrent.Future)this.firestoreClient.getAll(referencesArray, FirestoreUtils.getFieldMask(fieldMask)), FirestoreUtils.documentSnapshotList());
            return future;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.getAll, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap("get", status));
        }
    }

    @Override
    public Array listCollections() {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.listCollections, this.tagAttributeList);
        String status = "Success";
        try {
            Array result = new Array();
            this.firestoreClient.listCollections().forEach(colRef -> result.addElement((Object)new FirestoreCollectionReferenceImpl((CollectionReference)colRef)));
            Array array = result;
            return array;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.listCollections, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap("get", status));
        }
    }

    private Future executeTransaction(UDFMethod updateFunction, TransactionOptions transactionOptions) {
        CallBackExecutor transactionHandler = new CallBackExecutor(updateFunction, FusionContext.getCurrent(), FusionContext.getCurrent().pageContext, RequestMonitorData.getCurrent());
        return new Future((java.util.concurrent.Future)this.firestoreClient.runTransaction(transaction -> {
            FirestoreTransactionImpl cfTransaction = new FirestoreTransactionImpl(transaction);
            Object[] args = new Object[]{cfTransaction};
            return transactionHandler.execute(args).get();
        }, transactionOptions));
    }

    @Override
    public Future runTransaction(UDFMethod updateFunction) {
        return this.runTransaction(updateFunction, TransactionOptions.createReadWriteOptionsBuilder().getNumberOfAttempts());
    }

    @Override
    public Future runTransaction(UDFMethod updateFunction, int retryAttempts) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.runTransaction, this.tagAttributeList);
        String status = "Success";
        try {
            if (Objects.nonNull(updateFunction)) {
                Future future = this.executeTransaction(updateFunction, TransactionOptions.createReadWriteOptionsBuilder().setNumberOfAttempts(retryAttempts).build());
                return future;
            }
            try {
                status = "Failure";
                throw new ValidationException(RB.getString(FirestoreClientImpl.class, (String)"TRANSACTION_FUNCTION_NULL"));
            }
            catch (RuntimeException e) {
                status = "Failure";
                throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
            }
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.runTransaction, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap("put", status));
        }
    }
}

