/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.exchange;

import coldfusion.exchange.MessageFilterInfo;
import coldfusion.runtime.Cast;
import coldfusion.tagext.net.exchange.ExchangeExceptions;
import coldfusion.tagext.net.exchange.ExchangeFilterable;
import coldfusion.tagext.net.exchange.ExchangeTag;
import coldfusion.tagext.net.exchange.MailConstants;
import coldfusion.tagext.net.exchange.MailTagHelper;
import coldfusion.tagext.validation.RequiredAttributesException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

public class ExchangeMailTag
extends ExchangeTag
implements ExchangeFilterable,
MailConstants {
    private static HashMap validFilterAttributes = new HashMap();
    private static HashMap validMessageAttributes = new HashMap();
    MessageFilterInfo filterInfo = new MessageFilterInfo();
    private Map message = null;
    private String folder = null;
    private String folderId = null;
    private String meetingUID = null;
    private String mailUID = null;
    private String destinationFolder = null;
    private boolean getHeaders = false;

    PageContext getPageContext() {
        return this.pageContext;
    }

    public Map getMessage() {
        return this.message;
    }

    public void setGetHeaders(boolean getHeaders) {
        this.getHeaders = getHeaders;
    }

    public boolean getGetHeaders() {
        return this.getHeaders;
    }

    public void setDestinationFolder(String folderName) {
        this.destinationFolder = folderName;
    }

    public String getDestinationFolder() {
        return this.destinationFolder;
    }

    public void setMessage(Map msg) {
        this.validateStruct(msg, validMessageAttributes, "cfexchangemail", "message");
        this.message = msg;
    }

    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public String getFolderId() {
        return this.folderId;
    }

    public void setFolderId(String folderId) {
        this.folderId = folderId;
    }

    public String getMeetingUID() {
        return this.meetingUID;
    }

    public void setMeetingUID(String meetingUID) {
        this.meetingUID = meetingUID;
    }

    public String getMailUID() {
        return this.mailUID;
    }

    public void setMailUID(String mailUID) {
        this.mailUID = mailUID;
    }

    MessageFilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    @Override
    public void addFilter(String attribName, HashMap values) {
        if (!this.isValidAttributeKey(attribName, validFilterAttributes)) {
            ExchangeExceptions.throwInvalidFilterAttributeKeyException(attribName, "cfexchangemail");
        }
        Object value = values.get("value");
        Date fromDate = null;
        Date toDate = null;
        if (attribName.equalsIgnoreCase("TimeReceived")) {
            if (values.containsKey("from")) {
                fromDate = Cast._Date(values.get("from"));
            }
            if (values.containsKey("to")) {
                toDate = Cast._Date(values.get("to"));
            }
            if (fromDate != null || toDate != null) {
                this.filterInfo.setFromTimeReceived(fromDate);
                this.filterInfo.setToTimeReceived(toDate);
            } else {
                if (value != null) {
                    ExchangeExceptions.throwInvalidFilterAttributesForDateExcpetion();
                }
                ExchangeExceptions.throwInvalidAttributeValueException("TimeReceived");
            }
            return;
        }
        if (attribName.equalsIgnoreCase("TimeSent")) {
            if (values.containsKey("from")) {
                fromDate = Cast._Date(values.get("from"));
            }
            if (values.containsKey("to")) {
                toDate = Cast._Date(values.get("to"));
            }
            if (fromDate != null || toDate != null) {
                this.filterInfo.setFromTimeSent(fromDate);
                this.filterInfo.setToTimeSent(toDate);
            } else {
                if (value != null) {
                    ExchangeExceptions.throwInvalidFilterAttributesForDateExcpetion();
                }
                ExchangeExceptions.throwInvalidAttributeValueException("TimeSent");
            }
            return;
        }
        if (attribName.equalsIgnoreCase("lastModified")) {
            if (values.containsKey("from")) {
                fromDate = ExchangeTag.castDate(values.get("from"), "from");
            }
            if (values.containsKey("to")) {
                toDate = ExchangeTag.castDate(values.get("to"), "to");
            }
            if (fromDate != null && toDate != null && toDate.compareTo(fromDate) < 0) {
                ExchangeExceptions.throwInvalidStartEndTimeException();
            }
            if (fromDate != null || toDate != null) {
                this.filterInfo.setFromLastModifiedDate(fromDate);
                this.filterInfo.setToLastModifiedDate(toDate);
            } else {
                if (value != null) {
                    ExchangeExceptions.throwInvalidFilterAttributesForDateExcpetion();
                }
                ExchangeExceptions.throwInvalidAttributeValueException("lastModified");
            }
            return;
        }
        if (value == null || value.toString().length() == 0) {
            ExchangeExceptions.throwEmptyAttributeValueException(attribName);
        }
        if (!(value instanceof String)) {
            ExchangeExceptions.throwInvalidStringValueException(attribName);
        }
        if (attribName.equalsIgnoreCase("MaxRows")) {
            int tmpInt = ExchangeTag.castInt(value, "MaxRows");
            if (tmpInt <= 0 && tmpInt != -1) {
                ExchangeExceptions.throwNonPositiveValueException("MaxRows");
            }
            this.filterInfo.setMaxRows(new Integer(tmpInt));
        } else if (attribName.equalsIgnoreCase("FromId")) {
            this.filterInfo.setFromId(value.toString());
        } else if (attribName.equalsIgnoreCase("ToId")) {
            this.filterInfo.setToId(value.toString());
        } else if (attribName.equalsIgnoreCase("Importance")) {
            if (!this.validateImportance(value.toString())) {
                ExchangeExceptions.throwInvalidImportanceException("Importance");
            }
            this.filterInfo.setImportance(value.toString());
        } else if (attribName.equalsIgnoreCase("Sensitivity")) {
            if (!this.validateSensitivity(value.toString())) {
                ExchangeExceptions.throwInvalidSensitivityException("Sensitivity");
            }
            this.filterInfo.setSensitivity(value.toString());
        } else if (attribName.equalsIgnoreCase("HasAttachment")) {
            this.filterInfo.setHasAttachment(Cast._boolean((String)value.toString()));
        } else if (attribName.equalsIgnoreCase("Subject")) {
            this.filterInfo.setSubject(value.toString());
        } else if (attribName.equalsIgnoreCase("Message")) {
            this.filterInfo.setMessage(value.toString());
        } else if (attribName.equalsIgnoreCase("IsRead")) {
            this.filterInfo.setRead(Cast._boolean((String)value.toString()));
        } else if (attribName.equalsIgnoreCase("Folder")) {
            this.filterInfo.setFolder(value.toString());
        } else if (attribName.equalsIgnoreCase("FolderId")) {
            this.filterInfo.setFolderId(value.toString());
        } else if (attribName.equalsIgnoreCase("uid")) {
            if (value == null || value.toString().trim().length() == 0) {
                ExchangeExceptions.throwInvalidAttributeValueException("uid");
            }
            this.filterInfo.setId(value.toString());
        } else if (attribName.equalsIgnoreCase("MessageType")) {
            String strValue;
            if (value == null || value.toString().trim().length() == 0) {
                ExchangeExceptions.throwInvalidAttributeValueException("MessageType");
            }
            if ((strValue = value.toString().trim()).equalsIgnoreCase("Mail")) {
                this.filterInfo.setMessageType(1);
            } else if (strValue.equalsIgnoreCase("Meeting")) {
                this.filterInfo.setMessageType(2);
            } else if (strValue.equalsIgnoreCase("Meeting_Request")) {
                this.filterInfo.setMessageType(3);
            } else if (strValue.equalsIgnoreCase("Meeting_Response")) {
                this.filterInfo.setMessageType(4);
            } else if (strValue.equalsIgnoreCase("Meeting_Cancel")) {
                this.filterInfo.setMessageType(5);
            } else if (!strValue.equalsIgnoreCase("ALL")) {
                ExchangeExceptions.throwInvalidMessageTypeException(attribName);
            }
        }
    }

    @Override
    public int doStartTag() throws JspException {
        super.doStartTag();
        this.onTagStart();
        return 6;
    }

    @Override
    public int doEndTag() throws JspException {
        super.doEndTag();
        if (this.action.equalsIgnoreCase("get")) {
            if (this.getName() == null) {
                throw new RequiredAttributesException(this.getTagPublicName(), "name");
            }
            if (this.getName().trim().length() == 0) {
                ExchangeExceptions.throwInvalidAttributeValueException("name");
            }
            MailTagHelper.getMessages(this);
        } else if (this.action.equalsIgnoreCase("delete")) {
            MailTagHelper.deleteMessages(this);
        } else if (this.action.equalsIgnoreCase("getAttachments")) {
            this.getAttachments(4);
        } else if (this.action.equalsIgnoreCase("set")) {
            if (this.getMessage() == null) {
                throw new RequiredAttributesException(this.getTagPublicName(), "Message");
            }
            MailTagHelper.saveMail(this, this.getMessage(), false);
        } else if (this.action.equalsIgnoreCase("getMeetingInfo")) {
            if (this.getName() == null) {
                throw new RequiredAttributesException(this.getTagPublicName(), "name");
            }
            if (this.getMeetingUID() == null) {
                throw new RequiredAttributesException(this.getTagPublicName(), "MeetingUID");
            }
            MailTagHelper.getMeetingInfo(this, this.getMeetingUID(), this.getMailUID());
        } else if (this.action.equalsIgnoreCase("move")) {
            if (this.getDestinationFolder() == null) {
                throw new RequiredAttributesException(this.getTagPublicName(), "DestinationFolder");
            }
            MailTagHelper.moveMailMessages(this);
        } else if (this.action.equalsIgnoreCase("deleteAttachments")) {
            this.deleteAttachments(4);
        }
        this.release();
        this.onTagEnd();
        return 6;
    }

    @Override
    public void release() {
        super.release();
        this.filterInfo = new MessageFilterInfo();
        this.message = null;
        this.folder = null;
        this.folderId = null;
        this.meetingUID = null;
        this.mailUID = null;
        this.destinationFolder = null;
    }

    static {
        validMessageAttributes.put("Sensitivity".toUpperCase(), "Sensitivity".toUpperCase());
        validMessageAttributes.put("Importance".toUpperCase(), "Importance".toUpperCase());
        validMessageAttributes.put("IsRead".toUpperCase(), "IsRead".toUpperCase());
        validFilterAttributes.put("TimeReceived".toUpperCase(), "TimeReceived".toUpperCase());
        validFilterAttributes.put("from".toUpperCase(), "from".toUpperCase());
        validFilterAttributes.put("to".toUpperCase(), "to".toUpperCase());
        validFilterAttributes.put("TimeReceived".toUpperCase(), "TimeReceived".toUpperCase());
        validFilterAttributes.put("TimeSent".toUpperCase(), "TimeSent".toUpperCase());
        validFilterAttributes.put("value".toUpperCase(), "value".toUpperCase());
        validFilterAttributes.put("MaxRows".toUpperCase(), "MaxRows".toUpperCase());
        validFilterAttributes.put("FromId".toUpperCase(), "FromId".toUpperCase());
        validFilterAttributes.put("ToId".toUpperCase(), "ToId".toUpperCase());
        validFilterAttributes.put("Importance".toUpperCase(), "Importance".toUpperCase());
        validFilterAttributes.put("Sensitivity".toUpperCase(), "Sensitivity".toUpperCase());
        validFilterAttributes.put("HasAttachment".toUpperCase(), "HasAttachment".toUpperCase());
        validFilterAttributes.put("Subject".toUpperCase(), "Subject".toUpperCase());
        validFilterAttributes.put("Message".toUpperCase(), "Message".toUpperCase());
        validFilterAttributes.put("IsRead".toUpperCase(), "IsRead".toUpperCase());
        validFilterAttributes.put("Folder".toUpperCase(), "Folder".toUpperCase());
        validFilterAttributes.put("FolderId".toUpperCase(), "FolderId".toUpperCase());
        validFilterAttributes.put("uid".toUpperCase(), "uid".toUpperCase());
        validFilterAttributes.put("BCC".toUpperCase(), "BCC".toUpperCase());
        validFilterAttributes.put("CC".toUpperCase(), "CC".toUpperCase());
        validFilterAttributes.put("MessageType".toUpperCase(), "MessageType".toUpperCase());
        validFilterAttributes.put("lastModified".toUpperCase(), "lastModified".toUpperCase());
    }
}

