/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.exchange;

import coldfusion.exchange.ExchangeAppointment;
import coldfusion.runtime.CFPage;
import coldfusion.sql.QueryTable;
import coldfusion.tagext.net.exchange.CalendarConstants;
import coldfusion.tagext.net.exchange.CalendarQueryMetaData;
import coldfusion.tagext.net.exchange.CalendarTagHelper;
import java.util.ArrayList;

public class CalendarQuery
extends QueryTable
implements CalendarConstants {
    public static final String DEFAULT_IMPORTANCE = "Normal";

    public void populate(ArrayList resultArray) {
        this.meta = new CalendarQueryMetaData();
        this.col_count = this.meta.getColumnCount();
        this.col_names = this.meta.getColumnLabels();
        if (resultArray == null || resultArray.size() == 0) {
            this.row_count = 0;
            return;
        }
        this.ensureCapacity(resultArray.size());
        String importance = null;
        for (ExchangeAppointment apt : resultArray) {
            Object[] colData = new Object[this.col_count];
            colData[0] = apt.getStartTime() != null ? CFPage.CreateODBCDateTime((Object)apt.getStartTime()) : null;
            colData[1] = apt.getEndTime() != null ? CFPage.CreateODBCDateTime((Object)apt.getEndTime()) : null;
            colData[2] = apt.getFromId();
            colData[3] = apt.getRequiredAttendees();
            colData[4] = apt.getOptionalAttendees();
            colData[5] = apt.getDuration();
            colData[6] = apt.getSubject();
            colData[7] = apt.getMessage();
            colData[8] = apt.getHtmlMessage();
            colData[9] = apt.getLocation();
            colData[10] = apt.getResources();
            colData[11] = apt.isAllDay();
            colData[12] = apt.getSensitivity();
            colData[13] = apt.getOrganizer();
            colData[14] = apt.isHasAttachment();
            colData[15] = apt.isRecurringSeries();
            colData[16] = apt.getId();
            importance = apt.getImportance();
            colData[17] = importance == null || importance.length() == 0 ? DEFAULT_IMPORTANCE : importance;
            colData[18] = apt.getReminderPeriod();
            colData[19] = apt.getCategories();
            colData[20] = apt.getLabel() != null ? CalendarTagHelper.getLabelDesc(apt.getLabel()) : null;
            colData[21] = apt.getLastModified() != null ? CFPage.CreateODBCDateTime((Object)apt.getLastModified()) : null;
            colData[22] = apt.getRecurrenceId();
            colData[23] = apt.getRecurrenceIdRange();
            this.addRow(colData);
        }
    }
}

