/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.exchange;

import coldfusion.exchange.AppointmentFilterInfo;
import coldfusion.exchange.ContactFilterInfo;
import coldfusion.exchange.DeleteType;
import coldfusion.exchange.ExchangeAppointment;
import coldfusion.exchange.ExchangeContact;
import coldfusion.exchange.ExchangeFolder;
import coldfusion.exchange.ExchangeFolderExtendedInfo;
import coldfusion.exchange.ExchangeLoginInfo;
import coldfusion.exchange.ExchangeMessage;
import coldfusion.exchange.ExchangeTask;
import coldfusion.exchange.FolderFilterInfo;
import coldfusion.exchange.MessageFilterInfo;
import coldfusion.exchange.TaskFilterInfo;
import coldfusion.exchange.webservice.AvailabilityData;
import coldfusion.exchange.webservice.CFConversationFilter;
import coldfusion.exchange.webservice.CFUserAvailability;
import coldfusion.exchange.webservice.EmailAddress;
import coldfusion.runtime.Struct;
import coldfusion.util.CFDumpable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;

public abstract class ExchangeConnection
implements CFDumpable {
    public static final char dotSeperator = '.';
    public static final char commaSeperator = ',';
    public static final String CALENDAR_FOLDER_CLASS = "IPF.Appointment";
    protected ExchangeLoginInfo loginInfo;

    public ExchangeConnection(ExchangeLoginInfo loginInfo) {
        this.loginInfo = loginInfo;
    }

    public abstract void closeConnection();

    public abstract void login() throws Throwable;

    public abstract void logoff();

    public abstract ArrayList getAppointments(AppointmentFilterInfo var1) throws Throwable;

    public abstract ArrayList getAppointmentOccurences(AppointmentFilterInfo var1) throws Throwable;

    public abstract void createAppointment(ExchangeAppointment var1, boolean var2) throws Throwable;

    public abstract void deleteAppointments(String[] var1, boolean var2, String var3) throws Throwable;

    public abstract void modifyAppointments(AppointmentFilterInfo var1, String[] var2, ExchangeAppointment var3, String[] var4, Object[] var5, boolean var6) throws Throwable;

    public abstract void modifyAppointment(AppointmentFilterInfo var1, ExchangeAppointment var2, boolean var3) throws Throwable;

    public abstract void deleteAppointment(String var1) throws Throwable;

    public abstract void createAppointment(ExchangeAppointment var1, String[] var2, Object[] var3, boolean var4) throws Throwable;

    public abstract void modifyAppointment(AppointmentFilterInfo var1, ExchangeAppointment var2, String[] var3, Object[] var4, boolean var5) throws Throwable;

    public abstract ArrayList getAppointmentAttachments(String var1, boolean var2) throws Throwable;

    public abstract void deleteAppointmentAttachments(String var1, String[] var2) throws Throwable;

    public abstract ArrayList getContacts(ContactFilterInfo var1) throws Throwable;

    public abstract void createContact(ExchangeContact var1) throws Throwable;

    public abstract void modifyContacts(String[] var1, ExchangeContact var2) throws Throwable;

    public abstract void deleteContacts(String[] var1) throws Throwable;

    public ExchangeLoginInfo getLoginInfo() {
        return this.loginInfo;
    }

    public void setLoginInfo(ExchangeLoginInfo loginInfo) {
        this.loginInfo = loginInfo;
    }

    public abstract void responseToMeetingRequest(String var1, int var2, boolean var3, String var4) throws Throwable;

    public abstract void addContactAttachments(String var1, String[] var2, Object[] var3) throws Throwable;

    public abstract ArrayList getContactAttachments(String var1, boolean var2) throws Throwable;

    public abstract void deleteContactAttachments(String var1, String[] var2) throws Throwable;

    public abstract void modifyContact(ExchangeContact var1, String[] var2, Object[] var3) throws Throwable;

    public abstract void createContact(ExchangeContact var1, String[] var2, Object[] var3) throws Throwable;

    public abstract ArrayList getTasks(TaskFilterInfo var1) throws Throwable;

    public abstract void modifyTask(ExchangeTask var1) throws Throwable;

    public abstract void modifyTask(ExchangeTask var1, String[] var2, Object[] var3) throws Throwable;

    public abstract void createTask(ExchangeTask var1) throws Throwable;

    public abstract void createTask(ExchangeTask var1, String[] var2, Object[] var3) throws Throwable;

    public abstract void deleteTasks(String[] var1) throws Throwable;

    public abstract void addTaskAttachments(String var1, String[] var2, Object[] var3) throws Throwable;

    public abstract ArrayList getTaskAttachments(String var1, boolean var2) throws Throwable;

    public abstract void deleteTaskAttachments(String var1, String[] var2) throws Throwable;

    public abstract ArrayList getMessages(MessageFilterInfo var1) throws Throwable;

    public abstract void createMessage(ExchangeMessage var1, String[] var2, Object[] var3) throws Throwable;

    public abstract void modifyMessage(ExchangeMessage var1) throws Throwable;

    public abstract void modifyMessage(ExchangeMessage var1, String[] var2, Object[] var3) throws Throwable;

    public abstract void deleteMessages(String[] var1) throws Throwable;

    public abstract void deleteMessages(String[] var1, String var2) throws Throwable;

    public abstract void addMessageAttachments(String var1, String[] var2, Object[] var3) throws Throwable;

    public abstract ArrayList getMessageAttachments(String var1, boolean var2) throws Throwable;

    public abstract ArrayList getMessageAttachments(String var1, boolean var2, String var3) throws Throwable;

    public abstract void deleteMessageAttachments(String var1, String[] var2) throws Throwable;

    public abstract void deleteMessageAttachments(String var1, String[] var2, String var3) throws Throwable;

    public abstract ArrayList getMessageMeetingInfo(String var1, String var2) throws Throwable;

    public abstract boolean isOpen();

    public abstract ArrayList getSubFolders(String var1, boolean var2) throws Throwable;

    public abstract void moveMessages(MessageFilterInfo var1, String var2) throws Throwable;

    public abstract void createFolder(String var1, ExchangeFolderExtendedInfo var2) throws Throwable;

    public abstract ExchangeFolder getExchangeFolderInfo(String var1, boolean var2, String var3);

    public abstract ExchangeFolderExtendedInfo getExchangeExtendedFolderInfo(String var1, boolean var2, String var3);

    public abstract ArrayList getSubFolders(String var1, FolderFilterInfo var2);

    public abstract String copyFolder(String var1, String var2);

    public abstract void deleteFolder(String[] var1, DeleteType var2);

    public abstract String moveFolder(String var1, String var2);

    public abstract void updateFolder(String var1, ExchangeFolderExtendedInfo var2);

    public abstract void emptyFolder(String var1, DeleteType var2, boolean var3);

    public abstract ArrayList getRoomList();

    public abstract ArrayList getRooms(EmailAddress var1);

    public abstract CFUserAvailability getUserAvailability(List<String> var1, Date var2, Date var3, AvailabilityData var4);

    public abstract ArrayList getConversations(String var1, CFConversationFilter var2);

    public abstract void copyConversations(String var1, String var2, String var3);

    public abstract void moveConversations(String var1, String var2, String var3);

    public abstract void setReadStateToConversations(String var1, String var2, boolean var3);

    public abstract void deleteConversations(String var1, String var2, DeleteType var3);

    public String formBasedLogin() throws Throwable {
        String string;
        CloseableHttpClient client = null;
        try {
            CloseableHttpResponse response;
            int status;
            ExchangeLoginInfo loginInfo = this.getLoginInfo();
            String url = loginInfo.getUrlForFormedBasedAuthentication();
            HttpPost postMethod = new HttpPost(url);
            postMethod.addHeader((Header)new BasicHeader("Content-Type", "application/x-www-form-urlencoded"));
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("destination", loginInfo.getExchangeUrl()));
            params.add(new BasicNameValuePair("username", loginInfo.getMailId()));
            params.add(new BasicNameValuePair("password", loginInfo.getUserPassword()));
            postMethod.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
            String proxyHost = loginInfo.getProxyHost();
            int proxyPort = loginInfo.getProxyPort();
            HttpClientBuilder clientBuilder = HttpClientBuilder.create();
            if (proxyHost != null) {
                HttpHost proxy = new HttpHost(proxyHost, proxyPort);
                clientBuilder.setProxy(proxy);
            }
            if ((status = (response = (client = clientBuilder.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(1, false)).build()).execute((HttpUriRequest)postMethod)).getStatusLine().getStatusCode()) != 200) {
                if (status == 302) {
                    String cookies;
                    String string2 = cookies = response.getFirstHeader("Set-Cookie").getValue();
                    return string2;
                }
                ClientProtocolException excp = new ClientProtocolException(response.getStatusLine().toString());
                throw excp;
            }
            string = null;
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (Exception exception) {}
            }
        }
        return string;
    }

    public Object getMetadata() {
        ExchangeLoginInfo loginInfo = this.getLoginInfo();
        Struct mp = new Struct();
        mp.put("ExchangeHost", loginInfo.getExchangeHost());
        mp.put("MailBoxName", loginInfo.getMailBoxName());
        mp.put("MailId", loginInfo.getMailId());
        int portVal = -1;
        portVal = loginInfo.getPort();
        if (portVal == -1) {
            portVal = 80;
        }
        mp.put("Port", new Integer(portVal));
        mp.put("Protocol", loginInfo.getProtocol());
        String proxyHost = loginInfo.getProxyHost();
        if (proxyHost != null) {
            mp.put("ProxyHost", proxyHost);
        }
        if ((portVal = loginInfo.getProxyPort()) != -1) {
            mp.put("ProxyPort", new Integer(portVal));
        }
        return mp;
    }

    public String getLabel() {
        return "ExchangeConnection";
    }

    public char getExchangeServerDecimalSeperator() {
        String language = this.loginInfo.getExchangeServerLanguage();
        if (language == null) {
            return '.';
        }
        if ((language = language.toLowerCase()).equals("english") || language.length() == 0) {
            return '.';
        }
        if (language.startsWith("bulgaria") || language.startsWith("spanish") || language.startsWith("spain") || language.startsWith("french") || language.startsWith("german") || language.startsWith("chinese") || language.startsWith("china") || language.startsWith("croatia") || language.startsWith("czech") || language.startsWith("danish") || language.startsWith("denmark") || language.startsWith("dutch") || language.startsWith("netherlands") || language.startsWith("greek") || language.startsWith("greece") || language.startsWith("hungarian") || language.startsWith("hungary") || language.startsWith("iceland") || language.startsWith("indonesia") || language.startsWith("bahasa") || language.startsWith("italian") || language.startsWith("italy") || language.startsWith("latvia") || language.startsWith("lithuania") || language.startsWith("norwegian") || language.startsWith("norway") || language.startsWith("bokmal") || language.startsWith("polish") || language.startsWith("poland") || language.startsWith("romania") || language.startsWith("russia") || language.startsWith("serbia") || language.startsWith("slovak") || language.startsWith("slovenia") || language.startsWith("swedish") || language.startsWith("sweden") || language.startsWith("turkish") || language.startsWith("turkey") || language.startsWith("ukrain") || language.startsWith("vietnam")) {
            return ',';
        }
        return '.';
    }
}

