/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.jfif;

import com.drew.imaging.jpeg.JpegSegmentMetadataReader;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.lang.ByteArrayReader;
import com.drew.lang.RandomAccessReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.jfif.JfifDirectory;
import java.io.IOException;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JfifReader
implements JpegSegmentMetadataReader,
MetadataReader {
    public static final String PREAMBLE = "JFIF";

    @Override
    @NotNull
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Arrays.asList(JpegSegmentType.APP0);
    }

    @Override
    public void readJpegSegments(@NotNull Iterable<byte[]> iterable, @NotNull Metadata metadata, @NotNull JpegSegmentType jpegSegmentType) {
        for (byte[] byArray : iterable) {
            if (byArray.length < 4 || !PREAMBLE.equals(new String(byArray, 0, PREAMBLE.length()))) continue;
            this.extract(new ByteArrayReader(byArray), metadata);
        }
    }

    @Override
    public void extract(@NotNull RandomAccessReader randomAccessReader, @NotNull Metadata metadata) {
        JfifDirectory jfifDirectory = new JfifDirectory();
        metadata.addDirectory(jfifDirectory);
        try {
            int n = randomAccessReader.getUInt16(5);
            jfifDirectory.setInt(5, n);
            short s = randomAccessReader.getUInt8(7);
            jfifDirectory.setInt(7, s);
            int n2 = randomAccessReader.getUInt16(8);
            jfifDirectory.setInt(8, n2);
            int n3 = randomAccessReader.getUInt16(10);
            jfifDirectory.setInt(10, n3);
        }
        catch (IOException iOException) {
            jfifDirectory.addError(iOException.getMessage());
        }
    }
}

