/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import com.drew.lang.annotations.Nullable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteTrie<T> {
    private final ByteTrieNode<T> _root = new ByteTrieNode();
    private int _maxDepth;

    @Nullable
    public T find(byte[] byArray) {
        ByteTrieNode byteTrieNode = this._root;
        Object object = byteTrieNode._value;
        for (byte by : byArray) {
            ByteTrieNode byteTrieNode2 = (ByteTrieNode)byteTrieNode._children.get(by);
            if (byteTrieNode2 == null) break;
            byteTrieNode = byteTrieNode2;
            if (byteTrieNode._value == null) continue;
            object = byteTrieNode._value;
        }
        return (T)object;
    }

    public void addPath(T t, byte[] ... byArray) {
        int n = 0;
        ByteTrieNode<T> byteTrieNode = this._root;
        byte[][] byArray2 = byArray;
        int n2 = byArray2.length;
        for (int i = 0; i < n2; ++i) {
            byte[] byArray3;
            for (byte by : byArray3 = byArray2[i]) {
                ByteTrieNode<T> byteTrieNode2 = (ByteTrieNode<T>)((ByteTrieNode)byteTrieNode)._children.get(by);
                if (byteTrieNode2 == null) {
                    byteTrieNode2 = new ByteTrieNode<T>();
                    ((ByteTrieNode)byteTrieNode)._children.put(by, byteTrieNode2);
                }
                byteTrieNode = byteTrieNode2;
                ++n;
            }
        }
        byteTrieNode.setValue(t);
        this._maxDepth = Math.max(this._maxDepth, n);
    }

    public void setDefaultValue(T t) {
        this._root.setValue(t);
    }

    public int getMaxDepth() {
        return this._maxDepth;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ByteTrieNode<T> {
        private final Map<Byte, ByteTrieNode<T>> _children = new HashMap<Byte, ByteTrieNode<T>>();
        private T _value = null;

        ByteTrieNode() {
        }

        public void setValue(T t) {
            if (this._value != null) {
                throw new RuntimeException("Value already set for this trie node");
            }
            this._value = t;
        }
    }
}

