/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.document;

import coldfusion.document.BreezeXmlTags;
import coldfusion.document.SlideData;
import coldfusion.util.XmlUtils;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BreezeXmlBuilder
implements BreezeXmlTags {
    private Document document;
    private Element root;
    private Element speakers;
    private Element backgrounds;
    private int counter = 0;
    private Element slides;
    private File file;

    public BreezeXmlBuilder(File file) throws ParserConfigurationException {
        this.file = file;
        this.document = XmlUtils.createNewDocument();
        this.document.appendChild(this.document.createElement("presentation"));
        this.root = this.document.getDocumentElement();
    }

    public void setWidth(int width) {
        this.root.setAttribute("width", "" + width);
    }

    public void setHeight(int height) {
        this.root.setAttribute("height", "" + height);
    }

    public void setStartMode(String mode) {
        this.root.setAttribute("start", mode);
    }

    public void setLoop(boolean loop) {
        this.root.setAttribute("loop", String.valueOf(loop));
    }

    public void setPresentationTitle(String title) {
        XmlUtils.addTextNode((Element)this.root, (String)"presentationTitle", (String)title);
    }

    public void setPresentationDesc(String desc) {
        XmlUtils.addTextNode((Element)this.root, (String)"presentationDescription", (String)desc);
    }

    public void addSpeaker(String name, String title, String email, String image, String biography, String logo) {
        if (this.speakers == null) {
            this.speakers = XmlUtils.addNode((Element)this.root, (String)"speakers");
        }
        Element speaker = XmlUtils.addNode((Element)this.speakers, (String)"speaker");
        XmlUtils.addTextNode((Element)speaker, (String)"name", (String)name);
        if (title != null) {
            XmlUtils.addTextNode((Element)speaker, (String)"speakerTitle", (String)title);
        }
        if (image != null) {
            XmlUtils.addTextNode((Element)speaker, (String)"image", (String)image);
        }
        if (email != null) {
            XmlUtils.addTextNode((Element)speaker, (String)"email", (String)email);
        }
        if (biography != null) {
            XmlUtils.addTextNode((Element)speaker, (String)"bio", (String)biography);
        }
        if (logo != null) {
            XmlUtils.addTextNode((Element)speaker, (String)"logo", (String)logo);
        }
    }

    public void addBackGround(String url) {
        if (this.backgrounds == null) {
            this.backgrounds = XmlUtils.addNode((Element)this.root, (String)"backgrounds");
        }
        Element background = XmlUtils.addNode((Element)this.backgrounds, (String)"background");
        background.setAttribute("url", url);
    }

    public void setSearchXml(String url) {
        Element searchEl = XmlUtils.addNode((Element)this.root, (String)"search");
        searchEl.setAttribute("url", url);
    }

    public void addSlide(SlideData slideData) {
        if (this.slides == null) {
            this.slides = XmlUtils.addNode((Element)this.root, (String)"slides");
        }
        Element slide = XmlUtils.addNode((Element)this.slides, (String)"slide");
        slide.setAttribute("id", "" + ++this.counter);
        slide.setAttribute("type", "normal");
        slide.setAttribute("frameRate", "30");
        slide.setAttribute("totalFrames", "" + (slideData.getDuration() * 30 + 1));
        if (slideData.getAdvance() != null) {
            slide.setAttribute("advance", slideData.getAdvance());
        }
        XmlUtils.addTextNode((Element)slide, (String)"slideTitle", (String)slideData.getTitle());
        Element content = XmlUtils.addNode((Element)slide, (String)"content");
        String wrapper = slideData.getWrapper();
        String slideUrl = wrapper == null ? slideData.getUrl() : wrapper;
        content.setAttribute("url", slideUrl);
        if (slideData.getAudioUrl() != null) {
            Element audio = XmlUtils.addNode((Element)slide, (String)"audio");
            audio.setAttribute("url", slideData.getAudioUrl());
        }
        if (slideData.getVideoUrl() != null) {
            Element video = XmlUtils.addNode((Element)slide, (String)"video");
            video.setAttribute("url", slideData.getVideoUrl());
        }
        if (slideData.getNotes() != null) {
            XmlUtils.addTextNode((Element)slide, (String)"notes", (String)slideData.getNotes());
        }
        if (wrapper != null) {
            Element embeddedContents = XmlUtils.addNode((Element)slide, (String)"embeddedContents");
            Element embedSlideElement = XmlUtils.addNode((Element)embeddedContents, (String)"embeddedContent");
            embedSlideElement.setAttribute("url", slideData.getUrl());
            embedSlideElement.setAttribute("container", "mediaContainer.flash1.content");
            embedSlideElement.setAttribute("duration", "0");
            embedSlideElement.setAttribute("PlayAfterTime", "0");
            int width = slideData.getWidth();
            int height = slideData.getHeight();
            float scale = slideData.getScale();
            embedSlideElement.setAttribute("x", "" + slideData.getX());
            embedSlideElement.setAttribute("y", "" + slideData.getY());
            embedSlideElement.setAttribute("height", "" + height);
            embedSlideElement.setAttribute("width", "" + width);
            embedSlideElement.setAttribute("xScale", "" + scale);
            embedSlideElement.setAttribute("yScale", "" + scale);
        }
        if (slideData.getSpeakerIndex() != -1) {
            Element speaker = XmlUtils.addNode((Element)slide, (String)"slideSpeaker");
            speaker.setAttribute("index", "" + slideData.getSpeakerIndex());
        }
        Element background = XmlUtils.addNode((Element)slide, (String)"slideBackground");
        background.setAttribute("index", "" + slideData.getBackgroundIndex());
        background.setAttribute("frameToPlay", "1");
        background.setAttribute("duration", "2");
    }

    public void save() throws IOException {
        XmlUtils.saveDocument((Document)this.document, (File)this.file);
    }
}

