/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.exchange;

import coldfusion.exchange.ExchangeConnection;
import coldfusion.exchange.ExchangeMessage;
import coldfusion.exchange.MessageFilterInfo;
import coldfusion.exchange.webdav.Utils;
import coldfusion.exchange.webdav.WebDAVExceptions;
import coldfusion.tagext.net.exchange.ExchangeExceptions;
import coldfusion.tagext.net.exchange.ExchangeMailTag;
import coldfusion.tagext.net.exchange.MailConstants;
import coldfusion.tagext.net.exchange.MailMeetingQuery;
import coldfusion.tagext.net.exchange.MailQuery;
import coldfusion.tagext.validation.RequiredAttributesException;
import java.util.ArrayList;
import java.util.Map;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class MailTagHelper
implements MailConstants {
    public static void getMessages(ExchangeMailTag tag) {
        boolean getHeaders;
        String folderId;
        MessageFilterInfo filter;
        String folder;
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = tag.getConnection(false);
        if (con == null) {
            con = tag.createConnection();
            getTempConnection = true;
        }
        if ((folder = (filter = tag.getFilterInfo()).getFolder()) == null && tag.getFolder() != null) {
            filter.setFolder(tag.getFolder());
        }
        if ((folder = filter.getFolder()) != null && folder.trim().length() == 0) {
            filter.setFolder(null);
        }
        if ((folderId = filter.getFolderId()) == null && tag.getFolderId() != null) {
            filter.setFolderId(tag.getFolderId());
        }
        if ((folderId = filter.getFolderId()) != null && folderId.trim().length() == 0) {
            filter.setFolderId(null);
        }
        if (getHeaders = tag.getGetHeaders()) {
            filter.setGetHeaders(true);
        }
        ArrayList results = null;
        try {
            results = con.getMessages(filter);
        }
        catch (WebDAVExceptions we) {
            if (we.getWebDAVCode() == 404) {
                ExchangeExceptions.throwMailResourceNotFoundException();
            }
            tag.processException(we);
        }
        catch (Throwable t) {
            tag.processException(t);
        }
        MailQuery queryResult = new MailQuery();
        queryResult.populate(results);
        tag.getPageContext().setAttribute(tag.getName(), (Object)queryResult);
        if (getTempConnection) {
            con.closeConnection();
        }
    }

    public static void saveMail(ExchangeMailTag tag, Map msgMap, boolean isNew) {
        String uidVarName;
        if (!isNew && tag.getUid() != null && tag.getUid().indexOf(44) != -1) {
            ExchangeExceptions.throwMultipleUIDsInModifyActionException("cfexchangemail");
        }
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = tag.getConnection(false);
        if (con == null) {
            con = tag.createConnection();
            getTempConnection = true;
        }
        ExchangeMessage msg = new ExchangeMessage();
        Boolean tmpBool = null;
        String bcc = tag.getStringAttribute(msgMap, "BCC", false);
        try {
            if (bcc != null) {
                InternetAddress.parse((String)bcc, (boolean)true);
            }
        }
        catch (AddressException e) {
            ExchangeExceptions.throwInvalidEmailException("BCC");
        }
        msg.setBcc(bcc);
        String cc = tag.getStringAttribute(msgMap, "CC", false);
        try {
            if (cc != null) {
                InternetAddress.parse((String)cc, (boolean)true);
            }
        }
        catch (AddressException e) {
            ExchangeExceptions.throwInvalidEmailException("CC");
        }
        msg.setCc(cc);
        String folder = null;
        folder = tag.getFolder();
        if (folder != null && folder.trim().length() > 0) {
            msg.setFolder(folder);
        } else {
            msg.setFolder(null);
        }
        String folderId = null;
        folderId = tag.getFolderId();
        if (folderId != null && folderId.trim().length() > 0) {
            msg.setFolderId(folderId);
        } else {
            msg.setFolderId(null);
        }
        String fromId = tag.getStringAttribute(msgMap, "FromId", false);
        try {
            if (fromId != null) {
                InternetAddress.parse((String)fromId, (boolean)true);
            }
        }
        catch (AddressException e) {
            ExchangeExceptions.throwInvalidEmailException("FromId");
        }
        msg.setFromId(fromId);
        String toId = tag.getStringAttribute(msgMap, "ToId", false);
        try {
            if (toId != null) {
                InternetAddress.parse((String)toId, (boolean)true);
            }
        }
        catch (AddressException e) {
            ExchangeExceptions.throwInvalidEmailException("ToId");
        }
        msg.setToId(toId);
        tmpBool = tag.getBooleanAttribute(msgMap, "HasAttachment", false);
        msg.setHasAttachment(tmpBool == null ? false : tmpBool);
        String importance = tag.getStringAttribute(msgMap, "Importance", false);
        if (importance != null) {
            if (!tag.validateImportance(importance)) {
                ExchangeExceptions.throwInvalidImportanceException("Importance");
            }
            msg.setImportance(importance);
        }
        msg.setMessage(tag.getStringAttribute(msgMap, "Message", false));
        tmpBool = tag.getBooleanAttribute(msgMap, "IsRead", false);
        msg.setRead(tmpBool == null ? false : tmpBool);
        String sensitivity = tag.getStringAttribute(msgMap, "Sensitivity", false);
        if (sensitivity != null) {
            if (!tag.validateSensitivity(sensitivity)) {
                ExchangeExceptions.throwInvalidSensitivityException("Sensitivity");
            }
            msg.setSensitivity(sensitivity);
        }
        msg.setSubject(tag.getStringAttribute(msgMap, "Subject", false));
        msg.setTimeReceived(tag.getDateAttribute(msgMap, "TimeReceived", false));
        msg.setTimeSent(tag.getDateAttribute(msgMap, "TimeSent", false));
        msg.setToId(tag.getStringAttribute(msgMap, "ToId", false));
        String attachmentPaths = tag.getStringAttribute(msgMap, "attachments", false);
        String[] attachedFileNames = null;
        Object[] attachedFilecontent = null;
        if (attachmentPaths != null) {
            Object[] tmpArray = tag.readAttachmentFiles(attachmentPaths);
            attachedFileNames = (String[])tmpArray[0];
            attachedFilecontent = (Object[])tmpArray[1];
        }
        if (!isNew) {
            String id = tag.getUid();
            if (id == null) {
                throw new RequiredAttributesException(tag.getTagPublicName(), "uid");
            }
            msg.setId(id);
        }
        try {
            if (isNew) {
                if (attachmentPaths != null) {
                    con.createMessage(msg, attachedFileNames, attachedFilecontent);
                } else {
                    con.createMessage(msg, null, null);
                }
            } else if (attachmentPaths != null) {
                con.modifyMessage(msg, attachedFileNames, attachedFilecontent);
            } else {
                con.modifyMessage(msg);
            }
        }
        catch (Throwable t) {
            tag.processException(t);
        }
        if (isNew && (uidVarName = tag.getResult()) != null) {
            tag.getPageContext().setAttribute(uidVarName, (Object)msg.getId());
        }
        if (getTempConnection) {
            con.closeConnection();
        }
    }

    static void deleteMessages(ExchangeMailTag tag) {
        String uids;
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = tag.getConnection(false);
        if (con == null) {
            con = tag.createConnection();
            getTempConnection = true;
        }
        if ((uids = tag.getUid()) == null) {
            throw new RequiredAttributesException(tag.getTagPublicName(), "uid");
        }
        String[] uidArray = Utils.splitString(uids);
        String folder = tag.getFolder();
        if (folder != null && folder.trim().length() == 0) {
            folder = null;
        }
        try {
            con.deleteMessages(uidArray, folder);
        }
        catch (Throwable t) {
            tag.processException(t);
        }
        if (getTempConnection) {
            con.closeConnection();
        }
    }

    static void getMeetingInfo(ExchangeMailTag tag, String meetingUID, String mailUID) {
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = tag.getConnection(false);
        if (con == null) {
            con = tag.createConnection();
            getTempConnection = true;
        }
        ArrayList meetings = null;
        try {
            meetings = con.getMessageMeetingInfo(meetingUID, mailUID);
        }
        catch (Throwable t) {
            tag.processException(t);
        }
        MailMeetingQuery queryResult = new MailMeetingQuery();
        queryResult.populate(meetings);
        tag.getPageContext().setAttribute(tag.getName(), (Object)queryResult);
        if (getTempConnection) {
            con.closeConnection();
        }
    }

    static void moveMailMessages(ExchangeMailTag tag) {
        String folderId;
        MessageFilterInfo filter;
        String folder;
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = tag.getConnection(false);
        if (con == null) {
            con = tag.createConnection();
            getTempConnection = true;
        }
        if ((folder = (filter = tag.getFilterInfo()).getFolder()) == null && tag.getFolder() != null) {
            filter.setFolder(tag.getFolder());
        }
        if ((folder = filter.getFolder()) != null && folder.trim().length() == 0) {
            filter.setFolder(null);
        }
        if ((folderId = filter.getFolderId()) == null && tag.getFolderId() != null) {
            filter.setFolderId(tag.getFolderId());
        }
        if ((folderId = filter.getFolderId()) != null && folderId.trim().length() == 0) {
            filter.setFolderId(null);
        }
        try {
            con.moveMessages(filter, tag.getDestinationFolder());
        }
        catch (WebDAVExceptions we) {
            int code = we.getWebDAVCode();
            if (code == 409) {
                ExchangeExceptions.throwMailFolderNotFoundException(tag.getDestinationFolder());
            }
            tag.processException(we);
        }
        catch (Throwable t) {
            tag.processException(t);
        }
        if (getTempConnection) {
            con.closeConnection();
        }
    }
}

