/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.exchange.webservice;

import coldfusion.exchange.webdav.Utils;
import coldfusion.exchange.webservice.CFConversationFilter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import microsoft.exchange.webservices.data.core.service.item.Conversation;

public class CFConversation {
    private String conversationId;
    private String topic;
    private List<String> uniqueRecipients = new ArrayList<String>();
    private List<String> globalUniqueRecipients = new ArrayList<String>();
    private List<String> uniqueUnreadSenders = new ArrayList<String>();
    private List<String> globalUniqueUnreadSenders = new ArrayList<String>();
    private List<String> uniqueSenders = new ArrayList<String>();
    private List<String> globalUniqueSenders = new ArrayList<String>();
    private Date lastDeliveryTime;
    private Date globalLastDeliveryTime;
    private List<String> categories = new ArrayList<String>();
    private List<String> globalCategories = new ArrayList<String>();
    private String flagStatus;
    private String globalFlagStatus;
    private Boolean hasAttachments;
    private Boolean globalHasAttachments;
    private int messageCount;
    private int globalMessageCount;
    private int unreadCount;
    private int globalUnreadCount;
    private int size;
    private int globalSize;
    private List<String> itemClasses = new ArrayList<String>();
    private List<String> globalItemClasses = new ArrayList<String>();
    private String importance;
    private String globalImportance;
    private List<String> itemIds = new ArrayList<String>();
    private List<String> globalItemIds = new ArrayList<String>();
    private Conversation conversation;

    public String getId() {
        return this.conversationId;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getUniqueRecipients() {
        return this.createCommaSeparatedStringValue(this.uniqueRecipients);
    }

    private String createCommaSeparatedStringValue(List<String> list) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String uniqueRecipient : list) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append(uniqueRecipient);
        }
        return builder.toString();
    }

    public String getGlobalUniqueRecipients() {
        return this.createCommaSeparatedStringValue(this.globalUniqueRecipients);
    }

    public String getUniqueUnreadSenders() {
        return this.createCommaSeparatedStringValue(this.uniqueUnreadSenders);
    }

    public String getGlobalUniqueUnreadSenders() {
        return this.createCommaSeparatedStringValue(this.globalUniqueUnreadSenders);
    }

    public String getUniqueSenders() {
        return this.createCommaSeparatedStringValue(this.uniqueSenders);
    }

    public String getGlobalUniqueSenders() {
        return this.createCommaSeparatedStringValue(this.globalUniqueSenders);
    }

    public Date getLastDeliveryTime() {
        return this.lastDeliveryTime;
    }

    public Date getGlobalLastDeliveryTime() {
        return this.globalLastDeliveryTime;
    }

    public String getCategories() {
        return this.createCommaSeparatedStringValue(this.categories);
    }

    public String getGlobalCategories() {
        return this.createCommaSeparatedStringValue(this.globalCategories);
    }

    public String getFlagStatus() {
        return this.flagStatus;
    }

    public String getGlobalFlagStatus() {
        return this.globalFlagStatus;
    }

    public Boolean getHasAttachments() {
        return this.hasAttachments;
    }

    public Boolean getGlobalHasAttachments() {
        return this.globalHasAttachments;
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    public int getGlobalMessageCount() {
        return this.globalMessageCount;
    }

    public int getUnreadCount() {
        return this.unreadCount;
    }

    public int getGlobalUnreadCount() {
        return this.globalUnreadCount;
    }

    public int getSize() {
        return this.size;
    }

    public int getGlobalSize() {
        return this.globalSize;
    }

    public String getItemClasses() {
        return this.createCommaSeparatedStringValue(this.itemClasses);
    }

    public String getGlobalItemClasses() {
        return this.createCommaSeparatedStringValue(this.globalItemClasses);
    }

    public String getImportance() {
        return this.importance;
    }

    public String getGlobalImportance() {
        return this.globalImportance;
    }

    public String getItemIds() {
        return this.createCommaSeparatedStringValue(this.itemIds);
    }

    public String getGlobalItemIds() {
        return this.createCommaSeparatedStringValue(this.globalItemIds);
    }

    public void addCategory(String category) {
        this.categories.add(category);
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setLastDeliveryTime(Date lastDeliveryTime) {
        this.lastDeliveryTime = lastDeliveryTime;
    }

    public void setGlobalLastDeliveryTime(Date globalLastDeliveryTime) {
        this.globalLastDeliveryTime = globalLastDeliveryTime;
    }

    public void setFlagStatus(String flagStatus) {
        this.flagStatus = flagStatus;
    }

    public void setGlobalFlagStatus(String globalFlagStatus) {
        this.globalFlagStatus = globalFlagStatus;
    }

    public void setHasAttachments(Boolean hasAttachments) {
        this.hasAttachments = hasAttachments;
    }

    public void setGlobalHasAttachments(Boolean globalHasAttachments) {
        this.globalHasAttachments = globalHasAttachments;
    }

    public void setMessageCount(int messageCount) {
        this.messageCount = messageCount;
    }

    public void setGlobalMessageCount(int globalMessageCount) {
        this.globalMessageCount = globalMessageCount;
    }

    public void setUnreadCount(int unreadCount) {
        this.unreadCount = unreadCount;
    }

    public void setGlobalUnreadCount(int globalUnreadCount) {
        this.globalUnreadCount = globalUnreadCount;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setGlobalSize(int globalSize) {
        this.globalSize = globalSize;
    }

    public void setImportance(String importance) {
        this.importance = importance;
    }

    public void setGlobalImportance(String globalImportance) {
        this.globalImportance = globalImportance;
    }

    public void addGlobalCategory(String globalCategory) {
        this.globalCategories.add(globalCategory);
    }

    public void addGlobalItemClass(String globalItemClass) {
        this.globalItemClasses.add(globalItemClass);
    }

    public void addGlobalItemId(String uniqueId) {
        this.globalItemIds.add(uniqueId);
    }

    public void addGlobalUniqueRecipient(String globalUniqueRecipient) {
        this.globalUniqueRecipients.add(globalUniqueRecipient);
    }

    public void addGlobalUniqueSender(String globalUniqueSender) {
        this.globalUniqueSenders.add(globalUniqueSender);
    }

    public void addGlobalUniqueUnreadSender(String globalUniqueUnreadSender) {
        this.globalUniqueUnreadSenders.add(globalUniqueUnreadSender);
    }

    public void setId(String uniqueId) {
        this.conversationId = uniqueId;
    }

    public void addItemClass(String itemClass) {
        this.itemClasses.add(itemClass);
    }

    public void addItemId(String uniqueId) {
        this.itemIds.add(uniqueId);
    }

    public void addUniqueRecipient(String uniqueRecipient) {
        this.uniqueRecipients.add(uniqueRecipient);
    }

    public void addUniqueSender(String uniqueSender) {
        this.uniqueSenders.add(uniqueSender);
    }

    public void addUniqueUnreadSender(String uniqueUnreadSender) {
        this.uniqueUnreadSenders.add(uniqueUnreadSender);
    }

    public void setUniqueRecipients(String uniqueRecipients) {
        String[] splits;
        for (String uniqueRecipient : splits = Utils.splitString(uniqueRecipients)) {
            this.addUniqueRecipient(uniqueRecipient.trim());
        }
    }

    public void setGlobalUniqueRecipients(String globalUniqueRecipients) {
        String[] splits;
        for (String globalUniqueRecipient : splits = Utils.splitString(globalUniqueRecipients)) {
            this.addGlobalUniqueRecipient(globalUniqueRecipient.trim());
        }
    }

    public void setUniqueUnreadSenders(String uniqueUnreadSenders) {
        String[] splits;
        for (String uniqueUnreadSender : splits = Utils.splitString(uniqueUnreadSenders)) {
            this.addUniqueUnreadSender(uniqueUnreadSender.trim());
        }
    }

    public void setGlobalUniqueUnreadSenders(String globalUniqueUnreadSenders) {
        String[] splits;
        for (String globalUniqueUnreadSender : splits = Utils.splitString(globalUniqueUnreadSenders)) {
            this.addGlobalUniqueUnreadSender(globalUniqueUnreadSender.trim());
        }
    }

    public void setUniqueSenders(String uniqueSenders) {
        String[] splits;
        for (String uniqueSender : splits = Utils.splitString(uniqueSenders)) {
            this.addUniqueSender(uniqueSender.trim());
        }
    }

    public void setGlobalUniqueSenders(String globalUniqueSenders) {
        String[] splits;
        for (String globalUniqueSender : splits = Utils.splitString(globalUniqueSenders)) {
            this.addGlobalUniqueSender(globalUniqueSender.trim());
        }
    }

    public void setCategories(String categories) {
        String[] splits;
        for (String category : splits = Utils.splitString(categories)) {
            this.addCategory(category.trim());
        }
    }

    public void setGlobalCategories(String globalCategories) {
        String[] splits;
        for (String globalCategory : splits = Utils.splitString(globalCategories)) {
            this.addGlobalCategory(globalCategory.trim());
        }
    }

    public void setItemClasses(String itemClasses) {
        String[] splits;
        for (String itemClass : splits = Utils.splitString(itemClasses)) {
            this.addItemClass(itemClass.trim());
        }
    }

    public void setGlobalItemClasses(String globalItemClasses) {
        String[] splits;
        for (String globalItemClass : splits = Utils.splitString(globalItemClasses)) {
            this.addGlobalItemClass(globalItemClass.trim());
        }
    }

    public void setItemIds(String itemIds) {
        String[] splits;
        for (String itemId : splits = Utils.splitString(itemIds)) {
            this.addItemId(itemId.trim());
        }
    }

    public void setGlobalItemIds(String globalItemIds) {
        String[] splits;
        for (String globalItemId : splits = Utils.splitString(globalItemIds)) {
            this.addGlobalItemId(globalItemId.trim());
        }
    }

    public boolean matchFilter(CFConversationFilter filter) {
        if (null != filter.getId() && !filter.getId().equals(this.conversationId)) {
            return false;
        }
        if (!this.compareListAndString(filter.getCategories(), this.categories)) {
            return false;
        }
        String flagStatus = filter.getFlagStatus();
        if (null != flagStatus && flagStatus.trim().length() > 0) {
            if (null != this.flagStatus) {
                if (!this.flagStatus.toUpperCase().startsWith(flagStatus.toUpperCase())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (!this.compareFromValue(filter.getFromGlobalLastDeliveryTime(), this.globalLastDeliveryTime)) {
            return false;
        }
        if (!this.compareFromValue(filter.getFromGlobalMessageCount(), this.globalMessageCount)) {
            return false;
        }
        if (!this.compareFromValue(filter.getFromGlobalSize(), this.globalSize)) {
            return false;
        }
        if (!this.compareFromValue(filter.getFromGlobalUnreadCount(), this.globalUnreadCount)) {
            return false;
        }
        if (!this.compareFromValue(filter.getFromMessageCount(), this.messageCount)) {
            return false;
        }
        if (!this.compareFromValue(filter.getFromSize(), this.size)) {
            return false;
        }
        if (!this.compareFromValue(filter.getFromLastDeliveryTime(), this.lastDeliveryTime)) {
            return false;
        }
        if (!this.compareFromValue(filter.getFromUnreadCount(), this.unreadCount)) {
            return false;
        }
        if (!this.compareListAndString(filter.getGlobalCategories(), this.globalCategories)) {
            return false;
        }
        String globalFlagStatus = filter.getGlobalFlagStatus();
        if (null != globalFlagStatus && globalFlagStatus.trim().length() > 0) {
            if (null != this.globalFlagStatus) {
                if (!this.globalFlagStatus.toUpperCase().startsWith(globalFlagStatus.toUpperCase())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (null != filter.getGlobalHasAttachments() && filter.getGlobalHasAttachments() != this.globalHasAttachments) {
            return false;
        }
        if (!this.compareStringValue(filter.getGlobalImportance(), this.globalImportance)) {
            return false;
        }
        if (!this.compareListAndString(filter.getGlobalCategories(), this.globalCategories)) {
            return false;
        }
        if (!this.compareListAndString(filter.getGlobalItemClasses(), this.globalItemClasses)) {
            return false;
        }
        if (!this.compareListAndString(filter.getGlobalItemIds(), this.globalItemIds)) {
            return false;
        }
        if (!this.compareListAndString(filter.getGlobalUniqueRecipients(), this.globalUniqueRecipients)) {
            return false;
        }
        if (!this.compareListAndString(filter.getGlobalUniqueSenders(), this.globalUniqueSenders)) {
            return false;
        }
        if (!this.compareListAndString(filter.getGlobalUniqueUnreadSenders(), this.globalUniqueUnreadSenders)) {
            return false;
        }
        if (null != filter.getHasAttachments() && filter.getHasAttachments() != this.hasAttachments) {
            return false;
        }
        if (!this.compareStringValue(filter.getImportance(), this.importance)) {
            return false;
        }
        if (!this.compareListAndString(filter.getItemClasses(), this.itemClasses)) {
            return false;
        }
        if (!this.compareListAndString(filter.getItemIds(), this.itemIds)) {
            return false;
        }
        if (!this.compareToValue(filter.getToGlobalLastDeliveryTime(), this.globalLastDeliveryTime)) {
            return false;
        }
        if (!this.compareToValue(filter.getToGlobalMessageCount(), this.globalMessageCount)) {
            return false;
        }
        if (!this.compareToValue(filter.getToGlobalSize(), this.globalSize)) {
            return false;
        }
        if (!this.compareToValue(filter.getToGlobalUnreadCount(), this.globalUnreadCount)) {
            return false;
        }
        if (!this.compareToValue(filter.getToLastDeliveryTime(), this.lastDeliveryTime)) {
            return false;
        }
        if (!this.compareToValue(filter.getToMessageCount(), this.messageCount)) {
            return false;
        }
        if (!this.compareStringValue(filter.getTopic(), this.topic)) {
            return false;
        }
        if (!this.compareToValue(filter.getToSize(), this.size)) {
            return false;
        }
        if (!this.compareToValue(filter.getToUnreadCount(), this.unreadCount)) {
            return false;
        }
        if (!this.compareListAndString(filter.getUniqueRecipients(), this.uniqueRecipients)) {
            return false;
        }
        if (!this.compareListAndString(filter.getUniqueSenders(), this.uniqueSenders)) {
            return false;
        }
        return false != this.compareListAndString(filter.getUniqueUnreadSenders(), this.uniqueUnreadSenders);
    }

    private boolean compareFromValue(int filterValue, int conversationValue) {
        if (-1 != filterValue) {
            if (-1 != conversationValue) {
                if (filterValue > conversationValue) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean compareToValue(int filterValue, int conversationValue) {
        if (-1 != filterValue) {
            if (-1 != conversationValue) {
                if (conversationValue > filterValue) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean compareFromValue(Date filterValue, Date conversationValue) {
        if (null != filterValue) {
            if (null != conversationValue) {
                return filterValue.compareTo(conversationValue) <= 0;
            }
            return false;
        }
        return true;
    }

    private boolean compareToValue(Date filterValue, Date conversationValue) {
        if (null != filterValue) {
            if (null != conversationValue) {
                return filterValue.compareTo(conversationValue) >= 0;
            }
            return false;
        }
        return true;
    }

    private boolean compareStringValue(String filterValue, String conversationValue) {
        if (null != filterValue && filterValue.trim().length() > 0) {
            if (null != conversationValue) {
                if (!conversationValue.toUpperCase().contains(filterValue.toUpperCase())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean compareListAndString(String filterValue, List<String> conversationValue) {
        if (null != filterValue && filterValue.trim().length() > 0) {
            String[] splits;
            for (String split : splits = Utils.splitString(filterValue)) {
                boolean matchFound = false;
                for (String listElement : conversationValue) {
                    if (!listElement.toUpperCase().contains(split.toUpperCase())) continue;
                    matchFound = true;
                }
                if (matchFound) continue;
                return false;
            }
        }
        return true;
    }

    public void setConversation(Conversation conversation) {
        this.conversation = conversation;
    }

    public Conversation getConversation() {
        return this.conversation;
    }
}

