/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.s3.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.runtime.Struct;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.s3.model.Tag;

class TagConsumer
extends ConsumerMap<Tag.Builder> {
    private static TagConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TagConsumer getInstance() {
        if (instance != null) return instance;
        Class<TagConsumer> clazz = TagConsumer.class;
        synchronized (TagConsumer.class) {
            instance = new TagConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private TagConsumer() {
        this.put("key", new ConsumerValidator((tag, value) -> {
            String input = FieldTypecastUtil.INSTANCE.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"key");
            tag.key(input);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("value", new ConsumerValidator((tag, value) -> {
            String input = FieldTypecastUtil.INSTANCE.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"value");
            tag.value(input);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
    }

    Struct getStruct(Tag tag) {
        Struct struct = new Struct();
        struct.put((Object)"key", (Object)tag.key());
        struct.put((Object)"value", (Object)tag.value());
        return struct;
    }

    public List<Struct> getStructList(List<Tag> tags) {
        return tags.stream().map(this::getStruct).collect(Collectors.toList());
    }
}

