/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.s3.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.runtime.Struct;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.s3.model.NoncurrentVersionTransition;
import software.amazon.awssdk.services.s3.model.TransitionStorageClass;

public class NoncurrentVersionTransitionConsumer
extends ConsumerMap<NoncurrentVersionTransition.Builder> {
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static NoncurrentVersionTransitionConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NoncurrentVersionTransitionConsumer getInstance() {
        if (instance != null) return instance;
        Class<NoncurrentVersionTransitionConsumer> clazz = NoncurrentVersionTransitionConsumer.class;
        synchronized (NoncurrentVersionTransitionConsumer.class) {
            instance = new NoncurrentVersionTransitionConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private NoncurrentVersionTransitionConsumer() {
        this.put("days", new ConsumerValidator((builder, value) -> builder.noncurrentDays(Integer.valueOf(this.cast.getIntegerProperty(value))), Collections.emptyList()));
        this.put("storageClass", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"storageClass");
            builder.storageClass(TransitionStorageClass.valueOf((String)input));
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
    }

    public List<Struct> getStruct(List<NoncurrentVersionTransition> noncurrentVersionTransitions) {
        return ((List)Optional.ofNullable(noncurrentVersionTransitions).orElse(new LinkedList())).stream().map(noncurrentVersionTransition -> {
            Struct struct = new Struct();
            struct.put((Object)"days", (Object)noncurrentVersionTransition.noncurrentDays());
            if (Objects.nonNull(noncurrentVersionTransition.storageClass())) {
                struct.put((Object)"storageClass", (Object)noncurrentVersionTransition.storageClass().name());
            }
            return struct;
        }).collect(Collectors.toList());
    }

    public Struct getStruct(NoncurrentVersionTransition noncurrentVersionTransition) {
        Struct struct = new Struct();
        struct.put((Object)"days", (Object)noncurrentVersionTransition.noncurrentDays());
        struct.put((Object)"storageClass", (Object)noncurrentVersionTransition.storageClass().name());
        return struct;
    }
}

